/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries;

import com.idark.valoria.registries.item.enchantments.AccuracyEnchantment;
import com.idark.valoria.registries.item.enchantments.BleedingEnchantment;
import com.idark.valoria.registries.item.enchantments.ExplosiveFlameEnchantment;
import com.idark.valoria.registries.item.types.ranged.BlazeReapItem;
import com.idark.valoria.registries.item.types.ranged.bows.PhantasmBow;
import java.util.function.Supplier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class EnchantmentsRegistry {
    public static final DeferredRegister<Enchantment> ENCHANTMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)"valoria");
    public static final EnchantmentCategory BLAZE = EnchantmentCategory.create((String)"blaze", item -> item instanceof BlazeReapItem);
    public static final EnchantmentCategory ACCURACY_CATEGORY = EnchantmentCategory.create((String)"accuracy_category", item -> item instanceof PhantasmBow);
    public static final RegistryObject<Enchantment> EXPLOSIVE_FLAME = EnchantmentsRegistry.registerEnchantment("explosive_flame", ExplosiveFlameEnchantment::new);
    public static final RegistryObject<Enchantment> BLEEDING = EnchantmentsRegistry.registerEnchantment("bleeding", BleedingEnchantment::new);
    public static final RegistryObject<Enchantment> ACCURACY = EnchantmentsRegistry.registerEnchantment("accuracy", AccuracyEnchantment::new);

    private static RegistryObject<Enchantment> registerEnchantment(String id, Supplier<Enchantment> enchantment) {
        return ENCHANTMENTS.register(id, enchantment);
    }

    public static void register(IEventBus eventBus) {
        ENCHANTMENTS.register(eventBus);
    }
}

