/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets.particle;

import com.idark.valoria.Valoria;
import com.idark.valoria.client.particle.ParticleRegistry;
import com.idark.valoria.util.Pal;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.client.render.TridotRenderTypes;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.ArcRandom;

public class SmokeParticlePacket {
    private final double posX;
    private final double posY;
    private final double posZ;
    private final float velX;
    private final float velY;
    private final float velZ;
    private final int count;
    private final int colorR;
    private final int colorG;
    private final int colorB;

    public SmokeParticlePacket(int count, double posX, double posY, double posZ, float velX, float velY, float velZ, int colorR, int colorG, int colorB) {
        this.count = count;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.velX = velX;
        this.velY = velY;
        this.velZ = velZ;
        this.colorR = colorR;
        this.colorG = colorG;
        this.colorB = colorB;
    }

    public static void packetSmokeParticles(SmokeParticlePacket msg, Level level, ColorParticleData color) {
        ArcRandom random = Tmp.rnd;
        ((ParticleBuilder)((ParticleBuilder)ParticleBuilder.create(ParticleRegistry.SMOKE).setRenderType(TridotRenderTypes.TRANSLUCENT_PARTICLE).setColorData(color).setTransparencyData(GenericParticleData.create().setRandomValue(0.0f, 0.6f, 0.0f, 0.0f).build()).setScaleData(GenericParticleData.create((float)0.92f, (float)0.0f).build()).setLifetime(95 + random.nextInt(100)).randomVelocity((double)msg.velX, (double)msg.velY, (double)msg.velZ)).randomOffset((double)0.025f)).spawn(level, msg.posX, msg.posY, msg.posZ);
    }

    public static SmokeParticlePacket decode(FriendlyByteBuf buf) {
        return new SmokeParticlePacket(buf.readInt(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void handle(SmokeParticlePacket msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                Level level = Valoria.proxy.getLevel();
                Col color = new Col(msg.colorR, msg.colorG, msg.colorB);
                for (int i = 0; i < msg.count; ++i) {
                    SmokeParticlePacket.packetSmokeParticles(msg, level, ColorParticleData.create((Col)color, (Col)Pal.darkestGray).build());
                }
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.count);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeFloat(this.velX);
        buf.writeFloat(this.velY);
        buf.writeFloat(this.velZ);
        buf.writeInt(this.colorR);
        buf.writeInt(this.colorG);
        buf.writeInt(this.colorB);
    }
}

