/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets.particle;

import com.idark.valoria.Valoria;
import com.idark.valoria.util.Pal;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.RegistryObject;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.util.Col;

public class ManipulatorCraftParticlePacket {
    private final double posX;
    private final double posY;
    private final double posZ;
    private final float posToX;
    private final float posToY;
    private final float posToZ;
    private final int colorR;
    private final int colorG;
    private final int colorB;

    public ManipulatorCraftParticlePacket(double posX, double posY, double posZ, float posToX, float posToY, float posToZ, int colorR, int colorG, int colorB) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.posToX = posToX;
        this.posToY = posToY;
        this.posToZ = posToZ;
        this.colorR = colorR;
        this.colorG = colorG;
        this.colorB = colorB;
    }

    public static ManipulatorCraftParticlePacket decode(FriendlyByteBuf buf) {
        return new ManipulatorCraftParticlePacket(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void handle(ManipulatorCraftParticlePacket msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                Level pLevel = Valoria.proxy.getLevel();
                Vec3 particlePos = new Vec3(msg.posX + (double)0.85f, msg.posY + (double)1.1f, msg.posZ + (double)0.85f);
                ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.WISP).setColorData(ColorParticleData.create((Col)Pal.infernalBright, (Col)Col.black).build()).setTransparencyData(GenericParticleData.create((float)1.25f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)0.025f, (float)0.1f).build()).setLifetime(8).setVelocity((double)-0.05f, (double)0.025f, (double)-0.05f)).spawn(pLevel, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_);
                Vec3 particlePos1 = new Vec3(msg.posX + (double)0.15f, msg.posY + (double)1.1f, msg.posZ + (double)0.15f);
                ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.WISP).setColorData(ColorParticleData.create((Col)Pal.nature, (Col)Col.black).build()).setTransparencyData(GenericParticleData.create((float)1.25f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)0.025f, (float)0.1f).build()).setLifetime(8).setVelocity((double)0.05f, (double)0.025f, (double)0.05f)).spawn(pLevel, particlePos1.f_82479_, particlePos1.f_82480_, particlePos1.f_82481_);
                Vec3 particlePos2 = new Vec3(msg.posX + (double)0.85f, msg.posY + (double)1.1f, msg.posZ + (double)0.15f);
                ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.WISP).setColorData(ColorParticleData.create((Col)Pal.oceanic, (Col)Col.black).build()).setTransparencyData(GenericParticleData.create((float)1.25f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)0.025f, (float)0.1f).build()).setLifetime(8).setVelocity((double)-0.05f, (double)0.025f, (double)0.05f)).spawn(pLevel, particlePos2.f_82479_, particlePos2.f_82480_, particlePos2.f_82481_);
                Vec3 particlePos3 = new Vec3(msg.posX + (double)0.15f, msg.posY + (double)1.1f, msg.posZ + (double)0.85f);
                ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.WISP).setColorData(ColorParticleData.create((Col)Pal.vividCyan, (Col)Col.black).build()).setTransparencyData(GenericParticleData.create((float)1.25f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)0.025f, (float)0.1f).build()).setLifetime(8).setVelocity((double)0.05f, (double)0.025f, (double)-0.05f)).spawn(pLevel, particlePos3.f_82479_, particlePos3.f_82480_, particlePos3.f_82481_);
                Vec3 particlePos4 = new Vec3(msg.posX + 0.5, msg.posY + 1.0, msg.posZ + 0.5);
                ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.WISP).setColorData(ColorParticleData.create((Col)Col.white, (Col)Col.black).build()).setTransparencyData(GenericParticleData.create((float)1.25f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)0.025f, (float)0.1f).build()).setLifetime(12).setVelocity(0.0, (double)0.025f, 0.0)).spawn(pLevel, particlePos4.f_82479_, particlePos4.f_82480_, particlePos4.f_82481_);
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeFloat(this.posToX);
        buf.writeFloat(this.posToY);
        buf.writeFloat(this.posToZ);
        buf.writeInt(this.colorR);
        buf.writeInt(this.colorG);
        buf.writeInt(this.colorB);
    }
}

