/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets.particle;

import com.idark.valoria.Valoria;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.RegistryObject;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.util.Col;

public class CubeShapedParticlePacket {
    private final double posX;
    private final double posY;
    private final double posZ;
    private final int colorR;
    private final int colorG;
    private final int colorB;
    private final float speedY;
    private final float size;

    public CubeShapedParticlePacket(double posX, double posY, double posZ, float size, float speedY, int colorR, int colorG, int colorB) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.speedY = speedY;
        this.size = size;
        this.colorR = colorR;
        this.colorG = colorG;
        this.colorB = colorB;
    }

    public static CubeShapedParticlePacket decode(FriendlyByteBuf buf) {
        return new CubeShapedParticlePacket(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readFloat(), buf.readFloat(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void handle(CubeShapedParticlePacket msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                Level level = Valoria.proxy.getLevel();
                Col color = new Col(msg.colorR, msg.colorG, msg.colorB);
                float size = msg.size;
                int i = 0;
                while ((float)i < 25.0f * size) {
                    double pOffset = Math.sin(i) * (double)size;
                    Vec3 pos0 = new Vec3(msg.posX + (double)size, msg.posY, msg.posZ + pOffset);
                    Vec3 pos1 = new Vec3(msg.posX - (double)size, msg.posY, msg.posZ + pOffset);
                    Vec3 pos2 = new Vec3(msg.posX + pOffset, msg.posY, msg.posZ - (double)size);
                    Vec3 pos3 = new Vec3(msg.posX - pOffset, msg.posY, msg.posZ + (double)size);
                    ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.WISP).setColorData(ColorParticleData.create((Col)color, (Col)Col.black).build()).setTransparencyData(GenericParticleData.create((float)1.25f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)0.2f, (float)0.1f, (float)0.0f).build()).setLifetime(6).addVelocity(0.0, (double)msg.speedY, 0.0)).spawn(level, pos0.f_82479_, pos0.f_82480_, pos0.f_82481_);
                    ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.WISP).setColorData(ColorParticleData.create((Col)color, (Col)Col.black).build()).setTransparencyData(GenericParticleData.create((float)1.25f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)0.2f, (float)0.1f, (float)0.0f).build()).setLifetime(6).addVelocity(0.0, (double)msg.speedY, 0.0)).spawn(level, pos1.f_82479_, pos1.f_82480_, pos1.f_82481_);
                    ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.WISP).setColorData(ColorParticleData.create((Col)color, (Col)Col.black).build()).setTransparencyData(GenericParticleData.create((float)1.25f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)0.2f, (float)0.1f, (float)0.0f).build()).setLifetime(6).addVelocity(0.0, (double)msg.speedY, 0.0)).spawn(level, pos2.f_82479_, pos2.f_82480_, pos2.f_82481_);
                    ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.WISP).setColorData(ColorParticleData.create((Col)color, (Col)Col.black).build()).setTransparencyData(GenericParticleData.create((float)1.25f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)0.2f, (float)0.1f, (float)0.0f).build()).setLifetime(6).addVelocity(0.0, (double)msg.speedY, 0.0)).spawn(level, pos3.f_82479_, pos3.f_82480_, pos3.f_82481_);
                    ++i;
                }
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeFloat(this.size);
        buf.writeFloat(this.speedY);
        buf.writeInt(this.colorR);
        buf.writeInt(this.colorG);
        buf.writeInt(this.colorB);
    }
}

