/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets;

import com.idark.valoria.Valoria;
import com.idark.valoria.client.ui.toast.PageToast;
import com.idark.valoria.core.config.ClientConfig;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class PageToastPacket {
    private final Item stack;
    private final UUID uuid;
    private final boolean unlock;

    public PageToastPacket(UUID uuid, Item stack, boolean pUnlock) {
        this.uuid = uuid;
        this.stack = stack;
        this.unlock = pUnlock;
    }

    public PageToastPacket(Player entity, Item stack, boolean pUnlock) {
        this.uuid = entity.m_20148_();
        this.stack = stack;
        this.unlock = pUnlock;
    }

    public static void encode(PageToastPacket object, FriendlyByteBuf buffer) {
        buffer.m_130077_(object.uuid);
        buffer.m_130055_(object.stack.m_7968_());
        buffer.writeBoolean(object.unlock);
    }

    public static PageToastPacket decode(FriendlyByteBuf buffer) {
        return new PageToastPacket(buffer.m_130259_(), buffer.m_130267_().m_41720_(), buffer.readBoolean());
    }

    public static void handle(PageToastPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT);
            Level world = Valoria.proxy.getLevel();
            Player player = world.m_46003_(packet.uuid);
            if (player != null) {
                if (packet.unlock) {
                    player.m_5496_(SoundEvents.f_11887_, 0.5f, 1.0f);
                    player.m_5496_(SoundEvents.f_11713_, 1.0f, 1.0f);
                }
                PageToastPacket.toast(packet);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void toast(PageToastPacket packet) {
        if (((Boolean)ClientConfig.SHOW_TOASTS.get()).booleanValue()) {
            PageToast.addOrUpdate(Minecraft.m_91087_().m_91300_(), packet.stack, packet.unlock);
        }
    }
}

