/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets;

import com.idark.valoria.Valoria;
import com.idark.valoria.client.ui.toast.MusicToast;
import com.idark.valoria.core.config.ClientConfig;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class MusicToastPacket {
    private final UUID uuid;
    public String music;
    public String author;

    public MusicToastPacket(UUID uuid, String music, String author) {
        this.uuid = uuid;
        this.author = author;
        this.music = music;
    }

    public MusicToastPacket(Player entity, String music, String author) {
        this.uuid = entity.m_20148_();
        this.author = author;
        this.music = music;
    }

    public MusicToastPacket(Player entity, SoundEvent event) {
        this.uuid = entity.m_20148_();
        this.author = event.m_11660_().m_214298_() + ".author";
        this.music = event.m_11660_().m_214298_() + ".name";
    }

    public static void encode(MusicToastPacket object, FriendlyByteBuf buffer) {
        buffer.m_130077_(object.uuid);
        buffer.m_130070_(object.music);
        buffer.m_130070_(object.author);
    }

    public static MusicToastPacket decode(FriendlyByteBuf buffer) {
        return new MusicToastPacket(buffer.m_130259_(), buffer.m_130277_(), buffer.m_130277_());
    }

    public static void handle(MusicToastPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT);
            Level world = Valoria.proxy.getLevel();
            Player player = world.m_46003_(packet.uuid);
            if (player != null) {
                MusicToastPacket.toast(packet);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void toast(MusicToastPacket packet) {
        if (((Boolean)ClientConfig.SHOW_TOASTS.get()).booleanValue()) {
            Minecraft.m_91087_().m_91300_().m_94922_((Toast)new MusicToast(packet.music, packet.author));
        }
    }
}

