/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.compat.jei.categories;

import com.idark.valoria.core.compat.jei.ModRecipeTypes;
import com.idark.valoria.registries.BlockRegistry;
import com.idark.valoria.registries.item.recipe.ManipulatorRecipe;
import java.util.Arrays;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import pro.komaru.tridot.client.ClientTick;

public class ManipulatorRecipeCategory
extends AbstractRecipeCategory<ManipulatorRecipe> {
    private final IDrawable background;

    public ManipulatorRecipeCategory(IGuiHelper helper) {
        super(ModRecipeTypes.MANIPULATOR, (Component)Component.m_237115_((String)"jei.valoria.manipulator"), helper.createDrawableItemLike((ItemLike)BlockRegistry.elementalManipulator.get()), 148, 48);
        ResourceLocation backgroundImage = new ResourceLocation("valoria", "textures/gui/jei/manipulator.png");
        this.background = helper.createDrawable(backgroundImage, 0, 0, 148, 48);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ManipulatorRecipe recipe, IFocusGroup focusGroup) {
        NonNullList<Ingredient> recipeIngredients = recipe.m_7527_();
        ItemStack resultStack = recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_);
        builder.addSlot(RecipeIngredientRole.INPUT, 4, 16).addItemStacks(Arrays.asList(((Ingredient)recipeIngredients.get(0)).m_43908_()));
        builder.addSlot(RecipeIngredientRole.INPUT, 63, 16).addItemStacks(Arrays.asList(((Ingredient)recipeIngredients.get(1)).m_43908_()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 125, 16).addItemStack(resultStack);
    }

    public void draw(ManipulatorRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics gui, double mouseX, double mouseY) {
        this.background.draw(gui);
        Font font_renderer = Minecraft.m_91087_().f_91062_;
        int ticks = recipe.getTime();
        int seconds = ticks / 20;
        String time = Integer.toString(seconds);
        int stringWidth = font_renderer.m_92895_(time);
        ResourceLocation timeIcon = new ResourceLocation("valoria", "textures/gui/jei/time.png");
        Objects.requireNonNull(font_renderer);
        gui.m_280163_(timeIcon, 25, 29 + 9, 0.0f, 0.0f, 7, 7, 16, 16);
        ResourceLocation cores = new ResourceLocation("valoria", "textures/gui/container/manipulator.png");
        ResourceLocation arrow = new ResourceLocation("valoria", "textures/gui/jei/progress_arrow.png");
        int width = 22;
        if (ClientTick.ticksInGame % recipe.getTime() > 0) {
            width = (int)((double)width / ((double)recipe.getTime() / (double)(ClientTick.ticksInGame % recipe.getTime())));
            gui.m_280163_(arrow, 90, 16, 0.0f, 0.0f, width, 16, 32, 32);
        }
        if (recipe.getCore().equals("infernal_core")) {
            gui.m_280163_(cores, 0, 0, 362.0f, 54.0f, 10, 10, 512, 512);
        }
        if (recipe.getCore().equals("nature_core")) {
            gui.m_280163_(cores, 0, 0, 372.0f, 54.0f, 10, 10, 512, 512);
        }
        if (recipe.getCore().equals("aquarius_core")) {
            gui.m_280163_(cores, 0, 0, 352.0f, 54.0f, 10, 10, 512, 512);
        }
        if (recipe.getCore().equals("void_core")) {
            gui.m_280163_(cores, 0, 0, 382.0f, 54.0f, 10, 10, 512, 512);
        }
        if (mouseX >= 0.0 && mouseX < 8.0 && mouseY >= 0.0 && mouseY < 8.0) {
            gui.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"tooltip.valoria.core_charges").m_130946_(": " + recipe.getCoresNeeded() + "/8"), -34, -2);
        }
        String string = time + "s";
        int n = (95 - stringWidth) / 2;
        Objects.requireNonNull(font_renderer);
        gui.m_280488_(font_renderer, string, n, 28 + 9, 0xFFFFFF);
    }
}

