/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.command;

import com.idark.valoria.api.unlockable.UnlockUtils;
import com.idark.valoria.api.unlockable.types.Unlockable;
import com.idark.valoria.core.capability.INihilityLevel;
import com.idark.valoria.core.command.parts.CommandArguments;
import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.PageToastPacket;
import com.idark.valoria.core.network.packets.UnlockableUpdatePacket;
import com.idark.valoria.registries.ItemsRegistry;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import pro.komaru.tridot.api.command.CommandArgument;
import pro.komaru.tridot.api.command.CommandBuilder;
import pro.komaru.tridot.api.command.CommandPart;
import pro.komaru.tridot.api.command.CommandVariant;

public class ModCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        CommandArgument targets = CommandArgument.entities((String)"targets");
        CommandArguments pages = CommandArguments.pages("pages");
        CommandArgument nihility = CommandArgument.integer((String)"nihility");
        CommandArgument charges = CommandArgument.integer((String)"charges", (int)0, (int)2);
        CommandBuilder codex = new CommandBuilder("codex").permission(p -> p.m_6761_(2));
        CommandBuilder builder = new CommandBuilder("valoria").variants(new CommandVariant[]{codex.variants(new CommandVariant[]{new CommandVariant(new CommandPart[]{CommandPart.create((String)"addAll"), targets}).execute(p -> {
            ModCommand.giveAllPages((CommandSourceStack)p.getSource(), targets.getPlayers(p));
            return 1;
        }), new CommandVariant(new CommandPart[]{CommandPart.create((String)"add"), targets, pages}).execute(p -> {
            ModCommand.givePage((CommandSourceStack)p.getSource(), targets.getPlayers(p), pages.getPages(p, "pages"));
            return 1;
        }), new CommandVariant(new CommandPart[]{CommandPart.create((String)"removeAll"), targets}).execute(p -> {
            ModCommand.removeAllPages((CommandSourceStack)p.getSource(), targets.getPlayers(p));
            return 1;
        }), new CommandVariant(new CommandPart[]{CommandPart.create((String)"remove"), targets, pages}).execute(p -> {
            ModCommand.removePage((CommandSourceStack)p.getSource(), targets.getPlayers(p), pages.getPages(p, "pages"));
            return 1;
        })}), new CommandVariant(new CommandPart[]{CommandPart.create((String)"setCharge"), targets, charges}).execute(p -> {
            ModCommand.setCharge((CommandSourceStack)p.getSource(), targets.getPlayers(p), charges.getInt(p), p);
            return 1;
        }), new CommandVariant(new CommandPart[]{CommandPart.create((String)"addNihility"), targets, nihility}).execute(p -> {
            ModCommand.addNihilityLevel((CommandSourceStack)p.getSource(), targets.getPlayers(p), nihility.getInt(p));
            return 1;
        }), new CommandVariant(new CommandPart[]{CommandPart.create((String)"decreaseNihility"), targets, nihility}).execute(p -> {
            ModCommand.decreaseNihilityLevel((CommandSourceStack)p.getSource(), targets.getPlayers(p), nihility.getInt(p));
            return 1;
        }), new CommandVariant(new CommandPart[]{CommandPart.create((String)"setNihility"), targets, nihility}).execute(p -> {
            ModCommand.setNihilityLevel((CommandSourceStack)p.getSource(), targets.getPlayers(p), nihility.getInt(p));
            return 1;
        })});
        dispatcher.register(builder.permission(p -> p.m_6761_(2)).build());
    }

    private static void giveAllPages(CommandSourceStack command, Collection<? extends ServerPlayer> targetPlayers) throws CommandSyntaxException {
        for (ServerPlayer serverPlayer : targetPlayers) {
            if (targetPlayers.size() == 1) {
                command.m_288197_(() -> Component.m_237110_((String)"commands.valoria.page.give.single", (Object[])new Object[]{((ServerPlayer)targetPlayers.iterator().next()).m_5446_()}), true);
            } else {
                command.m_288197_(() -> Component.m_237110_((String)"commands.valoria.page.give.multiple", (Object[])new Object[]{targetPlayers.size()}), true);
            }
            UnlockUtils.addAll(serverPlayer);
            PacketHandler.sendTo(serverPlayer, (Object)new PageToastPacket((Player)serverPlayer, (Item)ItemsRegistry.page.get(), true));
        }
    }

    private static void removeAllPages(CommandSourceStack command, Collection<? extends ServerPlayer> targetPlayers) throws CommandSyntaxException {
        for (ServerPlayer serverPlayer : targetPlayers) {
            if (targetPlayers.size() == 1) {
                command.m_288197_(() -> Component.m_237110_((String)"commands.valoria.page.remove.single", (Object[])new Object[]{((ServerPlayer)targetPlayers.iterator().next()).m_5446_()}), true);
            } else {
                command.m_288197_(() -> Component.m_237110_((String)"commands.valoria.page.remove.multiple", (Object[])new Object[]{targetPlayers.size()}), true);
            }
            UnlockUtils.removeAll(serverPlayer);
            PacketHandler.sendTo(serverPlayer, (Object)new PageToastPacket((Player)serverPlayer, (Item)ItemsRegistry.page.get(), false));
        }
    }

    private static void givePage(CommandSourceStack command, Collection<? extends ServerPlayer> targetPlayers, Unlockable pages) throws CommandSyntaxException {
        for (ServerPlayer serverPlayer : targetPlayers) {
            if (targetPlayers.size() == 1) {
                command.m_288197_(() -> Component.m_237110_((String)"commands.valoria.page.give.single", (Object[])new Object[]{((ServerPlayer)targetPlayers.iterator().next()).m_5446_()}), true);
            } else {
                command.m_288197_(() -> Component.m_237110_((String)"commands.valoria.page.give.multiple", (Object[])new Object[]{targetPlayers.size()}), true);
            }
            UnlockUtils.add(serverPlayer, pages);
            PacketHandler.sendTo(serverPlayer, (Object)new UnlockableUpdatePacket((Player)serverPlayer));
            PacketHandler.sendTo(serverPlayer, (Object)new PageToastPacket((Player)serverPlayer, (Item)ItemsRegistry.page.get(), true));
        }
    }

    private static void removePage(CommandSourceStack command, Collection<? extends ServerPlayer> targetPlayers, Unlockable pages) throws CommandSyntaxException {
        for (ServerPlayer serverPlayer : targetPlayers) {
            if (targetPlayers.size() == 1) {
                command.m_288197_(() -> Component.m_237110_((String)"commands.valoria.page.remove.single", (Object[])new Object[]{((ServerPlayer)targetPlayers.iterator().next()).m_5446_()}), true);
            } else {
                command.m_288197_(() -> Component.m_237110_((String)"commands.valoria.page.remove.multiple", (Object[])new Object[]{targetPlayers.size()}), true);
            }
            UnlockUtils.remove(serverPlayer, pages);
            PacketHandler.sendTo(serverPlayer, (Object)new UnlockableUpdatePacket((Player)serverPlayer));
            PacketHandler.sendTo(serverPlayer, (Object)new PageToastPacket((Player)serverPlayer, (Item)ItemsRegistry.page.get(), false));
        }
    }

    public static void decreaseNihilityLevel(CommandSourceStack command, Collection<? extends ServerPlayer> targetPlayers, int amount) {
        for (ServerPlayer serverPlayer : targetPlayers) {
            if (targetPlayers.size() == 1) {
                command.m_288197_(() -> Component.m_237110_((String)"commands.valoria.nihility.decrease.single", (Object[])new Object[]{amount, ((ServerPlayer)targetPlayers.iterator().next()).m_5446_()}), true);
            } else {
                command.m_288197_(() -> Component.m_237110_((String)"commands.valoria.nihility.decrease.multiple", (Object[])new Object[]{amount, targetPlayers.size()}), true);
            }
            serverPlayer.getCapability(INihilityLevel.INSTANCE).ifPresent(nihilityLevel -> nihilityLevel.decrease((Player)player, amount));
        }
    }

    public static void addNihilityLevel(CommandSourceStack command, Collection<? extends ServerPlayer> targetPlayers, int amount) {
        for (ServerPlayer serverPlayer : targetPlayers) {
            if (targetPlayers.size() == 1) {
                command.m_288197_(() -> Component.m_237110_((String)"commands.valoria.nihility.add.single", (Object[])new Object[]{amount, ((ServerPlayer)targetPlayers.iterator().next()).m_5446_()}), true);
            } else {
                command.m_288197_(() -> Component.m_237110_((String)"commands.valoria.nihility.add.multiple", (Object[])new Object[]{amount, targetPlayers.size()}), true);
            }
            serverPlayer.getCapability(INihilityLevel.INSTANCE).ifPresent(nihilityLevel -> nihilityLevel.modifyAmount((LivingEntity)player, amount));
        }
    }

    public static void setNihilityLevel(CommandSourceStack command, Collection<? extends ServerPlayer> targetPlayers, int amount) {
        for (ServerPlayer serverPlayer : targetPlayers) {
            if (targetPlayers.size() == 1) {
                command.m_288197_(() -> Component.m_237110_((String)"commands.valoria.nihility.set.single", (Object[])new Object[]{amount, ((ServerPlayer)targetPlayers.iterator().next()).m_5446_()}), true);
            } else {
                command.m_288197_(() -> Component.m_237110_((String)"commands.valoria.nihility.set.multiple", (Object[])new Object[]{amount, targetPlayers.size()}), true);
            }
            serverPlayer.getCapability(INihilityLevel.INSTANCE).ifPresent(nihilityLevel -> nihilityLevel.setAmount((LivingEntity)player, amount));
        }
    }

    public static void setCharges(ItemStack stack, int value) {
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128405_("charge", value);
    }

    private static void setCharge(CommandSourceStack command, Collection<? extends ServerPlayer> targetPlayers, int pCharge, CommandContext p) throws CommandSyntaxException {
        for (ServerPlayer serverPlayer : targetPlayers) {
            ModCommand.setCharges(serverPlayer.m_21206_(), pCharge);
            ModCommand.setCharges(serverPlayer.m_21205_(), pCharge);
            command.m_288197_(() -> Component.m_237110_((String)"commands.valoria.charges.set.add", (Object[])new Object[]{pCharge}).m_130946_(" to " + player.m_7755_().getString()), true);
        }
    }
}

