/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.capability;

import com.idark.valoria.core.capability.INihilityLevel;
import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.NihilityPacket;
import com.idark.valoria.registries.AttributeReg;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.INBTSerializable;

public class NihilityLevelProvider
implements INihilityLevel,
INBTSerializable<CompoundTag> {
    public static float clientMax;
    public static float clientAmount;
    public float nihilityAmount = 0.0f;

    @Override
    public void modifyAmount(@Nullable LivingEntity entity, float amount) {
        this.setAmount(entity, this.nihilityAmount + amount);
    }

    @Override
    public void decrease(Player player, float amount) {
        this.modifyAmount((LivingEntity)player, -amount);
    }

    @Override
    public void setAmount(@Nullable LivingEntity entity, float amount) {
        float max = this.getMaxAmount(entity, false);
        this.nihilityAmount = amount > max ? max : Math.max(amount, 0.0f);
        this.sendDataToClient(entity);
    }

    @Override
    public float getAmount(boolean clientSide) {
        if (clientSide) {
            return clientAmount;
        }
        return this.nihilityAmount;
    }

    @Override
    public float getMaxAmount(@Nullable LivingEntity entity, boolean clientSide) {
        if (clientSide) {
            return clientMax;
        }
        if (entity != null && entity.m_21051_((Attribute)AttributeReg.MAX_NIHILITY.get()) != null) {
            return (float)entity.m_21133_((Attribute)AttributeReg.MAX_NIHILITY.get());
        }
        return 100.0f;
    }

    private void sendDataToClient(@Nullable LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PacketHandler.sendToTracking(player.m_9236_(), player.m_20183_(), new NihilityPacket(this, (LivingEntity)player));
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag wrapper = new CompoundTag();
        wrapper.m_128350_("nihility_level", this.nihilityAmount);
        return wrapper;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.nihilityAmount = nbt.m_128457_("nihility_level");
    }
}

