/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.ui.screen.book.codex;

import com.idark.valoria.Valoria;
import com.idark.valoria.api.unlockable.UnlockUtils;
import com.idark.valoria.api.unlockable.types.Unlockable;
import com.idark.valoria.client.ui.screen.book.Chapter;
import com.idark.valoria.client.ui.screen.book.codex.ChapterNode;
import com.idark.valoria.client.ui.screen.book.codex.Codex;
import com.idark.valoria.client.ui.screen.book.codex.Style;
import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.UnlockCodexPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CodexEntry {
    public int x;
    public int y;
    public ChapterNode node;
    public boolean isHidden;
    public boolean isRendered;
    public MutableComponent translate;
    public MutableComponent unknownTranslate;

    public CodexEntry(ChapterNode node, int x, int y) {
        this.node = node;
        this.node.entry = this;
        this.translate = Component.m_237115_((String)node.chapter.titleKey);
        this.unknownTranslate = Component.m_237115_((String)node.chapter.unknownKey);
        this.x = x;
        this.y = y;
        this.y += Codex.getInstance().insideHeight / 2 - 66;
    }

    public void hide() {
        this.isHidden = true;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void render(Codex codex, GuiGraphics gui, float uOffset, float vOffset, int guiLeft, int guiTop, float mouseX, float mouseY) {
        int sthy;
        this.isRendered = true;
        int x = (codex.backgroundWidth - codex.insideWidth) / 2 - (this.x - guiLeft) - (int)uOffset;
        int y = (codex.backgroundHeight - codex.insideHeight) / 2 - (this.y - guiTop) - (int)vOffset;
        int entryWidth = 22;
        int entryHeight = 22;
        ResourceLocation loc = Valoria.loc("textures/gui/book/frame.png");
        int stx = this.isUnlocked() ? this.node.style.x : Style.CLOSED.x;
        int sty = this.isUnlocked() ? this.node.style.y : Style.CLOSED.y;
        int sthx = this.isUnlocked() ? this.node.style.hoverX : Style.CLOSED.hoverX;
        int n = sthy = this.isUnlocked() ? this.node.style.hoverY : Style.CLOSED.hoverY;
        if (this.isHover(mouseX, mouseY, x - 12, y - 8) && codex.isOnScreen(mouseX, mouseY)) {
            gui.m_280163_(loc, x, y, (float)sthx, (float)sthy, entryWidth, entryHeight, 512, 512);
            MutableComponent transl = this.isUnlocked() ? this.translate : this.unknownTranslate;
            int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)transl);
            int tooltipX = x + entryWidth - textWidth / 2 - 22;
            int tooltipY = y + entryHeight + 18;
            this.renderTooltip(gui, transl, tooltipX, tooltipY);
        } else {
            gui.m_280163_(loc, x, y, (float)stx, (float)sty, entryWidth, entryHeight, 512, 512);
        }
        if (this.isUnlocked()) {
            gui.m_280168_().m_85836_();
            gui.m_280168_().m_252880_(0.0f, 0.0f, (float)(codex.entries - 100));
            gui.m_280203_(this.node.item.m_7968_(), x + 3, y + 3);
            gui.m_280168_().m_85849_();
        }
    }

    public void onClick(Codex codex, double mouseX, double mouseY, int uOffset, int vOffset) {
        int x = (codex.backgroundWidth - codex.insideWidth) / 2 - (this.x - codex.guiLeft()) - uOffset;
        int y = (codex.backgroundHeight - codex.insideHeight) / 2 - (this.y - codex.guiTop()) - vOffset;
        if (codex.isOnScreen(mouseX, mouseY) && !this.isHidden && this.isRendered && this.isHover(mouseX, mouseY, x - 6, y)) {
            if (this.isUnlocked() && !this.getChapter().pages.isEmpty()) {
                Unlockable unlockable = this.node.unlockable;
                if (unlockable != null && unlockable.hasAwards() && !UnlockUtils.isClaimed(codex.player, unlockable) && !Codex.onClaim(this, unlockable)) {
                    PacketHandler.sendToServer(new UnlockCodexPacket(unlockable.getId()));
                } else {
                    codex.sound(() -> SoundEvents.f_11713_, 1.0f, 1.0f);
                    codex.changeChapter(this.getChapter());
                }
            } else {
                codex.sound(() -> SoundEvents.f_11744_, 1.0f, 1.0f);
            }
        }
        if (codex.isHover(mouseX, mouseY, (int)(codex.cx() - 10.0f), codex.guiTop() + codex.frameHeight - 15, 20, 20)) {
            codex.xOffset = 0.0f;
            codex.yOffset = 0.0f;
            codex.sound(() -> SoundEvents.f_12088_, 1.0f, 1.0f);
        }
    }

    public Chapter getChapter() {
        return this.node.chapter;
    }

    public boolean isHover(double mouseX, double mouseY, int x, int y) {
        return mouseX >= (double)(x + 8) && mouseX <= (double)(x + 8 + 28) && mouseY >= (double)(y + 8) && mouseY <= (double)(y + 8 + 28);
    }

    public void renderTooltip(GuiGraphics gui, MutableComponent component, int x, int y) {
        boolean flag;
        PoseStack pose = gui.m_280168_();
        ArrayList<Object> lines = new ArrayList<Object>();
        lines.add(component);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        boolean bl = flag = player != null && this.node.unlockable != null && this.node.unlockable.hasAwards() && !UnlockUtils.isClaimed((Player)player, this.node.unlockable);
        if (this.isUnlocked()) {
            lines.addAll(this.node.description);
            if (flag) {
                lines.add(Component.m_237113_((String)"Rewards available").m_130940_(ChatFormatting.GOLD));
            }
        } else {
            lines.addAll(this.node.hints);
            if (flag) {
                lines.add(Component.m_237115_((String)"codex.valoria.rewards").m_130940_(ChatFormatting.GOLD));
            }
            if (this.node.unlockable != null && this.node.unlockable.randomObtainable) {
                lines.add(Component.m_237119_());
                lines.add(Component.m_237115_((String)"codex.valoria.random_obtainable").m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
        if (flag) {
            boolean items;
            boolean loot = this.node.unlockable.getLoot() != null;
            boolean bl2 = items = this.node.unlockable.getItems() != null;
            if (loot || items) {
                pose.m_85836_();
                pose.m_252880_(0.0f, 0.0f, 300.0f);
                int itemX = x + 18;
                int itemY = y + lines.size() * 10 - 10;
                if (loot) {
                    gui.m_280480_(new ItemStack((ItemLike)Items.f_151058_), itemX, itemY);
                    itemX += 18;
                }
                if (items) {
                    lines.add(Component.m_237119_());
                    lines.add(Component.m_237119_());
                    for (ItemStack stack : this.node.unlockable.getItems()) {
                        gui.m_280480_(stack, itemX, itemY);
                        gui.m_280370_(Minecraft.m_91087_().f_91062_, stack, itemX, itemY);
                        itemX += 18;
                    }
                }
                pose.m_85849_();
            }
        }
        gui.m_280666_(Minecraft.m_91087_().f_91062_, lines, x, y);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isUnlocked() {
        if (this.node.unlockable == null) {
            return true;
        }
        return UnlockUtils.isUnlocked((Player)Minecraft.m_91087_().f_91074_, this.node.unlockable);
    }
}

