/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.render.tile;

import com.idark.valoria.client.shaders.ShaderRegistry;
import com.idark.valoria.registries.block.entity.ValoriaPortalBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import pro.komaru.tridot.client.render.TridotRenderTypes;

@OnlyIn(value=Dist.CLIENT)
public class ValoriaPortalRenderer<T extends ValoriaPortalBlockEntity>
implements BlockEntityRenderer<T> {
    public static final ResourceLocation BACKGROUND_LOC = new ResourceLocation("valoria", "textures/environment/valoria_portal.png");
    public static final ResourceLocation LAYER_LOC = new ResourceLocation("valoria", "textures/environment/valoria_portal_layer2.png");

    public ValoriaPortalRenderer(BlockEntityRendererProvider.Context pContext) {
    }

    public void render(T pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        Matrix4f matrix4f = pPoseStack.m_85850_().m_252922_();
        this.renderCube(pBlockEntity, matrix4f, TridotRenderTypes.getDelayedRender().m_6299_(this.renderType()));
    }

    private void renderCube(T pBlockEntity, Matrix4f pPose, VertexConsumer pConsumer) {
        float f = this.getOffsetDown();
        float f1 = this.getOffsetUp();
        this.renderFace(pBlockEntity, pPose, pConsumer, 0.0f, 1.0f, f, f, 0.0f, 0.0f, 1.0f, 1.0f, Direction.DOWN);
        this.renderFace(pBlockEntity, pPose, pConsumer, 0.0f, 1.0f, f1, f1, 1.0f, 1.0f, 0.0f, 0.0f, Direction.UP);
    }

    private void renderFace(T pBlockEntity, Matrix4f pPose, VertexConsumer pConsumer, float pX0, float pX1, float pY0, float pY1, float pZ0, float pZ1, float pZ2, float pZ3, Direction pDirection) {
        if (((ValoriaPortalBlockEntity)((Object)pBlockEntity)).shouldRenderFace(pDirection)) {
            pConsumer.m_252986_(pPose, pX0, pY0, pZ0).m_5752_();
            pConsumer.m_252986_(pPose, pX1, pY0, pZ1).m_5752_();
            pConsumer.m_252986_(pPose, pX1, pY1, pZ2).m_5752_();
            pConsumer.m_252986_(pPose, pX0, pY1, pZ3).m_5752_();
        }
    }

    protected float getOffsetUp() {
        return 0.55f;
    }

    protected float getOffsetDown() {
        return 0.435f;
    }

    protected RenderType renderType() {
        return ShaderRegistry.valoriaPortal();
    }
}

