/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.render.entity;

import com.idark.valoria.client.model.entity.TrollModel;
import com.idark.valoria.registries.entity.living.Troll;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pro.komaru.tridot.client.model.render.entity.LuminescentLayer;

@OnlyIn(value=Dist.CLIENT)
public class TrollRenderer
extends MobRenderer<Troll, TrollModel<Troll>> {
    protected ResourceLocation texture;
    private final boolean corrupted;

    public TrollRenderer(EntityRendererProvider.Context context, boolean corrupted) {
        super(context, new TrollModel(TrollModel.createBodyLayer().m_171564_()), 0.8f);
        this.corrupted = corrupted;
        this.texture = new ResourceLocation("valoria", corrupted ? "textures/entity/corrupted_troll.png" : "textures/entity/troll.png");
        this.m_115326_((RenderLayer)new LuminescentLayer.Builder((RenderLayerParent)this).setTexture(new ResourceLocation("valoria", corrupted ? "textures/entity/corrupted_troll_eyes.png" : "textures/entity/troll_eyes_layer.png")).build());
    }

    public void render(Troll pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        if (this.corrupted) {
            Vec3[] avec3 = pEntity.getOffsets();
            float f = this.m_6930_((LivingEntity)pEntity, pPartialTicks);
            for (int i = 0; i < avec3.length; ++i) {
                pPoseStack.m_85836_();
                pPoseStack.m_85837_(avec3[i].f_82479_ + (double)Mth.m_14089_((float)((float)i + f * 0.5f)) * 0.015, avec3[i].f_82480_ + (double)Mth.m_14089_((float)((float)i + f * 0.5f)) * 0.0125, avec3[i].f_82481_ + (double)Mth.m_14089_((float)((float)i + f * 0.7f)) * 0.015);
                super.m_7392_((Mob)pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
                pPoseStack.m_85849_();
            }
        } else {
            super.m_7392_((Mob)pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
        }
    }

    public ResourceLocation getTextureLocation(Troll pEntity) {
        return this.texture;
    }
}

