/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.client.render.curio;

import com.idark.valoria.client.ValoriaLayers;
import com.idark.valoria.client.model.curio.HandsModel;
import com.idark.valoria.client.model.curio.HandsModelSlim;
import com.idark.valoria.registries.item.types.curio.ICurioTexture;
import com.idark.valoria.registries.item.types.curio.hands.DyeableGlovesItem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class HandsRenderer
implements ICurioRenderer {
    public static ResourceLocation TEXTURE = new ResourceLocation("valoria", "textures/entity/necklace/empty.png");

    public boolean isDefault(LivingEntity entity) {
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            return player.m_108564_().equals("default");
        }
        return false;
    }

    public float[] getColor(ItemStack stack) {
        if (stack.m_41720_() instanceof DyeableGlovesItem) {
            int color = ((DyeableLeatherItem)stack.m_41720_()).m_41121_(stack);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            return new float[]{r, g, b};
        }
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity entity = slotContext.entity();
        Item item = stack.m_41720_();
        if (item instanceof ICurioTexture) {
            ICurioTexture curio = (ICurioTexture)item;
            TEXTURE = curio.getTexture(stack, entity);
        }
        float[] color = this.getColor(stack);
        if (this.isDefault(slotContext.entity())) {
            model = new HandsModel(Minecraft.m_91087_().m_167973_().m_171103_(ValoriaLayers.HANDS_LAYER));
            ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{model});
            model.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            model.m_7695_(matrixStack, renderTypeBuffer.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE)), light, OverlayTexture.f_118083_, color[0], color[1], color[2], 1.0f);
        } else {
            model = new HandsModelSlim(Minecraft.m_91087_().m_167973_().m_171103_(ValoriaLayers.HANDS_LAYER_SLIM));
            ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{model});
            model.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            model.m_7695_(matrixStack, renderTypeBuffer.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE)), light, OverlayTexture.f_118083_, color[0], color[1], color[2], 1.0f);
        }
    }
}

