/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.api.unlockable.types;

import com.idark.valoria.api.unlockable.UnlockUtils;
import com.idark.valoria.registries.ItemsRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class Unlockable {
    private ResourceLocation[] loot;
    private ItemStack[] items;
    private int experience;
    public String id;
    public Item icon;
    public final boolean randomObtainable;

    public Unlockable(String id) {
        this((Item)ItemsRegistry.page.get(), id, true);
    }

    public Unlockable(Item icon, String id) {
        this(icon, id, true);
    }

    public Unlockable(String id, boolean rndObtain) {
        this((Item)ItemsRegistry.page.get(), id, rndObtain);
    }

    public Unlockable(Item icon, String id, boolean rndObtain) {
        this.icon = icon;
        this.id = id;
        this.randomObtainable = rndObtain;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{ id='" + this.id + "'}";
    }

    public boolean canObtain(Player player) {
        return false;
    }

    public boolean canObtainByRandom() {
        return this.randomObtainable;
    }

    public boolean hasAwards() {
        return this.items != null || this.loot != null || this.experience > 0;
    }

    public boolean tick(ServerPlayer player) {
        if (this.canObtain((Player)player)) {
            UnlockUtils.add(player, this);
            return true;
        }
        return false;
    }

    public Unlockable addAward(ItemStack ... items) {
        this.items = items;
        return this;
    }

    public Unlockable addAward(ResourceLocation ... loot) {
        this.loot = loot;
        return this;
    }

    public Unlockable exp(int experience) {
        this.experience = experience;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public ResourceLocation[] getLoot() {
        return this.loot;
    }

    public ItemStack[] getItems() {
        return this.items;
    }

    public void award(ServerPlayer pPlayer) {
        pPlayer.m_6756_(this.experience);
        LootParams lootparams = new LootParams.Builder(pPlayer.m_284548_()).m_287286_(LootContextParams.f_81455_, (Object)pPlayer).m_287286_(LootContextParams.f_81460_, (Object)pPlayer.m_20182_()).m_287239_(pPlayer.m_36336_()).m_287235_(LootContextParamSets.f_81418_);
        boolean flag = false;
        if (this.items != null) {
            for (ItemStack itemStack : this.items) {
                flag = Unlockable.addReward(pPlayer, itemStack.m_41777_(), flag);
            }
        }
        if (this.loot != null) {
            for (ItemStack itemStack : this.loot) {
                for (ItemStack itemstack : pPlayer.f_8924_.m_278653_().m_278676_((ResourceLocation)itemStack).m_287195_(lootparams)) {
                    Unlockable.addReward(pPlayer, itemstack, flag);
                    flag = true;
                }
            }
        }
        if (flag) {
            pPlayer.f_36096_.m_38946_();
        }
    }

    private static boolean addReward(ServerPlayer pPlayer, ItemStack itemstack, boolean flag) {
        if (pPlayer.m_36356_(itemstack)) {
            pPlayer.m_9236_().m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((pPlayer.m_217043_().m_188501_() - pPlayer.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
            flag = true;
        } else {
            ItemEntity itementity = pPlayer.m_36176_(itemstack, false);
            if (itementity != null) {
                itementity.m_32061_();
                itementity.m_266426_(pPlayer.m_20148_());
            }
        }
        return flag;
    }
}

