/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.mixin.ui;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Definitions;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import dev.imb11.sounds.config.SoundsConfig;
import dev.imb11.sounds.config.UISoundsConfig;
import dev.imb11.sounds.dynamic.DynamicSoundHelper;
import dev.imb11.sounds.sound.context.ItemStackSoundContext;
import dev.imb11.sounds.util.MixinStatics;
import java.util.List;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CreativeModeInventoryScreen.class})
public abstract class CreativeInventorySoundEffects
extends EffectRenderingInventoryScreen<CreativeModeInventoryScreen.ItemPickerMenu> {
    @Shadow
    @Nullable
    private Slot f_98512_;
    @Shadow
    @Nullable
    private List<Slot> f_98511_;
    @Unique
    private double prevDeleteAllTime = 0.0;

    protected CreativeInventorySoundEffects(CreativeModeInventoryScreen.ItemPickerMenu screenHandler, Inventory playerInventory, Component text) {
        super((AbstractContainerMenu)screenHandler, playerInventory, text);
    }

    @Inject(method={"search"}, at={@At(value="HEAD")}, cancellable=false)
    public void $inventory_typing_sound_effect(CallbackInfo ci) {
        SoundsConfig.get(UISoundsConfig.class).inventoryTypingSoundEffect.playSound();
    }

    @Inject(method={"onMouseClick"}, at={@At(value="HEAD")}, cancellable=false)
    public void $pre_item_delete_sound_effect(Slot slot, int slotId, int button, ClickType actionType, CallbackInfo ci) {
        MixinStatics.CURRENT_SLOT = slot;
        MixinStatics.DELETE_ITEM_SLOT = this.f_98512_;
    }

    @ModifyExpressionValue(method={"onMouseClick"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definitions(value={@Definition(id="actionType", local={@Local(type=ClickType.class, argsOnly=true)}), @Definition(id="CLONE", field={"Lnet/minecraft/screen/slot/SlotActionType;CLONE:Lnet/minecraft/screen/slot/SlotActionType;"})})
    @Expression(value={"actionType == CLONE"})
    public boolean $creative_tab_item_clone(boolean original) {
        if (original) {
            SoundsConfig.get(UISoundsConfig.class).itemCopySoundEffect.playDynamicSound(MixinStatics.CURRENT_SLOT.m_7993_(), ItemStackSoundContext.of(DynamicSoundHelper.BlockSoundType.PLACE));
        }
        return original;
    }

    @ModifyExpressionValue(method={"onMouseClick"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definitions(value={@Definition(id="actionType", local={@Local(type=ClickType.class, argsOnly=true)}), @Definition(id="SWAP", field={"Lnet/minecraft/screen/slot/SlotActionType;SWAP:Lnet/minecraft/screen/slot/SlotActionType;"})})
    @Expression(value={"actionType == SWAP"})
    public boolean $creative_tab_item_swap(boolean original) {
        if (original) {
            SoundsConfig.get(UISoundsConfig.class).itemClickSoundEffect.playDynamicSound(MixinStatics.CURRENT_SLOT.m_7993_(), ItemStackSoundContext.of(DynamicSoundHelper.BlockSoundType.PLACE));
        }
        return original;
    }

    @Inject(method={"onMouseClick"}, at={@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/client/network/ClientPlayerInteractionManager;clickCreativeStack(Lnet/minecraft/item/ItemStack;I)V")}, cancellable=false)
    public void $mass_item_delete_sound_effect(Slot slot, int slotId, int button, ClickType actionType, CallbackInfo ci) {
        double currentTime = GLFW.glfwGetTime();
        double timeElapsed = currentTime - this.prevDeleteAllTime;
        if (this.f_98511_ != null && this.f_98511_.stream().anyMatch(Slot::m_6657_) && timeElapsed >= 0.1) {
            SoundsConfig.get(UISoundsConfig.class).itemDeleteSoundEffect.playSound();
        }
        this.prevDeleteAllTime = currentTime;
    }

    @Inject(method={"onMouseClick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/ingame/CreativeInventoryScreen$CreativeScreenHandler;setCursorStack(Lnet/minecraft/item/ItemStack;)V", shift=At.Shift.AFTER, ordinal=4)})
    public void $choose_item_sound_effect(Slot slot, int slotId, int button, ClickType actionType, CallbackInfo ci) {
        ItemStack stack = ((CreativeModeInventoryScreen.ItemPickerMenu)this.f_97732_).m_142621_();
        SoundsConfig.get(UISoundsConfig.class).itemClickSoundEffect.playDynamicSound(stack, ItemStackSoundContext.of(DynamicSoundHelper.BlockSoundType.PLACE));
    }
}

