/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.api.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.imb11.sounds.api.TagList;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.controller.DropdownStringControllerBuilder;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;

public class TagPair {
    private static final Codec<SoundType> BLOCK_GROUP_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("pitch").forGetter(SoundType::m_56774_), (App)Codec.FLOAT.fieldOf("volume").forGetter(SoundType::m_56773_), (App)SoundEvent.f_263124_.fieldOf("break").forGetter(SoundType::m_56775_), (App)SoundEvent.f_263124_.fieldOf("step").forGetter(SoundType::m_56776_), (App)SoundEvent.f_263124_.fieldOf("place").forGetter(SoundType::m_56777_), (App)SoundEvent.f_263124_.fieldOf("hit").forGetter(SoundType::m_56778_), (App)SoundEvent.f_263124_.fieldOf("fall").forGetter(SoundType::m_56779_)).apply((Applicative)instance, SoundType::new));
    public static final Codec<TagPair> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TagList.getCodec(BuiltInRegistries.f_256975_.m_123023_()).fieldOf("keys").forGetter(TagPair::getKeys), (App)BLOCK_GROUP_CODEC.fieldOf("group").forGetter(TagPair::getGroup), (App)Codec.BOOL.fieldOf("enabled").forGetter(TagPair::isEnabled)).apply((Applicative)instance, TagPair::new));
    private final TagList<Block> keys;
    private SoundType group;
    private SoundType pendingGroup;
    private boolean enabled;

    public TagList<Block> getKeys() {
        return this.keys;
    }

    public SoundType getGroup() {
        return this.group;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public TagPair(TagList<Block> keys, SoundType group) {
        this.keys = keys;
        this.group = group;
        this.pendingGroup = group;
        this.enabled = true;
    }

    public TagPair(TagList<Block> keys, SoundType group, boolean enabled) {
        this(keys, group);
        this.enabled = enabled;
    }

    private void playSound(SoundEvent event) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)event, (float)this.group.m_56774_(), (float)this.group.m_56773_()));
    }

    public ButtonOption createAction(String type) {
        Consumer<Void> action = e -> {
            switch (type) {
                case "break": {
                    this.playSound(this.group.m_56775_());
                    break;
                }
                case "step": {
                    this.playSound(this.group.m_56776_());
                    break;
                }
                case "place": {
                    this.playSound(this.group.m_56777_());
                    break;
                }
                case "hit": {
                    this.playSound(this.group.m_56778_());
                    break;
                }
                case "fall": {
                    this.playSound(this.group.m_56779_());
                }
            }
        };
        return ButtonOption.createBuilder().name((Component)Component.m_237110_((String)"sounds.config.preview.name.brackets", (Object[])new Object[]{Component.m_237115_((String)("sounds.config.preview." + type)).getString()})).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"sounds.config.preview.description")})).action((a, b) -> action.accept(null)).build();
    }

    private ResourceLocation getSoundId(SoundEvent event) {
        return event.m_11660_();
    }

    public Option<String> createSoundOpt(TagPair defaults, String type) {
        Option.Builder builder = Option.createBuilder().name((Component)Component.m_237110_((String)"sounds.config.event.name.brackets", (Object[])new Object[]{Component.m_237115_((String)("sounds.config.preview." + type)).getString()})).description(OptionDescription.createBuilder().text(new Component[]{Component.m_237115_((String)"sounds.config.event.description")}).build());
        return builder.binding((Object)(switch (type) {
            case "break" -> this.getSoundId(defaults.group.m_56775_()).toString();
            case "step" -> this.getSoundId(defaults.group.m_56776_()).toString();
            case "place" -> this.getSoundId(defaults.group.m_56777_()).toString();
            case "hit" -> this.getSoundId(defaults.group.m_56778_()).toString();
            case "fall" -> this.getSoundId(defaults.group.m_56779_()).toString();
            default -> "";
        }), () -> switch (type) {
            case "break" -> this.getSoundId(this.group.m_56775_()).toString();
            case "step" -> this.getSoundId(this.group.m_56776_()).toString();
            case "place" -> this.getSoundId(this.group.m_56777_()).toString();
            case "hit" -> this.getSoundId(this.group.m_56778_()).toString();
            case "fall" -> this.getSoundId(this.group.m_56779_()).toString();
            default -> "";
        }, val -> {
            SoundEvent event = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(ResourceLocation.m_135820_((String)val));
            switch (type) {
                case "break": {
                    this.group = new SoundType(this.group.m_56774_(), this.group.m_56773_(), event, this.group.m_56776_(), this.group.m_56777_(), this.group.m_56778_(), this.group.m_56779_());
                    break;
                }
                case "step": {
                    this.group = new SoundType(this.group.m_56774_(), this.group.m_56773_(), this.group.m_56775_(), event, this.group.m_56777_(), this.group.m_56778_(), this.group.m_56779_());
                    break;
                }
                case "place": {
                    this.group = new SoundType(this.group.m_56774_(), this.group.m_56773_(), this.group.m_56775_(), this.group.m_56776_(), event, this.group.m_56778_(), this.group.m_56779_());
                    break;
                }
                case "hit": {
                    this.group = new SoundType(this.group.m_56774_(), this.group.m_56773_(), this.group.m_56775_(), this.group.m_56776_(), this.group.m_56777_(), event, this.group.m_56779_());
                    break;
                }
                case "fall": {
                    this.group = new SoundType(this.group.m_56774_(), this.group.m_56773_(), this.group.m_56775_(), this.group.m_56776_(), this.group.m_56777_(), this.group.m_56778_(), event);
                }
            }
        }).listener((opt, val) -> {
            SoundEvent event = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(ResourceLocation.m_135820_((String)val));
            switch (type) {
                case "break": {
                    this.pendingGroup = new SoundType(this.pendingGroup.m_56774_(), this.pendingGroup.m_56773_(), event, this.pendingGroup.m_56776_(), this.pendingGroup.m_56777_(), this.pendingGroup.m_56778_(), this.pendingGroup.m_56779_());
                    break;
                }
                case "step": {
                    this.pendingGroup = new SoundType(this.pendingGroup.m_56774_(), this.pendingGroup.m_56773_(), this.pendingGroup.m_56775_(), event, this.pendingGroup.m_56777_(), this.pendingGroup.m_56778_(), this.pendingGroup.m_56779_());
                    break;
                }
                case "place": {
                    this.pendingGroup = new SoundType(this.pendingGroup.m_56774_(), this.pendingGroup.m_56773_(), this.pendingGroup.m_56775_(), this.pendingGroup.m_56776_(), event, this.pendingGroup.m_56778_(), this.pendingGroup.m_56779_());
                    break;
                }
                case "hit": {
                    this.pendingGroup = new SoundType(this.pendingGroup.m_56774_(), this.pendingGroup.m_56773_(), this.pendingGroup.m_56775_(), this.pendingGroup.m_56776_(), this.pendingGroup.m_56777_(), event, this.pendingGroup.m_56779_());
                    break;
                }
                case "fall": {
                    this.pendingGroup = new SoundType(this.pendingGroup.m_56774_(), this.pendingGroup.m_56773_(), this.pendingGroup.m_56775_(), this.pendingGroup.m_56776_(), this.pendingGroup.m_56777_(), this.pendingGroup.m_56778_(), event);
                }
            }
        }).controller(opt -> DropdownStringControllerBuilder.create((Option)opt).allowAnyValue(false).allowEmptyValue(false).values(BuiltInRegistries.f_256894_.m_214010_().stream().map(ResourceKey::m_135782_).map(ResourceLocation::toString).toList())).build();
    }

    public static class Builder {
        private final TagList<Block> keys = new TagList(new ArrayList());
        private SoundType group = SoundType.f_56742_;
        private boolean enabled = true;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder group(float pitch, float volume, SoundEvent breakSound, SoundEvent stepSound, SoundEvent placeSound, SoundEvent hitSound, SoundEvent fallSound) {
            this.group = new SoundType(pitch, volume, breakSound, stepSound, placeSound, hitSound, fallSound);
            return this;
        }

        @SafeVarargs
        public final Builder addMultipleKeys(Block ... keys) {
            for (Block key : keys) {
                this.addKey(key);
            }
            return this;
        }

        public Builder addKey(Block key) {
            this.keys.add((Either<ResourceKey<Block>, TagKey<Block>>)Either.left((Object)((ResourceKey)BuiltInRegistries.f_256975_.m_7854_((Object)key).orElseThrow(() -> new RuntimeException("TagPair.Builder: Could not find RegistryKey for " + key.toString())))));
            return this;
        }

        @SafeVarargs
        public final Builder addMultipleKeys(TagKey<Block> ... keys) {
            for (TagKey<Block> key : keys) {
                this.addKey(key);
            }
            return this;
        }

        public Builder addKey(TagKey<Block> key) {
            this.keys.add((Either<ResourceKey<Block>, TagKey<Block>>)Either.right(key));
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public TagPair build() {
            return new TagPair(this.keys, this.group, this.enabled);
        }
    }
}

