/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.api.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.imb11.sounds.api.config.ConfiguredSound;
import dev.imb11.sounds.api.context.DynamicSoundContext;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import java.util.ArrayList;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class DynamicConfiguredSound<T, F extends DynamicSoundContext<T>>
extends ConfiguredSound {
    public static final Codec<DynamicConfiguredSound> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(ConfiguredSound::getId), (App)ResourceLocation.f_135803_.fieldOf("soundEvent").forGetter(sound -> sound.soundEvent.m_205785_().m_135782_()), (App)Codec.BOOL.fieldOf("shouldPlay").forGetter(ConfiguredSound::shouldPlay), (App)Codec.FLOAT.fieldOf("pitch").forGetter(ConfiguredSound::getPitch), (App)Codec.FLOAT.fieldOf("volume").forGetter(ConfiguredSound::getVolume), (App)Codec.BOOL.fieldOf("enabledDynamic").forGetter(DynamicConfiguredSound::canUseDynamicSounds)).apply((Applicative)instance, DynamicConfiguredSound::new));
    public boolean enableDynamicSounds;

    public DynamicConfiguredSound(String id, ResourceLocation soundEvent, boolean enabled, float pitch, float volume, boolean enableDynamicSounds) {
        super(id, soundEvent, enabled, pitch, volume);
        this.enableDynamicSounds = enableDynamicSounds;
    }

    public DynamicConfiguredSound(String id, SoundEvent soundEvent, boolean enabled, float pitch, float volume, boolean enableDynamicSounds) {
        super(id, soundEvent, enabled, pitch, volume);
        this.enableDynamicSounds = enableDynamicSounds;
    }

    public DynamicConfiguredSound(String id, Holder.Reference<SoundEvent> soundEvent, boolean enabled, float pitch, float volume, boolean enableDynamicSounds) {
        super(id, soundEvent, enabled, pitch, volume);
        this.enableDynamicSounds = enableDynamicSounds;
    }

    public boolean canUseDynamicSounds() {
        return this.enableDynamicSounds;
    }

    public void playDynamicSound(SoundEvent event) {
        this.playSound((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)event, (float)this.pitch, (float)this.volume));
    }

    public void playDynamicSound(T context, F contextHandler) {
        SoundInstance event = contextHandler.handleContext(context, this.getSoundEvent(), this.pitch, this.volume);
        if (event == null || !this.enableDynamicSounds) {
            this.playSound();
            return;
        }
        this.playSound(event);
    }

    public <E extends ConfiguredSound> ArrayList<Option<?>> addExtraOptions(E defaults) {
        DynamicConfiguredSound dynamicDefaults = (DynamicConfiguredSound)defaults;
        ArrayList<Option<?>> options = super.addExtraOptions(defaults);
        Option shouldDynamic = Option.createBuilder().name((Component)Component.m_237115_((String)"sounds.config.dynamic.option")).description(OptionDescription.createBuilder().text(new Component[]{Component.m_237115_((String)"sounds.config.dynamic.option.description")}).build()).binding((Object)dynamicDefaults.enableDynamicSounds, () -> this.enableDynamicSounds, val -> {
            this.enableDynamicSounds = val;
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).coloured(true).onOffFormatter()).build();
        options.add(shouldDynamic);
        return options;
    }
}

