/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.network;

import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.network.v2.MessageDirection;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import fuzs.puzzleslib.api.network.v2.NetworkHandlerV2;
import fuzs.puzzleslib.impl.network.NetworkHandlerImplHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandlerForgeV2
implements NetworkHandlerV2 {
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    private final AtomicInteger discriminator = new AtomicInteger();
    private final SimpleChannel channel;
    public final boolean clientAcceptsVanillaOrMissing;
    public final boolean serverAcceptsVanillaOrMissing;

    public NetworkHandlerForgeV2(ResourceLocation channelIdentifier, boolean clientAcceptsVanillaOrMissing, boolean serverAcceptsVanillaOrMissing) {
        this.channel = NetworkHandlerForgeV2.buildSimpleChannel(channelIdentifier, clientAcceptsVanillaOrMissing, serverAcceptsVanillaOrMissing);
        this.clientAcceptsVanillaOrMissing = clientAcceptsVanillaOrMissing;
        this.serverAcceptsVanillaOrMissing = serverAcceptsVanillaOrMissing;
    }

    @Override
    public <T extends MessageV2<T>> void register(Class<? extends T> clazz, Supplier<T> factory, MessageDirection direction) {
        Function<FriendlyByteBuf, T> decode = NetworkHandlerImplHelper.getDirectMessageDecoder(factory);
        LogicalSide receptionSide = direction == MessageDirection.TO_CLIENT ? LogicalSide.CLIENT : LogicalSide.SERVER;
        this.register(clazz, decode, receptionSide);
    }

    @Override
    public <T extends MessageV2<T>> NetworkHandlerV2 registerClientbound(Class<T> clazz) {
        this.register(clazz, NetworkHandlerImplHelper.getMessageDecoder(clazz), LogicalSide.CLIENT);
        return this;
    }

    @Override
    public <T extends MessageV2<T>> NetworkHandlerV2 registerServerbound(Class<T> clazz) {
        this.register(clazz, NetworkHandlerImplHelper.getMessageDecoder(clazz), LogicalSide.SERVER);
        return this;
    }

    private <T extends MessageV2<T>> void register(Class<T> clazz, Function<FriendlyByteBuf, T> decode, LogicalSide receptionSide) {
        BiConsumer<MessageV2, Supplier> handle = (message, supplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)supplier.get();
            LogicalSide expectedReceptionSide = context.getDirection().getReceptionSide();
            if (expectedReceptionSide != receptionSide) {
                throw new IllegalStateException(String.format("Received message on wrong side, expected %s, was %s", receptionSide, expectedReceptionSide));
            }
            context.enqueueWork(() -> {
                Object player = receptionSide.isClient() ? Proxy.INSTANCE.getClientPlayer() : context.getSender();
                message.makeHandler().handle((MessageV2)message, (Player)player, LogicalSidedProvider.WORKQUEUE.get(receptionSide));
            });
            context.setPacketHandled(true);
        };
        this.channel.registerMessage(this.discriminator.getAndIncrement(), clazz, MessageV2::write, decode, handle);
    }

    @Override
    public Packet<ServerGamePacketListener> toServerboundPacket(MessageV2<?> message) {
        return this.channel.toVanillaPacket(message, NetworkDirection.PLAY_TO_SERVER);
    }

    @Override
    public Packet<ClientGamePacketListener> toClientboundPacket(MessageV2<?> message) {
        return this.channel.toVanillaPacket(message, NetworkDirection.PLAY_TO_CLIENT);
    }

    private static SimpleChannel buildSimpleChannel(ResourceLocation resourceLocation, boolean clientAcceptsVanillaOrMissing, boolean serverAcceptsVanillaOrMissing) {
        return NetworkRegistry.ChannelBuilder.named((ResourceLocation)resourceLocation).networkProtocolVersion(() -> PROTOCOL_VERSION).clientAcceptedVersions((Predicate)(clientAcceptsVanillaOrMissing ? NetworkRegistry.acceptMissingOr((String)PROTOCOL_VERSION) : PROTOCOL_VERSION::equals)).serverAcceptedVersions((Predicate)(serverAcceptsVanillaOrMissing ? NetworkRegistry.acceptMissingOr((String)PROTOCOL_VERSION) : PROTOCOL_VERSION::equals)).simpleChannel();
    }
}

