/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.api;

import java.util.function.DoubleBinaryOperator;
import java.util.function.Supplier;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleModifier;
import virtuoel.pehkui.api.ScaleType;

public class TypedScaleModifier
extends ScaleModifier {
    private final Supplier<ScaleType> type;
    private final DoubleBinaryOperator operation;

    public TypedScaleModifier(Supplier<ScaleType> type, DoubleBinaryOperator operation) {
        this.type = type;
        this.operation = operation;
    }

    public TypedScaleModifier(Supplier<ScaleType> type, DoubleBinaryOperator operation, float priority) {
        super(priority);
        this.type = type;
        this.operation = operation;
    }

    public TypedScaleModifier(Supplier<ScaleType> type) {
        this(type, (modified, typed) -> modified * typed);
    }

    public TypedScaleModifier(Supplier<ScaleType> type, float priority) {
        this(type, (modified, typed) -> modified * typed, priority);
    }

    public ScaleType getType() {
        return this.type.get();
    }

    @Override
    public float modifyScale(ScaleData scaleData, float modifiedScale, float delta) {
        ScaleType type = this.getType();
        return type == scaleData.getScaleType() ? modifiedScale : (float)this.operation.applyAsDouble(modifiedScale, type.getScaleData(scaleData.getEntity()).getScale(delta));
    }

    @Override
    public float modifyPrevScale(ScaleData scaleData, float modifiedScale) {
        ScaleType type = this.getType();
        return type == scaleData.getScaleType() ? modifiedScale : (float)this.operation.applyAsDouble(modifiedScale, type.getScaleData(scaleData.getEntity()).getPrevScale());
    }
}

