/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.openloader.packs;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.darkhax.openloader.Constants;
import net.darkhax.openloader.config.ConfigSchema;
import net.darkhax.openloader.packs.RepoType;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;

public class OpenLoaderRepositorySource
implements RepositorySource {
    private final RepoType type;
    private final List<File> directories;
    private final ConfigSchema.PackConfig config;
    private final PackSource sourceInfo;

    public OpenLoaderRepositorySource(RepoType type, ConfigSchema globalConfig, ConfigSchema.PackConfig config, Path configDir) {
        this.type = type;
        this.config = config;
        this.sourceInfo = PackSource.m_247176_(name -> globalConfig.displaySourceName ? Component.m_237110_((String)"pack.nameAndSource", (Object[])new Object[]{name, Component.m_237115_((String)"pack.source.openloader")}).m_130940_(ChatFormatting.GREEN) : name, (boolean)true);
        this.directories = new ArrayList<File>();
        this.directories.add(configDir.resolve(type.getPath()).toFile());
        for (String customDir : config.additionalFolders) {
            this.directories.add(new File(customDir));
        }
        for (File directory : this.directories) {
            if (!directory.exists()) {
                Constants.LOG.info("Generating new {} folder at {}.", (Object)type.displayName, (Object)directory.getAbsolutePath());
                directory.mkdirs();
            }
            if (directory.isDirectory()) continue;
            Constants.LOG.error("Improper {} folder specified. Must be a directory! See {}.", (Object)type.displayName, (Object)directory.getAbsolutePath());
            throw new IllegalStateException("Can not load " + type.displayName + " from non-directory. " + directory.getAbsolutePath());
        }
    }

    public void m_7686_(Consumer<Pack> consumer) {
        if (this.config.enabled) {
            Constants.LOG.info("Preparing {} injection.", (Object)this.type.displayName);
            for (File parentDirectory : this.directories) {
                int newPackCount = 0;
                int failedPacks = 0;
                for (File packCandidate : Objects.requireNonNull(parentDirectory.listFiles())) {
                    String typeName;
                    boolean isFolderPack;
                    boolean isArchivePack = this.isArchivePack(packCandidate, false);
                    boolean bl = isFolderPack = !isArchivePack && OpenLoaderRepositorySource.isFolderPack(packCandidate, false);
                    String string = isArchivePack ? "archive" : (typeName = isFolderPack ? "folder" : "invalid");
                    if (isArchivePack || isFolderPack) {
                        MutableComponent displayName;
                        String packName = this.type.getPath() + "/" + packCandidate.getName();
                        Pack pack = Pack.m_245429_((String)packName, (Component)(displayName = Component.m_237113_((String)packName)), (boolean)true, (Pack.ResourcesSupplier)this.createPackSupplier(packCandidate), (PackType)this.type.getPackType(), (Pack.Position)Pack.Position.TOP, (PackSource)this.sourceInfo);
                        if (pack == null) continue;
                        consumer.accept(pack);
                        ++newPackCount;
                        Constants.LOG.info("Loaded {} {} from {}.", (Object)typeName, (Object)this.type.getName(), (Object)packCandidate.getAbsolutePath());
                        continue;
                    }
                    Constants.LOG.error("Skipping {}. It is not a valid {}!", (Object)packCandidate.getAbsolutePath(), (Object)this.type.getName());
                    this.isArchivePack(packCandidate, true);
                    OpenLoaderRepositorySource.isFolderPack(packCandidate, true);
                    ++failedPacks;
                }
                Constants.LOG.info("Successfully injected {}/{} packs from {}.", (Object)newPackCount, (Object)(newPackCount + failedPacks), (Object)parentDirectory.getAbsolutePath());
            }
        } else {
            Constants.LOG.info("Skipping {}. Disabled by user config.", (Object)this.type.displayName);
        }
    }

    private Pack.ResourcesSupplier createPackSupplier(File packFile) {
        return name -> packFile.isDirectory() ? new PathPackResources(name, packFile.toPath(), false) : new FilePackResources(name, packFile, false);
    }

    private boolean isArchivePack(File candidate, boolean logIssues) {
        if (candidate.isFile()) {
            boolean isZipCompatibleArchive;
            String fileName = candidate.getName();
            boolean bl = isZipCompatibleArchive = OpenLoaderRepositorySource.endsWithIgnoreCase(fileName, ".zip") || OpenLoaderRepositorySource.endsWithIgnoreCase(fileName, ".jar");
            if (!isZipCompatibleArchive && logIssues) {
                Constants.LOG.warn("Can not load {} as an archive. It must be a .zip or .jar file!", (Object)candidate.getAbsolutePath());
            }
            return isZipCompatibleArchive;
        }
        if (logIssues) {
            Constants.LOG.warn("Can not load {} as an archive. It is not a file.", (Object)candidate.getAbsolutePath());
        }
        return false;
    }

    private static boolean isFolderPack(File candidate, boolean logIssues) {
        if (candidate.isDirectory()) {
            if (new File(candidate, "pack.mcmeta").isFile()) {
                return true;
            }
            if (logIssues) {
                Constants.LOG.warn("Can not load {} as a folder pack. It is missing a pack.mcmeta file!", (Object)candidate.getAbsolutePath());
            }
        } else if (logIssues) {
            Constants.LOG.warn("Can not load {} as folder. It is not a directory.", (Object)candidate.getAbsolutePath());
        }
        return false;
    }

    private static boolean endsWithIgnoreCase(String str, String suffix) {
        int suffixLength = suffix.length();
        return str.regionMatches(true, str.length() - suffixLength, suffix, 0, suffixLength);
    }
}

