/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.restraints;

import com.lazrproductions.cuffed.CuffedMod;
import com.lazrproductions.cuffed.entity.animation.ArmRestraintAnimationFlags;
import com.lazrproductions.cuffed.entity.animation.LegRestraintAnimationFlags;
import com.lazrproductions.cuffed.restraints.base.AbstractRestraint;
import com.lazrproductions.cuffed.restraints.base.RestraintType;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.IForgeRegistry;

public class RestraintAPI {
    public static AbstractRestraint getRestraintFromTag(CompoundTag tag) {
        AbstractRestraint r;
        if (tag.m_128441_("Id") && (r = RestraintAPI.getNewRestraintByKey(ResourceLocation.bySeparator((String)tag.m_128461_("Id"), (char)':'))) != null) {
            r.deserializeNBT(tag);
            return r;
        }
        return null;
    }

    public static AbstractRestraint getNewRestraintByKey(ResourceLocation key) {
        if (Registries.containsKey(key)) {
            return Registries.get(key);
        }
        return null;
    }

    public static AbstractRestraint getRestraintFromStack(ItemStack stack, RestraintType type, ServerPlayer player, ServerPlayer captor) {
        AbstractRestraint restraintBase;
        if (stack.m_41720_() != null && (restraintBase = Registries.get(stack.m_41720_(), type)) != null) {
            String className = restraintBase.getClass().getName();
            try {
                Object o = Class.forName(className).getConstructor(ItemStack.class, ServerPlayer.class, ServerPlayer.class).newInstance(stack, player, captor);
                if (o instanceof AbstractRestraint) {
                    AbstractRestraint r = (AbstractRestraint)o;
                    return r;
                }
            }
            catch (Exception e) {
                CuffedMod.LOGGER.info("Error getting new instance of restraint for stack " + stack.m_41786_().getString());
                return null;
            }
        }
        return null;
    }

    public static boolean isRestraintItem(ItemStack stack) {
        return RestraintAPI.IsHeadRestraintItem(stack) || RestraintAPI.IsArmRestraintItem(stack) || RestraintAPI.IsLegRestraintItem(stack);
    }

    public static boolean IsHeadRestraintItem(ItemStack stack) {
        AbstractRestraint r = Registries.get(stack.m_41720_(), RestraintType.Head);
        return r != null && r.getType() == RestraintType.Head;
    }

    public static boolean IsArmRestraintItem(ItemStack stack) {
        AbstractRestraint r = Registries.get(stack.m_41720_(), RestraintType.Arm);
        return r != null && r.getType() == RestraintType.Arm;
    }

    public static boolean IsLegRestraintItem(ItemStack stack) {
        AbstractRestraint r = Registries.get(stack.m_41720_(), RestraintType.Leg);
        return r != null && r.getType() == RestraintType.Leg;
    }

    public static boolean canEquipRestriantItem(ItemStack stack, RestraintType type, ServerPlayer player, ServerPlayer captor) {
        AbstractRestraint r = Registries.get(stack.m_41720_(), type);
        return r != null ? r.canEquipRestraintItem(stack, player, captor) : false;
    }

    public static ArmRestraintAnimationFlags getArmAnimationFlagByKey(ResourceLocation key) {
        AbstractRestraint r = Registries.get(key);
        return r != null ? r.getArmAnimationFlags() : ArmRestraintAnimationFlags.NONE;
    }

    public static LegRestraintAnimationFlags getLegAnimationFlagByKey(ResourceLocation key) {
        AbstractRestraint r = Registries.get(key);
        return r != null ? r.getLegAnimationFlags() : LegRestraintAnimationFlags.NONE;
    }

    public static final class Registries {
        static final ArrayList<IForgeRegistry<AbstractRestraint>> RESTRAINT_REGISTRIES = new ArrayList();

        public static void register(IForgeRegistry<?> registry) {
            IForgeRegistry<?> r = registry;
            for (ResourceLocation key : r.getKeys()) {
                if (Registries.containsKey(key)) {
                    RestraintRegistryContainsKeyException ex = new RestraintRegistryContainsKeyException(key);
                    CuffedMod.LOGGER.error("The Restraint Registry already contains the key " + key, (Throwable)ex);
                    throw ex;
                }
                AbstractRestraint restraint = (AbstractRestraint)r.getValue(key);
                if (Registries.containsValue(restraint)) {
                    RestraintRegistryContainsRestraintException ex = new RestraintRegistryContainsRestraintException(key);
                    CuffedMod.LOGGER.error("The Restraint Registry already contains the restraint " + key, (Throwable)ex);
                    throw ex;
                }
                AbstractRestraint otherWithSameItem = Registries.get(restraint.getItem(), restraint.getType());
                if (otherWithSameItem == null || otherWithSameItem.getType() != restraint.getType()) continue;
                ConflictingRestraintItemAndTypeException ex = new ConflictingRestraintItemAndTypeException(key, otherWithSameItem.getType());
                CuffedMod.LOGGER.error("The Restraint Registry already contains a restraint for " + key + " with the same restraint type of " + otherWithSameItem.getType(), (Throwable)ex);
                throw ex;
            }
            RESTRAINT_REGISTRIES.add(r);
        }

        public static boolean containsKey(ResourceLocation key) {
            for (IForgeRegistry<AbstractRestraint> i : RESTRAINT_REGISTRIES) {
                if (!i.containsKey(key)) continue;
                return true;
            }
            return false;
        }

        public static boolean containsValue(AbstractRestraint restraint) {
            for (IForgeRegistry<AbstractRestraint> i : RESTRAINT_REGISTRIES) {
                if (!i.containsValue((Object)restraint)) continue;
                return true;
            }
            return false;
        }

        public static AbstractRestraint get(ResourceLocation key) {
            for (IForgeRegistry<AbstractRestraint> i : RESTRAINT_REGISTRIES) {
                if (!i.containsKey(key)) continue;
                return (AbstractRestraint)i.getValue(key);
            }
            return null;
        }

        public static AbstractRestraint get(Item restraintItem, RestraintType type) {
            List<Pair<Item, AbstractRestraint>> pairs = Registries.getAllRestraintItemsAndTheirRestraints();
            for (Pair<Item, AbstractRestraint> pair : pairs) {
                if (!((Item)pair.getFirst()).equals(restraintItem) || ((AbstractRestraint)pair.getSecond()).getType() != type) continue;
                return (AbstractRestraint)pair.getSecond();
            }
            return null;
        }

        public static List<AbstractRestraint> getAllRestraints() {
            ArrayList<AbstractRestraint> res = new ArrayList<AbstractRestraint>();
            for (IForgeRegistry<AbstractRestraint> reg : RESTRAINT_REGISTRIES) {
                for (AbstractRestraint ent : reg.getValues()) {
                    res.add(ent);
                }
            }
            return res;
        }

        public static List<Item> getAllRestraintItems() {
            ArrayList<Item> res = new ArrayList<Item>();
            for (IForgeRegistry<AbstractRestraint> reg : RESTRAINT_REGISTRIES) {
                for (AbstractRestraint ent : reg.getValues()) {
                    res.add(ent.getItem());
                }
            }
            return res;
        }

        public static List<Pair<Item, AbstractRestraint>> getAllRestraintItemsAndTheirRestraints() {
            ArrayList<Pair<Item, AbstractRestraint>> pairs = new ArrayList<Pair<Item, AbstractRestraint>>();
            for (IForgeRegistry<AbstractRestraint> reg : RESTRAINT_REGISTRIES) {
                for (AbstractRestraint ent : reg.getValues()) {
                    pairs.add((Pair<Item, AbstractRestraint>)new Pair((Object)ent.getItem(), (Object)ent));
                }
            }
            return pairs;
        }

        public static int size() {
            return RESTRAINT_REGISTRIES.size();
        }

        public static int total() {
            int total = 0;
            for (IForgeRegistry<AbstractRestraint> i : RESTRAINT_REGISTRIES) {
                total += i.getValues().size();
            }
            return total;
        }

        public static class RestraintRegistryContainsKeyException
        extends RuntimeException {
            public RestraintRegistryContainsKeyException() {
                super("The Restraint Registry already contains this key!");
            }

            public RestraintRegistryContainsKeyException(ResourceLocation key) {
                super("The Restraint Registry already contains the key " + key);
            }
        }

        public static class RestraintRegistryContainsRestraintException
        extends RuntimeException {
            public RestraintRegistryContainsRestraintException() {
                super("The Restraint Registry already contains this restraint!");
            }

            public RestraintRegistryContainsRestraintException(ResourceLocation key) {
                super("The Restraint Registry already contains the restraint " + key);
            }
        }

        public static class ConflictingRestraintItemAndTypeException
        extends RuntimeException {
            public ConflictingRestraintItemAndTypeException() {
                super("The Restraint Registry already contains a restraint for this item with the same restraint type!");
            }

            public ConflictingRestraintItemAndTypeException(ResourceLocation key, RestraintType type) {
                super("The Restraint Registry already contains a restraint for " + key + " with the same restraint type of " + type);
            }
        }
    }
}

