/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.entity;

import com.lazrproductions.cuffed.CuffedMod;
import com.lazrproductions.cuffed.entity.base.IAnchorableEntity;
import com.lazrproductions.cuffed.init.ModEntityTypes;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ChainKnotEntity
extends HangingEntity {
    public ChainKnotEntity(EntityType<? extends HangingEntity> type, Level level) {
        super(type, level);
    }

    public ChainKnotEntity(Level world, BlockPos pos) {
        super((EntityType)ModEntityTypes.CHAIN_KNOT.get(), world, pos);
        this.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    public boolean isOnFence() {
        return !this.m_9236_().m_8055_(this.f_31698_).m_204336_(BlockTags.f_13039_);
    }

    public void m_5553_(@Nullable Entity p_31837_) {
        this.m_5496_(SoundEvents.f_11794_, 1.0f, 1.0f);
    }

    public boolean m_6469_(@Nonnull DamageSource source, float f) {
        IAnchorableEntity a;
        Entity entity = source.m_7639_();
        if (entity instanceof IAnchorableEntity && (a = (IAnchorableEntity)entity).getAnchor() == this) {
            return false;
        }
        return super.m_6469_(source, f);
    }

    public InteractionResult m_6096_(@Nonnull Player interactor, @Nonnull InteractionHand hand) {
        if (this.m_9236_().m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (((IAnchorableEntity)interactor).isAnchored()) {
            return InteractionResult.PASS;
        }
        boolean flag = false;
        double maxDist = ((Float)CuffedMod.SERVER_CONFIG.ANCHORING_SUFFOCATION_LENGTH.get()).floatValue() + 5.0f;
        List list = this.m_9236_().m_45976_(LivingEntity.class, new AABB(this.m_20185_() - maxDist - 2.0, this.m_20186_() - maxDist - 2.0, this.m_20189_() - maxDist - 2.0, this.m_20185_() + maxDist + 2.0, this.m_20186_() + maxDist + 2.0, this.m_20189_() + maxDist + 2.0));
        for (LivingEntity entity : list) {
            IAnchorableEntity anchorableEntity = (IAnchorableEntity)entity;
            if (anchorableEntity.getAnchor() != interactor) continue;
            anchorableEntity.setAnchoredTo((Entity)this);
            flag = true;
        }
        boolean flag1 = false;
        if (!flag) {
            this.m_9236_().m_5594_(null, this.f_31698_, SoundEvents.f_11794_, SoundSource.PLAYERS, 0.7f, 1.0f);
            for (LivingEntity entity : list) {
                IAnchorableEntity anchorableEntity = (IAnchorableEntity)entity;
                if (!anchorableEntity.isAnchored() || anchorableEntity.getAnchor() != this) continue;
                anchorableEntity.setAnchoredTo(null);
                flag1 = true;
            }
            this.m_146870_();
        }
        if (flag) {
            this.m_9236_().m_5594_(null, this.f_31698_, SoundEvents.f_11745_, SoundSource.PLAYERS, 0.7f, 1.0f);
        }
        if (flag1) {
            this.m_9236_().m_5594_(null, this.f_31698_, SoundEvents.f_11794_, SoundSource.PLAYERS, 0.7f, 1.0f);
        }
        if (flag || flag1) {
            this.m_146852_(GameEvent.f_157791_, (Entity)interactor);
        }
        return InteractionResult.CONSUME;
    }

    public static ChainKnotEntity getOrCreateKnot(Level level, BlockPos pos) {
        int i = pos.m_123341_();
        int j = pos.m_123342_();
        int k = pos.m_123343_();
        level.m_5594_(null, pos, SoundEvents.f_11745_, SoundSource.PLAYERS, 0.7f, 1.0f);
        for (ChainKnotEntity leashfenceknotentity : level.m_45976_(ChainKnotEntity.class, new AABB((double)i - 1.0, (double)j - 1.0, (double)k - 1.0, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0))) {
            if (!leashfenceknotentity.m_31748_().equals((Object)pos)) continue;
            return leashfenceknotentity;
        }
        ChainKnotEntity newEntity = new ChainKnotEntity(level, pos);
        level.m_7967_((Entity)newEntity);
        return newEntity;
    }

    public static ChainKnotEntity bindEntityToNewOrExistingKnot(LivingEntity entity, Level level, BlockPos pos) {
        int i = pos.m_123341_();
        int j = pos.m_123342_();
        int k = pos.m_123343_();
        level.m_5594_(null, pos, SoundEvents.f_11745_, SoundSource.PLAYERS, 0.7f, 1.0f);
        for (ChainKnotEntity knot : level.m_45976_(ChainKnotEntity.class, new AABB((double)i - 1.0, (double)j - 1.0, (double)k - 1.0, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0))) {
            if (!knot.m_31748_().equals((Object)pos)) continue;
            ((IAnchorableEntity)entity).setAnchor((Entity)knot);
            return knot;
        }
        ChainKnotEntity newKnot = new ChainKnotEntity(level, pos);
        ((IAnchorableEntity)entity).setAnchor((Entity)newKnot);
        level.m_7967_((Entity)newKnot);
        return newKnot;
    }

    public void m_6034_(double x, double y, double z) {
        super.m_6034_((double)Mth.m_14107_((double)x) + 0.5, (double)Mth.m_14107_((double)y) + 0.5, (double)Mth.m_14107_((double)z) + 0.5);
    }

    protected void m_6022_(@Nonnull Direction pFacingDirection) {
    }

    public int m_7076_() {
        return 9;
    }

    public int m_7068_() {
        return 9;
    }

    protected float m_6380_(@Nonnull Pose p_31839_, @Nonnull EntityDimensions p_31840_) {
        return 0.0625f;
    }

    public boolean m_6783_(double distance) {
        return distance < 1024.0;
    }

    public boolean m_7088_() {
        return this.m_9236_().m_8055_(this.f_31698_).m_204336_(BlockTags.f_13039_) || this.m_9236_().m_8055_(this.f_31698_).m_60713_(Blocks.f_50266_);
    }

    public void m_7084_() {
        this.m_5496_(SoundEvents.f_11745_, 1.0f, 1.0f);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, 0, this.m_31748_());
    }

    public Vec3 m_7398_(float partialTick) {
        return this.m_20318_(partialTick).m_82549_(this.m_245894_(partialTick));
    }

    public Vec3 m_245894_(float partialTick) {
        return new Vec3(0.0, (double)this.m_20192_() + (!this.isOnFence() ? 0.2 : 0.0), 0.0);
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)Items.f_42026_);
    }

    protected void m_7087_() {
        this.m_20343_((double)this.f_31698_.m_123341_() + 0.5, (double)this.f_31698_.m_123342_() + 0.375, (double)this.f_31698_.m_123343_() + 0.5);
        double d0 = (double)this.m_6095_().m_20678_() / 2.0;
        double d1 = this.m_6095_().m_20679_();
        this.m_20011_(new AABB(this.m_20185_() - d0, this.m_20186_(), this.m_20189_() - d0, this.m_20185_() + d0, this.m_20186_() + d1, this.m_20189_() + d0));
    }
}

