/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.blocks.entity;

import com.lazrproductions.cuffed.init.ModBlockEntities;
import com.lazrproductions.cuffed.init.ModItems;
import com.lazrproductions.cuffed.items.TrayItem;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class TrayBlockEntity
extends BlockEntity {
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);

    public TrayBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TRAY.get(), pos, state);
    }

    public InteractionResult use(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player interacting, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hitResult) {
        if (hand == InteractionHand.MAIN_HAND) {
            ItemStack itemInMainHand = interacting.m_21120_(hand);
            if (itemInMainHand.m_41619_()) {
                if (!interacting.m_6047_()) {
                    if (this.hasFood()) {
                        float nutritionRatio = 1.0f;
                        if (this.hasFork()) {
                            nutritionRatio += 0.33333f;
                        }
                        if (this.hasSpoon()) {
                            nutritionRatio += 0.33333f;
                        }
                        if (this.hasKnife()) {
                            nutritionRatio += 0.33333f;
                        }
                        ItemStack food = this.getFood();
                        food.getFoodProperties((LivingEntity)interacting);
                        this.eat(level, interacting, food, nutritionRatio);
                        this.sendUpdate(level, pos, state);
                        return InteractionResult.SUCCESS;
                    }
                } else {
                    ItemStack food = this.getFood().m_41777_();
                    ItemStack fork = this.getFork().m_41777_();
                    ItemStack spoon = this.getSpoon().m_41777_();
                    ItemStack knife = this.getKnife().m_41777_();
                    if (this.removeItem(0)) {
                        interacting.m_21008_(hand, food);
                        level.m_6263_((Player)null, (double)((float)this.m_58899_().m_123341_() + 0.5f), (double)this.m_58899_().m_123342_(), (double)((float)this.m_58899_().m_123343_() + 0.5f), SoundEvents.f_11760_, SoundSource.NEUTRAL, 1.0f, 1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.4f);
                        this.sendUpdate(level, pos, state);
                        return InteractionResult.SUCCESS;
                    }
                    if (this.removeItem(1)) {
                        interacting.m_21008_(hand, fork);
                        level.m_6263_((Player)null, (double)((float)this.m_58899_().m_123341_() + 0.5f), (double)this.m_58899_().m_123342_(), (double)((float)this.m_58899_().m_123343_() + 0.5f), SoundEvents.f_12027_, SoundSource.NEUTRAL, 1.0f, 1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.4f);
                        this.sendUpdate(level, pos, state);
                        return InteractionResult.SUCCESS;
                    }
                    if (this.removeItem(2)) {
                        interacting.m_21008_(hand, spoon);
                        level.m_6263_((Player)null, (double)((float)this.m_58899_().m_123341_() + 0.5f), (double)this.m_58899_().m_123342_(), (double)((float)this.m_58899_().m_123343_() + 0.5f), SoundEvents.f_12027_, SoundSource.NEUTRAL, 1.0f, 1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.4f);
                        this.sendUpdate(level, pos, state);
                        return InteractionResult.SUCCESS;
                    }
                    if (this.removeItem(3)) {
                        interacting.m_21008_(hand, knife);
                        level.m_6263_((Player)null, (double)((float)this.m_58899_().m_123341_() + 0.5f), (double)this.m_58899_().m_123342_(), (double)((float)this.m_58899_().m_123343_() + 0.5f), SoundEvents.f_12027_, SoundSource.NEUTRAL, 1.0f, 1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.4f);
                        this.sendUpdate(level, pos, state);
                        return InteractionResult.SUCCESS;
                    }
                }
            } else {
                if (TrayItem.itemIsFood(itemInMainHand) && !this.hasFood()) {
                    this.setItem(itemInMainHand.m_255036_(1), 0);
                    itemInMainHand.m_41774_(1);
                    level.m_6263_((Player)null, (double)((float)this.m_58899_().m_123341_() + 0.5f), (double)this.m_58899_().m_123342_(), (double)((float)this.m_58899_().m_123343_() + 0.5f), SoundEvents.f_11760_, SoundSource.NEUTRAL, 1.0f, 1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.4f);
                    this.sendUpdate(level, pos, state);
                    return InteractionResult.SUCCESS;
                }
                if (TrayItem.itemIsFork(itemInMainHand) && !this.hasFork()) {
                    this.setItem(itemInMainHand.m_255036_(1), 1);
                    itemInMainHand.m_41774_(1);
                    level.m_6263_((Player)null, (double)((float)this.m_58899_().m_123341_() + 0.5f), (double)this.m_58899_().m_123342_(), (double)((float)this.m_58899_().m_123343_() + 0.5f), SoundEvents.f_12027_, SoundSource.NEUTRAL, 1.0f, 1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.4f);
                    this.sendUpdate(level, pos, state);
                    return InteractionResult.SUCCESS;
                }
                if (TrayItem.itemIsSpoon(itemInMainHand) && !this.hasSpoon()) {
                    this.setItem(itemInMainHand.m_255036_(1), 2);
                    itemInMainHand.m_41774_(1);
                    level.m_6263_((Player)null, (double)((float)this.m_58899_().m_123341_() + 0.5f), (double)this.m_58899_().m_123342_(), (double)((float)this.m_58899_().m_123343_() + 0.5f), SoundEvents.f_12027_, SoundSource.NEUTRAL, 1.0f, 1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.4f);
                    this.sendUpdate(level, pos, state);
                    return InteractionResult.SUCCESS;
                }
                if (TrayItem.itemIsKnife(itemInMainHand) && !this.hasKnife()) {
                    this.setItem(itemInMainHand.m_255036_(1), 3);
                    itemInMainHand.m_41774_(1);
                    level.m_6263_((Player)null, (double)((float)this.m_58899_().m_123341_() + 0.5f), (double)this.m_58899_().m_123342_(), (double)((float)this.m_58899_().m_123343_() + 0.5f), SoundEvents.f_12027_, SoundSource.NEUTRAL, 1.0f, 1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.4f);
                    this.sendUpdate(level, pos, state);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.FAIL;
    }

    public void eat(Level level, Player player, ItemStack stack, float nutritionRatio) {
        if (stack.m_41614_()) {
            FoodProperties foodproperties = stack.getFoodProperties((LivingEntity)player);
            player.m_36324_().m_38707_(Mth.m_14143_((float)((float)foodproperties.m_38744_() * nutritionRatio)), foodproperties.m_38745_());
            player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            level.m_6263_((Player)null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), SoundEvents.f_12321_, SoundSource.PLAYERS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)player, stack);
            }
            for (Pair pair : stack.getFoodProperties((LivingEntity)player).m_38749_()) {
                if (level.f_46443_ || pair.getFirst() == null || !(level.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                player.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
            }
            level.m_6263_((Player)null, (double)((float)this.m_58899_().m_123341_() + 0.5f), (double)this.m_58899_().m_123342_(), (double)((float)this.m_58899_().m_123343_() + 0.5f), player.m_7866_(stack), SoundSource.NEUTRAL, 1.0f, 1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.4f);
            this.removeItem(0);
            player.m_146850_(GameEvent.f_157806_);
        }
    }

    @Nonnull
    public ItemStack getFoodStack() {
        for (ItemStack itemStack : this.items) {
            if (!TrayItem.itemIsFood(itemStack)) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack getForkStack() {
        for (ItemStack itemStack : this.items) {
            if (!itemStack.m_150930_((Item)ModItems.FORK.get())) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack getSpoonStack() {
        for (ItemStack itemStack : this.items) {
            if (!itemStack.m_150930_((Item)ModItems.SPOON.get())) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack getKnifeStack() {
        for (ItemStack itemStack : this.items) {
            if (!itemStack.m_150930_((Item)ModItems.KNIFE.get())) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    protected boolean addItem(@Nonnull ItemStack stack) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((ItemStack)this.items.get(i)).m_41619_()) continue;
            this.items.set(i, (Object)stack);
            return true;
        }
        return false;
    }

    protected boolean setItem(@Nonnull ItemStack stack, int index) {
        if (((ItemStack)this.items.get(index)).m_41619_()) {
            this.items.set(index, (Object)stack);
            return true;
        }
        return false;
    }

    protected boolean removeItem(int index) {
        if (index >= 0 && index < this.items.size()) {
            boolean removedSomething = !((ItemStack)this.items.get(index)).m_41619_();
            this.items.set(index, (Object)ItemStack.f_41583_);
            return removedSomething;
        }
        return false;
    }

    protected void sendUpdate(Level level, BlockPos pos, BlockState state) {
        TrayBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        level.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public void loadFromItem(@Nonnull ItemStack stack, Level level, BlockPos pos, BlockState state) {
        this.items = TrayItem.getContents(stack);
        this.sendUpdate(level, pos, state);
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Items", (Tag)TrayItem.saveItemToTagList(this.items));
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Items")) {
            this.items = TrayItem.getContents(tag.m_128437_("Items", 10));
        }
    }

    public void dropItem(@Nonnull Level level, @Nonnull BlockPos pos) {
        ItemStack i = TrayItem.createTrayFrom(this.items);
        double d0 = EntityType.f_20461_.m_20678_();
        double d1 = 0.2;
        double d2 = d0 / 2.0;
        double d3 = Math.floor(pos.m_123341_()) + level.f_46441_.m_188500_() * d1 + d2;
        double d4 = Math.floor(pos.m_123342_()) + level.f_46441_.m_188500_() * d1;
        double d5 = Math.floor(pos.m_123343_()) + level.f_46441_.m_188500_() * d1 + d2;
        ItemEntity e = new ItemEntity(level, d3, d4, d5, i);
        e.m_20334_(level.f_46441_.m_216328_(0.0, 0.11485000171139836), level.f_46441_.m_216328_(0.2, 0.11485000171139836), level.f_46441_.m_216328_(0.0, 0.11485000171139836));
        e.m_32060_();
        level.m_7967_((Entity)e);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
    }

    protected boolean hasFood() {
        for (ItemStack itemStack : this.items) {
            if (itemStack.getFoodProperties(null) == null) continue;
            return true;
        }
        return false;
    }

    protected boolean hasSpoon() {
        for (ItemStack itemStack : this.items) {
            if (!itemStack.m_150930_((Item)ModItems.SPOON.get())) continue;
            return true;
        }
        return false;
    }

    protected boolean hasFork() {
        for (ItemStack itemStack : this.items) {
            if (!itemStack.m_150930_((Item)ModItems.FORK.get())) continue;
            return true;
        }
        return false;
    }

    protected boolean hasKnife() {
        for (ItemStack itemStack : this.items) {
            if (!itemStack.m_150930_((Item)ModItems.KNIFE.get())) continue;
            return true;
        }
        return false;
    }

    protected ItemStack getFood() {
        for (ItemStack itemStack : this.items) {
            if (itemStack.getFoodProperties(null) == null) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    protected ItemStack getFork() {
        for (ItemStack itemStack : this.items) {
            if (!itemStack.m_150930_((Item)ModItems.FORK.get())) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    protected ItemStack getSpoon() {
        for (ItemStack itemStack : this.items) {
            if (!itemStack.m_150930_((Item)ModItems.SPOON.get())) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    protected ItemStack getKnife() {
        for (ItemStack itemStack : this.items) {
            if (!itemStack.m_150930_((Item)ModItems.KNIFE.get())) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }
}

