/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.blocks;

import com.lazrproductions.cuffed.blocks.base.PosterType;
import com.lazrproductions.cuffed.init.ModBlockProperties;
import com.lazrproductions.cuffed.items.PosterBlockItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PosterBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final EnumProperty<PosterType> POSTER_TYPE = ModBlockProperties.POSTER_TYPE;
    protected static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final VoxelShape SHAPE_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_WEST = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public PosterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_(POSTER_TYPE, (Comparable)((Object)PosterType.NONE)));
    }

    @Nullable
    public BlockState m_5573_(@Nonnull BlockPlaceContext ctx) {
        BlockPos blockpos = ctx.m_8083_();
        Level level = ctx.m_43725_();
        if (blockpos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(blockpos.m_7494_()).m_60629_(ctx)) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        if (blockpos.m_123342_() > level.m_141937_() + 1 && level.m_8055_(blockpos.m_7495_()).m_60629_(ctx)) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER);
        }
        return null;
    }

    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter getter, @Nonnull BlockPos pos, @Nonnull CollisionContext ctx) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_EAST;
    }

    public VoxelShape m_5939_(@Nonnull BlockState state, @Nonnull BlockGetter getter, @Nonnull BlockPos pos, @Nonnull CollisionContext ctx) {
        return this.m_5940_(state, getter, pos, ctx);
    }

    public BlockState m_6843_(@Nonnull BlockState state, @Nonnull Rotation r) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)r.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(@Nonnull BlockState state, @Nonnull Mirror m) {
        return state.m_60717_(m.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_6402_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity entity, @Nonnull ItemStack stack) {
        if (level.m_8055_(pos.m_7494_()).m_60795_()) {
            level.m_7731_(pos.m_7494_(), (BlockState)((BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_(POSTER_TYPE, (Comparable)((Object)((PosterType)((Object)state.m_61143_(POSTER_TYPE))))), 3);
        } else if (level.m_8055_(pos.m_7495_()).m_60795_()) {
            level.m_7731_(pos.m_7495_(), (BlockState)((BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_(POSTER_TYPE, (Comparable)((Object)((PosterType)((Object)state.m_61143_(POSTER_TYPE))))), 3);
        }
    }

    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction direction, @Nonnull BlockState otherState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos otherPos) {
        DoubleBlockHalf thisHalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (direction.m_122434_() == Direction.Axis.Y && thisHalf == DoubleBlockHalf.LOWER == (direction == Direction.UP)) {
            return otherState.m_60713_((Block)this) && otherState.m_61143_(HALF) != thisHalf ? (BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)otherState.m_61143_((Property)FACING))) : Blocks.f_50016_.m_49966_();
        }
        return thisHalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : state;
    }

    public boolean m_7898_(@Nonnull BlockState state, @Nonnull LevelReader level, @Nonnull BlockPos pos) {
        Direction behindDirection = ((Direction)state.m_61143_((Property)FACING)).m_122424_();
        BlockPos posBehind = pos.m_121945_(behindDirection);
        BlockState stateBehind = level.m_8055_(posBehind);
        return stateBehind.m_60783_((BlockGetter)level, posBehind, behindDirection.m_122424_());
    }

    public void m_5707_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        if (!level.f_46443_ && player.m_7500_()) {
            PosterBlock.preventCreativeDropFromBottomPart(level, pos, state, player);
        }
        super.m_5707_(level, pos, state, player);
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, HALF, POSTER_TYPE});
    }

    protected static void preventCreativeDropFromBottomPart(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = level.m_8055_(blockpos = pos.m_7495_())).m_60713_(state.m_60734_()) && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockstate1 = blockstate.m_60819_().m_192917_((Fluid)Fluids.f_76193_) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            level.m_7731_(blockpos, blockstate1, 35);
            level.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return PosterBlockItem.newItemFromType((PosterType)((Object)state.m_61143_(POSTER_TYPE)));
    }
}

