/*
 * Decompiled with CFR 0.152.
 */
package reloc.org.sat4j.pb.orders;

import java.math.BigInteger;
import reloc.org.sat4j.core.VecInt;
import reloc.org.sat4j.minisat.core.ILits;
import reloc.org.sat4j.minisat.core.IOrder;
import reloc.org.sat4j.pb.constraints.pb.PBConstr;
import reloc.org.sat4j.pb.orders.BumpStrategy;
import reloc.org.sat4j.pb.orders.IBumper;
import reloc.org.sat4j.specs.IVecInt;
import reloc.org.sat4j.specs.IteratorInt;

public class BumperEffectiveAndPropagated
implements IBumper {
    private int propagatedLit;
    private BigInteger constrDegree;
    private final IVecInt bumpableCandidates = new VecInt();
    private BumpStrategy bumpStrategy;

    @Override
    public void varBumpActivity(ILits voc, BumpStrategy bStrategy, IOrder order, PBConstr constr, int lit, int propagated) {
        if (lit == 0) {
            this.constrDegree = constr.getDegree();
            this.bumpableCandidates.clear();
            this.bumpStrategy = bStrategy;
            this.propagatedLit = constr.get(propagated);
        }
        int currentLit = constr.get(lit);
        if (lit == propagated || voc.isSatisfied(currentLit) && voc.getLevel(currentLit) == voc.getLevel(propagated)) {
            bStrategy.varBumpActivity(order, constr, lit);
        } else if (!voc.isFalsified(currentLit)) {
            this.constrDegree = this.constrDegree.subtract(constr.getCoef(lit));
        } else {
            this.bumpableCandidates.push(lit);
        }
    }

    @Override
    public void postBumpActivity(IOrder order, PBConstr constr) {
        int v;
        IteratorInt it = this.bumpableCandidates.iterator();
        while (it.hasNext() && constr.getCoef(v = it.next()).compareTo(this.constrDegree) >= 0) {
            this.bumpStrategy.varBumpActivity(order, constr, v);
        }
    }

    public String toString() {
        return "EFFECTIVE AND PROPAGATED";
    }
}

