/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraftforge.registries.IForgeRegistry;

public class ExtraCodecs {
    public static Codec<Object> anyOf(final Codec<?> ... codecs) {
        return new Codec<Object>(){

            public <T> DataResult<T> encode(Object input, DynamicOps<T> ops, T prefix) {
                for (Codec codec : codecs) {
                    try {
                        DataResult result = codec.encode(input, ops, prefix);
                        if (!result.result().isPresent()) continue;
                        return result;
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
                return DataResult.error(() -> "No codecs could encode input " + input);
            }

            public <T> DataResult<Pair<Object, T>> decode(DynamicOps<T> ops, T input) {
                for (Codec codec : codecs) {
                    DataResult result = codec.decode(ops, input);
                    if (!result.result().isPresent()) continue;
                    return result;
                }
                return DataResult.error(() -> "No codecs could decode input " + input);
            }
        };
    }

    public static <F, S> Codec<Pair<F, S>> pair(Codec<F> firstCodec, Codec<S> secondCodec) {
        return RecordCodecBuilder.create(instance -> instance.group((App)firstCodec.fieldOf("first").forGetter(Pair::getFirst), (App)secondCodec.fieldOf("second").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of));
    }

    public static <T> Codec<T> deferred(final Supplier<Codec<T>> codecSupplier) {
        return new Codec<T>(){

            public <U> DataResult<Pair<T, U>> decode(DynamicOps<U> ops, U input) {
                return ((Codec)codecSupplier.get()).decode(ops, input);
            }

            public <U> DataResult<U> encode(T input, DynamicOps<U> ops, U prefix) {
                return ((Codec)codecSupplier.get()).encode(input, ops, prefix);
            }
        };
    }

    public static <K, V> Codec<Map<K, V>> builtinMapCodec(final IForgeRegistry<K> keyRegistry, final Codec<V> valueCodec) {
        return new Codec<Map<K, V>>(){

            public <T> DataResult<Pair<Map<K, V>, T>> decode(DynamicOps<T> ops, T input) {
                RegistryOps decoderOps = RegistryOps.m_255058_(ops, (HolderLookup.Provider)RegistryHelper.getRegistryAccess());
                Optional keyMapResult = Codec.unboundedMap((Codec)Codec.STRING, (Codec)valueCodec).decode((DynamicOps)decoderOps, input).result();
                Map keyMap = (Map)((Pair)keyMapResult.orElseThrow()).getFirst();
                HashMap holderMap = new HashMap();
                for (Map.Entry entry : keyMap.entrySet()) {
                    ResourceLocation id = new ResourceLocation((String)entry.getKey());
                    Object key = keyRegistry.getValue(id);
                    if (key == null) continue;
                    holderMap.put(key, entry.getValue());
                }
                return DataResult.success((Object)Pair.of(holderMap, (Object)keyMapResult.map(Pair::getSecond).orElseThrow()));
            }

            public <T> DataResult<T> encode(Map<K, V> input, DynamicOps<T> ops, T prefix) {
                RegistryOps encoderOps = RegistryOps.m_255058_(ops, (HolderLookup.Provider)RegistryHelper.getRegistryAccess());
                HashMap keyMap = new HashMap();
                for (Map.Entry entry : input.entrySet()) {
                    keyMap.put(keyRegistry.getKey(entry.getKey()).toString(), entry.getValue());
                }
                return Codec.unboundedMap((Codec)Codec.STRING, (Codec)valueCodec).encode(keyMap, (DynamicOps)encoderOps, prefix);
            }
        };
    }

    public static <K, V> Codec<Multimap<K, V>> builtinMultimapCodec(IForgeRegistry<K> keyRegistry, Codec<V> valueCodec) {
        return ExtraCodecs.builtinMapCodec(keyRegistry, valueCodec.listOf()).xmap(map -> {
            HashMultimap multimap = HashMultimap.create();
            for (Map.Entry entry : map.entrySet()) {
                multimap.putAll(entry.getKey(), (Iterable)entry.getValue());
            }
            return multimap;
        }, multimap -> {
            HashMap fastMultiMap = new HashMap();
            for (Map.Entry entry : multimap.asMap().entrySet()) {
                fastMultiMap.put(entry.getKey(), new ArrayList((Collection)entry.getValue()));
            }
            return fastMultiMap;
        });
    }

    public static <K, V> Codec<Map<Holder<K>, V>> registryMapCodec(final ResourceKey<Registry<K>> keyRegistry, final Codec<V> valueCodec) {
        return new Codec<Map<Holder<K>, V>>(){

            public <T> DataResult<Pair<Map<Holder<K>, V>, T>> decode(DynamicOps<T> ops, T input) {
                RegistryOps decoderOps = RegistryOps.m_255058_(ops, (HolderLookup.Provider)RegistryHelper.getRegistryAccess());
                Optional keyMapResult = Codec.unboundedMap((Codec)Codec.STRING, (Codec)valueCodec).decode((DynamicOps)decoderOps, input).result();
                Map keyMap = (Map)((Pair)keyMapResult.orElseThrow()).getFirst();
                RegistryAccess registryAccess = RegistryHelper.getRegistryAccess();
                Registry reg = registryAccess.m_175515_(keyRegistry);
                HashMap holderMap = new HashMap();
                for (Map.Entry entry : keyMap.entrySet()) {
                    ResourceKey key = ResourceKey.m_135785_((ResourceKey)keyRegistry, (ResourceLocation)new ResourceLocation((String)entry.getKey()));
                    reg.m_203636_(key).ifPresent(k -> holderMap.put(k, entry.getValue()));
                }
                return DataResult.success((Object)Pair.of(holderMap, (Object)keyMapResult.map(Pair::getSecond).orElseThrow()));
            }

            public <T> DataResult<T> encode(Map<Holder<K>, V> input, DynamicOps<T> ops, T prefix) {
                RegistryOps encoderOps = RegistryOps.m_255058_(ops, (HolderLookup.Provider)RegistryHelper.getRegistryAccess());
                HashMap keyMap = new HashMap();
                for (Map.Entry entry : input.entrySet()) {
                    entry.getKey().m_203543_().ifPresent(k -> keyMap.put(k.m_135782_().toString(), entry.getValue()));
                }
                return Codec.unboundedMap((Codec)Codec.STRING, (Codec)valueCodec).encode(keyMap, (DynamicOps)encoderOps, prefix);
            }
        };
    }

    public static <K, V> Codec<Multimap<Holder<K>, V>> registryMultimapCodec(ResourceKey<Registry<K>> keyRegistry, Codec<V> valueCodec) {
        return ExtraCodecs.registryMapCodec(keyRegistry, valueCodec.listOf()).xmap(map -> {
            HashMultimap multimap = HashMultimap.create();
            for (Map.Entry entry : map.entrySet()) {
                multimap.putAll((Object)((Holder)entry.getKey()), (Iterable)entry.getValue());
            }
            return multimap;
        }, multimap -> {
            HashMap fastMultiMap = new HashMap();
            for (Map.Entry entry : multimap.asMap().entrySet()) {
                fastMultiMap.put((Holder)entry.getKey(), new ArrayList((Collection)entry.getValue()));
            }
            return fastMultiMap;
        });
    }

    public static <T extends Enum<T>> Codec<T> enumIgnoreCase(T[] values) {
        return Codec.STRING.xmap(str -> {
            if (values.length == 0) {
                throw new IllegalArgumentException("Enum has no values");
            }
            for (Enum value : values) {
                if (!((StringRepresentable)value).m_7912_().equalsIgnoreCase((String)str)) continue;
                return value;
            }
            throw new IllegalArgumentException(String.format("Unknown %s value: %s", values[0].getClass().getSimpleName(), str));
        }, rec$ -> ((StringRepresentable)rec$).m_7912_());
    }
}

