/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.data.codec.util.ExtraCodecs;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.registries.ForgeRegistries;

public record BlockRequirement(NegatableList<Either<TagKey<Block>, Block>> blocks, StateRequirement state, NbtRequirement nbt, List<Direction> sturdyFaces, Optional<Boolean> replaceable) {
    public static final BlockRequirement NONE = new BlockRequirement(new NegatableList<Either<TagKey<Block>, Block>>(), StateRequirement.NONE, NbtRequirement.NONE, List.of(), Optional.empty());
    public static final Codec<BlockRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NegatableList.listCodec(ConfigHelper.tagOrBuiltinCodec(Registries.f_256747_, ForgeRegistries.BLOCKS)).optionalFieldOf("blocks", new NegatableList()).forGetter(predicate -> predicate.blocks), (App)StateRequirement.CODEC.optionalFieldOf("state", (Object)StateRequirement.NONE).forGetter(predicate -> predicate.state), (App)NbtRequirement.CODEC.optionalFieldOf("nbt", (Object)NbtRequirement.NONE).forGetter(predicate -> predicate.nbt), (App)Direction.f_175356_.listOf().optionalFieldOf("sturdy_faces", List.of()).forGetter(predicate -> predicate.sturdyFaces), (App)Codec.BOOL.optionalFieldOf("replaceable").forGetter(predicate -> predicate.replaceable)).apply((Applicative)instance, BlockRequirement::new));

    public BlockRequirement(List<Either<TagKey<Block>, Block>> blocks) {
        this(new NegatableList<Either<TagKey<Block>, Block>>(blocks), StateRequirement.NONE, NbtRequirement.NONE, List.of(), Optional.empty());
    }

    public boolean test(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockentity;
        if (!level.m_46749_(pos)) {
            return true;
        }
        if (!this.blocks.test(either -> (Boolean)either.map(arg_0 -> ((BlockState)state).m_204336_(arg_0), arg_0 -> ((BlockState)state).m_60713_(arg_0)))) {
            return false;
        }
        if (!this.state.test(state)) {
            return false;
        }
        if (!this.nbt.isEmpty() && (blockentity = level.m_7702_(pos)) != null && !this.nbt.test(blockentity.m_187480_())) {
            return false;
        }
        if (!this.sturdyFaces.isEmpty() && this.sturdyFaces.stream().noneMatch(face -> state.m_60783_((BlockGetter)level, pos, face))) {
            return false;
        }
        return !this.replaceable.isPresent() || state.m_60795_() || state.m_247087_();
    }

    public boolean test(Level level, BlockPos pos) {
        if (!level.m_46749_(pos)) {
            return true;
        }
        return this.test(level, pos, level.m_8055_(pos));
    }

    @Override
    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BlockRequirement that = (BlockRequirement)obj;
        return this.blocks.equals(that.blocks) && this.state.equals(that.state) && this.nbt.equals(that.nbt) && this.sturdyFaces.equals(that.sturdyFaces) && this.replaceable.equals(that.replaceable);
    }

    public record StateRequirement(Map<String, Object> properties) {
        public static final Codec<StateRequirement> CODEC = Codec.unboundedMap((Codec)Codec.STRING, ExtraCodecs.anyOf(new Codec[]{Codec.BOOL, IntegerBounds.CODEC, Codec.STRING, Codec.STRING.listOf()})).xmap(StateRequirement::new, StateRequirement::properties);
        public static final StateRequirement NONE = new StateRequirement(new HashMap<String, Object>());

        public boolean test(BlockState state) {
            return this.test(state.m_60734_().m_49965_(), state);
        }

        public boolean test(FluidState state) {
            return this.test(state.m_76152_().m_76144_(), state);
        }

        public <S extends StateHolder<?, S>> boolean test(StateDefinition<?, S> stateDefinition, S state) {
            block0: for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                Property property = stateDefinition.m_61081_(key);
                if (property == null) {
                    return false;
                }
                if (value instanceof IntegerBounds) {
                    IntegerBounds bounds = (IntegerBounds)value;
                    if (property.m_6908_().contains(bounds.min()) && property.m_6908_().contains(bounds.max()) && bounds.test((Integer)state.m_61143_(property))) continue;
                    return false;
                }
                if (value instanceof List) {
                    List list = (List)value;
                    if (list.isEmpty()) continue;
                    for (Object val : list) {
                        if (!state.m_61143_(property).toString().equals(val.toString())) continue;
                        continue block0;
                    }
                    return false;
                }
                if (value instanceof Boolean) {
                    Boolean bool = (Boolean)value;
                    if (property.m_6908_().contains(bool) && state.m_61143_(property).equals(bool)) continue;
                    return false;
                }
                if (property.m_6908_().contains(value) && state.m_61143_(property).toString().equals(value.toString())) continue;
                return false;
            }
            return true;
        }

        public static StateRequirement fromToml(String[] entries, Block block) {
            return StateRequirement.fromToml(Arrays.asList(entries), block);
        }

        public static StateRequirement fromToml(List<String> entries, Block block) {
            HashMap<String, Object> blockPredicates = new HashMap<String, Object>();
            for (String predicate : entries) {
                String[] pair = predicate.split("=");
                String key = pair[0];
                String value = pair[1];
                Property property = block.m_49965_().m_61081_(key);
                if (property == null) continue;
                property.m_6215_(value).ifPresent(propertyValue -> blockPredicates.put(key, propertyValue));
            }
            return new StateRequirement(blockPredicates);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            StateRequirement that = (StateRequirement)obj;
            return this.properties.equals(that.properties);
        }
    }
}

