/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.network.message;

import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class SyncTempModifiersMessage {
    int entityId;
    CompoundTag modifiers;

    public SyncTempModifiersMessage(LivingEntity entity, CompoundTag modifiers) {
        this.entityId = entity.m_19879_();
        this.modifiers = modifiers;
    }

    SyncTempModifiersMessage(int entityId, CompoundTag modifiers) {
        this.entityId = entityId;
        this.modifiers = modifiers;
    }

    public static void encode(SyncTempModifiersMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.entityId);
        buffer.m_130079_(message.modifiers);
    }

    public static SyncTempModifiersMessage decode(FriendlyByteBuf buffer) {
        return new SyncTempModifiersMessage(buffer.readInt(), buffer.m_130260_());
    }

    public static void handle(SyncTempModifiersMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> {
                Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(message.entityId);
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    EntityTempManager.getTemperatureCap((Entity)living).ifPresent(cap -> cap.deserializeModifiers(message.modifiers));
                }
            });
        }
        context.setPacketHandled(true);
    }
}

