/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.momosoftworks.coldsweat.api.temperature.modifier.WaterTempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.DryingItemData;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Collection;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerDrying {
    @SubscribeEvent
    public static void onDryingItemUsed(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        Collection dryingResults = ConfigSettings.DRYING_ITEMS.get().get((Object)stack.m_41720_());
        if (!player.m_9236_().m_5776_() && Temperature.hasModifier((LivingEntity)player, Temperature.Trait.WORLD, WaterTempModifier.class)) {
            for (DryingItemData dryingResult : dryingResults) {
                if (!dryingResult.test((Entity)player, stack)) continue;
                ItemStack newStack = dryingResult.result();
                CompoundTag oldTag = NBTHelper.getTagOrEmpty(stack).m_6426_();
                if (!oldTag.m_128456_()) {
                    newStack.m_41784_().m_128391_(NBTHelper.getTagOrEmpty(stack).m_6426_());
                }
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                    if (!player.m_150109_().m_36054_(newStack)) {
                        player.m_36176_(newStack, false);
                    }
                }
                player.m_21011_(event.getHand(), true);
                WorldHelper.playEntitySound(dryingResult.sound(), (Entity)player, SoundSource.PLAYERS, 1.0f, 1.0f);
                Temperature.removeModifiers((LivingEntity)player, Temperature.Trait.WORLD, mod -> mod instanceof WaterTempModifier);
                break;
            }
        }
    }
}

