/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability;

import com.momosoftworks.coldsweat.common.capability.CapabilityCache;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.util.thread.EffectiveSide;

public class SidedCapabilityCache<C, K extends ICapabilityProvider>
extends CapabilityCache<C, K> {
    protected final CapabilityCache<C, K> clientCache;

    public SidedCapabilityCache(Capability<C> capability, Predicate<K> invalidator) {
        super(capability, invalidator);
        this.clientCache = new CapabilityCache<C, K>(capability, invalidator);
    }

    public SidedCapabilityCache(Capability<C> capability) {
        super(capability);
        this.clientCache = new CapabilityCache(capability);
    }

    @Override
    public LazyOptional<C> get(K key) {
        return EffectiveSide.get().isClient() ? this.clientCache.get(key) : super.get(key);
    }

    @Override
    public void remove(K key) {
        if (EffectiveSide.get().isClient()) {
            this.clientCache.remove(key);
        } else {
            super.remove(key);
        }
    }

    public void clearClient() {
        this.clientCache.clear();
    }

    public void clearServer() {
        super.clear();
    }

    @Override
    public void clear() {
        if (EffectiveSide.get().isClient()) {
            this.clearClient();
        } else {
            this.clearServer();
        }
    }

    @Override
    public void ifPresent(K key, Consumer<C> consumer) {
        if (EffectiveSide.get().isClient()) {
            this.clientCache.ifPresent(key, consumer);
        } else {
            super.ifPresent(key, consumer);
        }
    }

    @Override
    public void ifLazyPresent(K key, Consumer<LazyOptional<C>> consumer) {
        if (EffectiveSide.get().isClient()) {
            this.clientCache.ifLazyPresent(key, consumer);
        } else {
            super.ifLazyPresent(key, consumer);
        }
    }
}

