/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.block;

import com.momosoftworks.coldsweat.data.tag.ModBlockTags;
import com.momosoftworks.coldsweat.data.tag.ModItemTags;
import com.momosoftworks.coldsweat.util.serialization.EnumHelper;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SmokestackBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Facing> FACING = EnumProperty.m_61587_((String)"facing", Facing.class);
    public static final BooleanProperty END = BooleanProperty.m_61465_((String)"end");
    public static final BooleanProperty BASE = BooleanProperty.m_61465_((String)"base");
    public static final BooleanProperty ENCASED = BooleanProperty.m_61465_((String)"encased");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public SmokestackBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(FACING, (Comparable)((Object)Facing.UP))).m_61124_((Property)END, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BASE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ENCASED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public static BlockBehaviour.Properties getProperties() {
        return BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_60978_(2.0f).m_155956_(10.0f).m_60999_();
    }

    public static Item.Properties getItemProperties() {
        return new Item.Properties();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_6047_() && stack.m_204117_(ModItemTags.ENCASES_SMOKESTACK) && !((Boolean)state.m_61143_((Property)ENCASED)).booleanValue() && state.m_61143_(FACING) != Facing.BEND) {
            level.m_7731_(pos, (BlockState)((BlockState)((BlockState)state.m_61124_((Property)ENCASED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)END, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BASE, (Comparable)Boolean.valueOf(false)), 3);
            player.m_21011_(hand, true);
            level.m_5594_(null, pos, this.getSoundType(state, (LevelReader)level, pos, (Entity)player).m_56777_(), SoundSource.BLOCKS, 1.0f, 0.8f);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6227_(state, level, pos, player, hand, rayTraceResult);
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)ENCASED) == false && state.m_61143_(FACING) != Facing.BEND;
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return (Boolean)state.m_61143_((Property)ENCASED) != false || state.m_61143_(FACING) == Facing.BEND;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)ENCASED)).booleanValue()) {
            return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        }
        return switch ((Facing)((Object)state.m_61143_(FACING))) {
            default -> throw new IncompatibleClassChangeError();
            case Facing.UP, Facing.DOWN -> Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
            case Facing.NORTH, Facing.SOUTH -> Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0);
            case Facing.EAST, Facing.WEST -> Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
            case Facing.BEND -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        };
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_(FACING, (Comparable)((Object)((Facing)((Object)state.m_61143_(FACING))).rotate(rotation)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_(FACING, (Comparable)((Object)((Facing)((Object)state.m_61143_(FACING))).mirror(mirror)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, END, BASE, ENCASED, WATERLOGGED});
    }

    protected Facing calculateFacing(Facing facing, BlockPos pos, LevelAccessor level) {
        Direction newDir = null;
        for (Direction dir : Direction.values()) {
            BlockState neighborState = level.m_8055_(pos.m_121945_(dir));
            if (!neighborState.m_204336_(ModBlockTags.CONNECTS_SMOKESTACK) && (dir != Direction.DOWN || !neighborState.m_204336_(ModBlockTags.THERMAL_SOURCE))) continue;
            if (newDir != null && newDir.m_122434_() != dir.m_122434_()) {
                return Facing.BEND;
            }
            newDir = dir;
        }
        if (newDir != null) {
            if (newDir.m_122434_() == facing.getAxis()) {
                return facing;
            }
            BlockState neighbor = level.m_8055_(pos.m_121945_(newDir));
            if (neighbor.m_60734_() instanceof SmokestackBlock) {
                Facing neighborFacing = (Facing)((Object)neighbor.m_61143_(FACING));
                return neighborFacing == Facing.BEND ? (facing.getAxis() != newDir.m_122434_() ? Facing.fromDirection(newDir.m_122424_()) : facing) : (neighborFacing.getAxis() != newDir.m_122434_() ? Facing.fromDirection(newDir.m_122424_()) : neighborFacing);
            }
            return Facing.fromDirection(newDir.m_122424_());
        }
        return facing;
    }

    protected BlockState calculateConnections(BlockState state, BlockPos pos, LevelAccessor level) {
        Facing facing = (Facing)((Object)state.m_61143_(FACING));
        if (facing == Facing.BEND) {
            return (BlockState)((BlockState)state.m_61124_((Property)END, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BASE, (Comparable)Boolean.valueOf(false));
        }
        boolean connectedTop = level.m_8055_(pos.m_121945_(facing.toDirection())).m_204336_(ModBlockTags.CONNECTS_SMOKESTACK);
        boolean connectedBase = level.m_8055_(pos.m_121945_(facing.toDirection().m_122424_())).m_204336_(ModBlockTags.CONNECTS_SMOKESTACK);
        return (BlockState)((BlockState)state.m_61124_((Property)END, (Comparable)Boolean.valueOf(connectedTop))).m_61124_((Property)BASE, (Comparable)Boolean.valueOf(connectedBase));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction placeDir = context.m_43719_();
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        Facing facing = Facing.fromDirection(placeDir);
        facing = this.calculateFacing(facing, pos, (LevelAccessor)level);
        BlockState state = (BlockState)this.m_49966_().m_61124_(FACING, (Comparable)((Object)facing));
        if (facing != Facing.BEND) {
            state = this.calculateConnections(state, pos, (LevelAccessor)level);
        }
        state = WorldHelper.waterlog(state, level, pos);
        return state;
    }

    protected BlockState updateFluid(LevelAccessor level, BlockState state, BlockPos pos) {
        if (state.m_61143_(FACING) == Facing.BEND || ((Boolean)state.m_61143_((Property)ENCASED)).booleanValue()) {
            return (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction neighborDir, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        state = this.updateFluid(level, state, pos);
        Facing facing = this.calculateFacing((Facing)((Object)state.m_61143_(FACING)), pos, level);
        state = (BlockState)state.m_61124_(FACING, (Comparable)((Object)facing));
        state = this.calculateConnections(state, pos, level);
        return state;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter ilevel, BlockPos pos) {
        float progress = super.m_5880_(state, player, ilevel, pos);
        if (((Boolean)state.m_61143_((Property)ENCASED)).booleanValue()) {
            progress *= 2.0f;
        }
        return progress;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (((Boolean)state.m_61143_((Property)ENCASED)).booleanValue()) {
            state = this.updateFluid((LevelAccessor)level, state, pos);
            level.m_7731_(pos, (BlockState)this.calculateConnections(state, pos, (LevelAccessor)level).m_61124_((Property)ENCASED, (Comparable)Boolean.valueOf(false)), 3);
            level.m_142052_(pos, state);
            level.m_5594_(null, pos, this.getSoundType(state, (LevelReader)level, pos, (Entity)player).m_56775_(), SoundSource.BLOCKS, 1.0f, 0.8f);
            return false;
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public static enum Facing implements StringRepresentable
    {
        UP("up"),
        DOWN("down"),
        NORTH("north"),
        SOUTH("south"),
        EAST("east"),
        WEST("west"),
        BEND("bend");

        private final String name;

        private Facing(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public static Facing byName(String name) {
            return (Facing)EnumHelper.byName((Enum[])Facing.values(), (String)name);
        }

        public static Facing fromDirection(Direction direction) {
            return switch (direction) {
                case Direction.DOWN -> DOWN;
                case Direction.NORTH -> NORTH;
                case Direction.SOUTH -> SOUTH;
                case Direction.EAST -> EAST;
                case Direction.WEST -> WEST;
                default -> UP;
            };
        }

        public Direction toDirection() {
            return switch (this) {
                case DOWN -> Direction.DOWN;
                case NORTH -> Direction.NORTH;
                case SOUTH -> Direction.SOUTH;
                case EAST -> Direction.EAST;
                case WEST -> Direction.WEST;
                default -> Direction.UP;
            };
        }

        @Nullable
        public Direction.Axis getAxis() {
            return this == BEND ? null : this.toDirection().m_122434_();
        }

        public Facing rotate(Rotation rotation) {
            return switch (rotation) {
                case Rotation.CLOCKWISE_90 -> {
                    switch (this) {
                        case NORTH: {
                            yield EAST;
                        }
                        case EAST: {
                            yield SOUTH;
                        }
                        case SOUTH: {
                            yield WEST;
                        }
                        case WEST: {
                            yield NORTH;
                        }
                    }
                    yield this;
                }
                case Rotation.CLOCKWISE_180 -> {
                    switch (this) {
                        case NORTH: {
                            yield SOUTH;
                        }
                        case SOUTH: {
                            yield NORTH;
                        }
                        case EAST: {
                            yield WEST;
                        }
                        case WEST: {
                            yield EAST;
                        }
                    }
                    yield this;
                }
                case Rotation.COUNTERCLOCKWISE_90 -> {
                    switch (this) {
                        case NORTH: {
                            yield WEST;
                        }
                        case WEST: {
                            yield SOUTH;
                        }
                        case SOUTH: {
                            yield EAST;
                        }
                        case EAST: {
                            yield NORTH;
                        }
                    }
                    yield this;
                }
                default -> this;
            };
        }

        public Facing mirror(Mirror mirror) {
            return switch (mirror) {
                case Mirror.FRONT_BACK -> {
                    switch (this) {
                        case NORTH: {
                            yield SOUTH;
                        }
                        case SOUTH: {
                            yield NORTH;
                        }
                    }
                    yield this;
                }
                case Mirror.LEFT_RIGHT -> {
                    switch (this) {
                        case EAST: {
                            yield WEST;
                        }
                        case WEST: {
                            yield EAST;
                        }
                    }
                    yield this;
                }
                default -> this;
            };
        }
    }
}

