/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.momosoftworks.coldsweat.common.block.HearthBottomBlock;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HearthBlockEntityRenderer
implements BlockEntityRenderer<HearthBlockEntity> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("cold_sweat", "textures/block/hearth.png");
    public static final ResourceLocation TEXTURE_SMART = new ResourceLocation("cold_sweat", "textures/block/hearth_smart.png");
    public static final ResourceLocation TEXTURE_HEAT_ON = new ResourceLocation("cold_sweat", "textures/block/hearth_heat_on.png");
    public static final ResourceLocation TEXTURE_COLD_ON = new ResourceLocation("cold_sweat", "textures/block/hearth_cold_on.png");
    public static final ResourceLocation TEXTURE_FROST = new ResourceLocation("cold_sweat", "textures/block/hearth_frost.png");
    public static final ResourceLocation TEXTURE_LIT = new ResourceLocation("cold_sweat", "textures/block/hearth_lit.png");
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("cold_sweat", "hearth"), "main");
    private final ModelPart body;
    private final ModelPart grate;

    public HearthBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart base = context.m_173582_(LAYER_LOCATION);
        this.body = base.m_171324_("body");
        this.grate = base.m_171324_("grate");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-16.0f, -16.0f, 0.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)8.0f, (float)24.0f, (float)-8.0f));
        PartDefinition grate = partdefinition.m_171599_("grate", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-5.0f, -9.0f, -9.0f, 10.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(HearthBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockstate = blockEntity.m_58900_();
        poseStack.m_85836_();
        float f = ((Direction)blockstate.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122435_();
        poseStack.m_252880_(0.5f, 0.5f, 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        poseStack.m_252880_(0.0f, -1.0f, 0.0f);
        VertexConsumer baseVertexes = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)HearthBlockEntityRenderer.getTexture(blockstate)));
        this.body.m_104301_(poseStack, baseVertexes, light, overlay);
        this.grate.m_104301_(poseStack, baseVertexes, light, overlay);
        if (((Boolean)blockstate.m_61143_((Property)HearthBottomBlock.LIT)).booleanValue()) {
            VertexConsumer litVertexes = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)TEXTURE_LIT));
            this.grate.m_104301_(poseStack, litVertexes, light, overlay);
        }
        if (((Boolean)blockstate.m_61143_((Property)HearthBottomBlock.FROSTED)).booleanValue()) {
            VertexConsumer frostedVertexes = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)TEXTURE_FROST));
            this.body.m_104301_(poseStack, frostedVertexes, light, overlay);
        }
        if (!((Boolean)blockstate.m_61143_((Property)HearthBottomBlock.SMART)).booleanValue()) {
            if (((Boolean)blockstate.m_61143_((Property)HearthBottomBlock.HEATING)).booleanValue()) {
                VertexConsumer heatingVertexes = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)TEXTURE_HEAT_ON));
                this.body.m_104301_(poseStack, heatingVertexes, light, overlay);
            }
            if (((Boolean)blockstate.m_61143_((Property)HearthBottomBlock.COOLING)).booleanValue()) {
                VertexConsumer coolingVertexes = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)TEXTURE_COLD_ON));
                this.body.m_104301_(poseStack, coolingVertexes, light, overlay);
            }
        }
        poseStack.m_85849_();
    }

    public static ResourceLocation getTexture(BlockState state) {
        return (Boolean)state.m_61143_((Property)HearthBottomBlock.SMART) != false ? TEXTURE_SMART : TEXTURE;
    }
}

