/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.momosoftworks.coldsweat.api.insulation.AdaptiveInsulation;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.insulation.StaticInsulation;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientInsulationTooltip
implements ClientTooltipComponent {
    public static final ResourceLocation TOOLTIP = new ResourceLocation("cold_sweat:textures/gui/tooltip/insulation_bar.png");
    public static final ResourceLocation TOOLTIP_HC = new ResourceLocation("cold_sweat:textures/gui/tooltip/insulation_bar_hc.png");
    public static final Supplier<ResourceLocation> TOOLTIP_LOCATION = () -> ConfigSettings.HIGH_CONTRAST.get() != false ? TOOLTIP_HC : TOOLTIP;
    List<InsulatorData> insulation;
    Insulation.Slot slot;
    static int WIDTH = 0;
    ItemStack stack;
    boolean strikethrough;
    static boolean RECURSIVE = false;

    public ClientInsulationTooltip(List<InsulatorData> insulation, Insulation.Slot slot, ItemStack stack, boolean strikethrough) {
        this.insulation = insulation;
        this.slot = slot;
        this.stack = stack;
        this.strikethrough = strikethrough;
    }

    public int m_142103_() {
        return 10;
    }

    public int m_142069_(Font font) {
        return WIDTH;
    }

    public void m_183452_(Font font, int x, int y, GuiGraphics graphics) {
        PoseStack poseStack = graphics.m_280168_();
        ArrayList<Insulation> posInsulation = new ArrayList<Insulation>();
        int extraInsulations = 0;
        ArrayList<Insulation> negInsulation = new ArrayList<Insulation>();
        for (InsulatorData data : this.insulation) {
            List<Insulation> insulations;
            List<Insulation> list = insulations = data.fillSlots() ? Insulation.splitList(data.insulation()) : data.insulation();
            if (!data.fillSlots() && data.slot() == Insulation.Slot.ARMOR) {
                extraInsulations += insulations.size();
            }
            for (Insulation ins : insulations) {
                if (ins instanceof StaticInsulation) {
                    StaticInsulation insul = (StaticInsulation)ins;
                    double cold = insul.getCold();
                    double heat = insul.getHeat();
                    if (CSMath.sign(cold) == CSMath.sign(heat)) {
                        switch (CSMath.sign(cold)) {
                            case -1: {
                                negInsulation.add(ins);
                                break;
                            }
                            case 1: {
                                posInsulation.add(ins);
                            }
                        }
                        continue;
                    }
                    switch (CSMath.sign(cold)) {
                        case -1: {
                            negInsulation.add(new StaticInsulation(-cold, 0.0));
                            break;
                        }
                        case 1: {
                            posInsulation.add(new StaticInsulation(cold, 0.0));
                        }
                    }
                    switch (CSMath.sign(heat)) {
                        case -1: {
                            negInsulation.add(new StaticInsulation(0.0, heat));
                            break;
                        }
                        case 1: {
                            posInsulation.add(new StaticInsulation(0.0, heat));
                        }
                    }
                    continue;
                }
                if (!(ins instanceof AdaptiveInsulation)) continue;
                AdaptiveInsulation adaptive = (AdaptiveInsulation)ins;
                double value = adaptive.getInsulation();
                if (value < 0.0) {
                    negInsulation.add(ins);
                    continue;
                }
                posInsulation.add(ins);
            }
        }
        poseStack.m_85836_();
        WIDTH = 0;
        if (!posInsulation.isEmpty() || ConfigSettings.INSULATION_VISIBILITY.get().showsIfEmpty()) {
            BarType barType = negInsulation.isEmpty() ? BarType.NONE : BarType.POSITIVE;
            WIDTH += ClientInsulationTooltip.renderBar(graphics, x + WIDTH, y, posInsulation, extraInsulations, this.slot, this.stack, barType);
        }
        if (!negInsulation.isEmpty()) {
            if (!posInsulation.isEmpty()) {
                WIDTH += 4;
            }
            WIDTH += ClientInsulationTooltip.renderBar(graphics, x + WIDTH, y, negInsulation, 0, this.slot, this.stack, BarType.NEGATIVE);
        }
        poseStack.m_85849_();
        if (this.strikethrough) {
            graphics.m_280509_(x - 1, y + 2, x + 8, y + 3, -642510);
            graphics.m_280509_(x, y + 3, x + 9, y + 4, -642510);
        }
    }

    static void renderCell(GuiGraphics graphics, int x, int y, Insulation insulation) {
        AdaptiveInsulation adaptive;
        double rounded = CSMath.roundNearest(Math.abs(insulation.getValue()), 0.25);
        int uvX = 0;
        if (insulation instanceof AdaptiveInsulation) {
            AdaptiveInsulation adaptive2 = (AdaptiveInsulation)insulation;
            uvX = !RECURSIVE ? 16 : (adaptive2.getFactor() < 0.0 ? 10 : (adaptive2.getFactor() == 0.0 ? 16 : 22));
        } else if (insulation instanceof StaticInsulation) {
            double heat;
            StaticInsulation stat = (StaticInsulation)insulation;
            double cold = Math.abs(stat.getCold());
            int n = cold > (heat = Math.abs(stat.getHeat())) ? 10 : (uvX = cold == heat ? 16 : 22);
        }
        int uvY = insulation instanceof AdaptiveInsulation ? (rounded >= 2.0 ? 16 : 20) : (rounded >= 2.0 ? 8 : 12);
        ClientInsulationTooltip.renderCellBackground(graphics, x, y);
        graphics.m_280398_(TOOLTIP_LOCATION.get(), x, y, 0, (float)uvX, (float)uvY, 6, 4, 36, 28);
        if (insulation instanceof AdaptiveInsulation && (adaptive = (AdaptiveInsulation)insulation).getFactor() != 0.0 && !RECURSIVE) {
            double blend = Math.abs(adaptive.getFactor());
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)blend));
            RECURSIVE = true;
            ClientInsulationTooltip.renderCell(graphics, x, y, insulation);
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RECURSIVE = false;
    }

    static void renderCellBackground(GuiGraphics graphics, int x, int y) {
        graphics.m_280398_(TOOLTIP_LOCATION.get(), x, y, 0, 0.0f, 0.0f, 6, 4, 36, 28);
    }

    static void renderIcon(GuiGraphics graphics, int x, int y, Insulation.Slot slot, BarType type) {
        switch (slot) {
            case ITEM: {
                graphics.m_280398_(TOOLTIP_LOCATION.get(), x, y, 0, 28.0f, 0.0f, 8, 8, 36, 28);
                break;
            }
            case ARMOR: {
                graphics.m_280398_(TOOLTIP_LOCATION.get(), x, y, 0, 28.0f, 8.0f, 8, 8, 36, 28);
                break;
            }
            case CURIO: {
                graphics.m_280398_(TOOLTIP_LOCATION.get(), x, y, 0, 28.0f, 16.0f, 8, 8, 36, 28);
            }
        }
        switch (type) {
            case POSITIVE: {
                graphics.m_280398_(TOOLTIP_LOCATION.get(), x + 3, y + 3, 0, 18.0f, 0.0f, 5, 5, 36, 28);
                break;
            }
            case NEGATIVE: {
                graphics.m_280398_(TOOLTIP_LOCATION.get(), x + 3, y + 3, 0, 23.0f, 0.0f, 5, 5, 36, 28);
            }
        }
    }

    static int renderBar(GuiGraphics graphics, int x, int y, List<Insulation> insulations, int extraSlots, Insulation.Slot slot, ItemStack stack, BarType type) {
        extraSlots = Math.min(ItemInsulationManager.getInsulationSlots(stack), extraSlots);
        PoseStack poseStack = graphics.m_280168_();
        List<Insulation> sortedInsulation = Insulation.sort(insulations);
        ClientInsulationTooltip.setAdaptations(sortedInsulation, stack);
        Mode mode = Screen.m_96637_() || sortedInsulation.stream().map(Insulation::split).mapToInt(List::size).sum() > 10 ? Mode.OVERFLOW : (insulations.stream().anyMatch(insul -> insul.split().size() > 1) ? Mode.COMPOUND : Mode.NORMAL);
        int armorSlots = slot == Insulation.Slot.ARMOR && type != BarType.NEGATIVE && ItemInsulationManager.isInsulatable(stack) ? ItemInsulationManager.getInsulationSlots(stack) : 0;
        int slots = Math.max(armorSlots, insulations.size());
        poseStack.m_85836_();
        int finalWidth = mode == Mode.OVERFLOW ? ClientInsulationTooltip.renderOverflowBar(graphics, x + 8, y, sortedInsulation, slots) : (mode == Mode.COMPOUND ? ClientInsulationTooltip.renderCompoundBar(graphics, x + 7, y, sortedInsulation, extraSlots, slots) : ClientInsulationTooltip.renderNormalBar(graphics, x + 7, y, sortedInsulation, slots + extraSlots));
        poseStack.m_85849_();
        ClientInsulationTooltip.renderIcon(graphics, x, y, slot, type);
        if (mode != Mode.OVERFLOW) {
            finalWidth += 2;
        }
        return finalWidth + 6;
    }

    static int renderNormalBar(GuiGraphics graphics, int x, int y, List<Insulation> insulations, int slots) {
        int i;
        for (i = 0; i < insulations.size(); ++i) {
            Insulation insulation = insulations.get(i);
            ClientInsulationTooltip.renderCell(graphics, x + i * 6, y + 2, insulation);
        }
        for (i = insulations.size(); i < slots; ++i) {
            ClientInsulationTooltip.renderCellBackground(graphics, x + i * 6, y + 2);
        }
        for (i = 0; i < slots; ++i) {
            BorderSegment segment = ClientInsulationTooltip.getBorderSegment(slots, i);
            if (segment == BorderSegment.SINGLE) {
                segment = BorderSegment.TAIL;
            }
            if (segment == BorderSegment.HEAD) {
                segment = BorderSegment.BODY;
            }
            ClientInsulationTooltip.renderCellBorder(graphics, x + i * 6, y + 2, segment, BorderType.NORMAL);
        }
        return Math.max(insulations.size(), slots) * 6;
    }

    static int renderCompoundBar(GuiGraphics graphics, int x, int y, List<Insulation> insulations, int extraSlots, int slots) {
        int cellX = 0;
        int compoundCount = 0;
        for (int i = 0; i < insulations.size(); ++i) {
            Insulation insulation = insulations.get(i);
            List<Insulation> subInsulations = Insulation.sort(insulation.split());
            if (subInsulations.size() > 1) {
                ++compoundCount;
                for (int j = 0; j < subInsulations.size(); ++j) {
                    Insulation subInsul = subInsulations.get(j);
                    BorderSegment segment = ClientInsulationTooltip.getBorderSegment(subInsulations.size(), j);
                    ClientInsulationTooltip.renderCell(graphics, x + cellX, y + 2, subInsul);
                    ClientInsulationTooltip.renderCellBorder(graphics, x + cellX, y + 2, segment, BorderType.COMPOUND);
                    cellX += 6;
                }
                if (i >= slots - 1) continue;
                cellX += 3;
                continue;
            }
            int normalCount = insulations.size() - compoundCount;
            ClientInsulationTooltip.renderCell(graphics, x + cellX, y + 2, insulation);
            BorderSegment segment = ClientInsulationTooltip.getBorderSegment(normalCount, i - compoundCount);
            if (segment == BorderSegment.TAIL && i < slots - 1) {
                segment = BorderSegment.BODY;
            }
            BorderType borderType = segment == BorderSegment.TAIL ? BorderType.NORMAL : BorderType.SEGMENT;
            ClientInsulationTooltip.renderCellBorder(graphics, x + cellX, y + 2, segment, borderType);
            cellX += 6;
            if (i >= slots - 1) continue;
            ClientInsulationTooltip.renderCellBorder(graphics, x + cellX, y + 2, BorderSegment.BODY, BorderType.DIVIDER);
            ++cellX;
        }
        int emptySlots = slots - insulations.size() + extraSlots;
        for (int i = 0; i < emptySlots; ++i) {
            BorderSegment segment = ClientInsulationTooltip.getBorderSegment(emptySlots, i);
            if (segment == BorderSegment.SINGLE) {
                segment = BorderSegment.TAIL;
            }
            BorderType borderType = segment == BorderSegment.TAIL ? BorderType.NORMAL : BorderType.SEGMENT;
            ClientInsulationTooltip.renderCellBackground(graphics, x + cellX, y + 2);
            ClientInsulationTooltip.renderCellBorder(graphics, x + cellX, y + 2, segment, borderType);
            if (emptySlots == 1 && segment == BorderSegment.TAIL) {
                ClientInsulationTooltip.renderCellBorder(graphics, x + cellX - 1, y + 2, BorderSegment.TAIL, BorderType.DIVIDER);
            }
            cellX += 6;
        }
        return cellX;
    }

    static int renderOverflowBar(GuiGraphics graphics, int x, int y, List<Insulation> insulations, int slots) {
        int width = 0;
        PoseStack poseStack = graphics.m_280168_();
        Font font = Minecraft.m_91087_().f_91062_;
        double cold = 0.0;
        double heat = 0.0;
        double neutral = 0.0;
        double adaptive = 0.0;
        for (Insulation insulation : insulations) {
            if (insulation instanceof StaticInsulation) {
                double thisHeat;
                StaticInsulation staticInsulation = (StaticInsulation)insulation;
                double thisCold = Math.abs(staticInsulation.getCold());
                if (thisCold == (thisHeat = Math.abs(staticInsulation.getHeat()))) {
                    neutral += thisCold;
                    continue;
                }
                cold += thisCold;
                heat += thisHeat;
                continue;
            }
            if (!(insulation instanceof AdaptiveInsulation)) continue;
            AdaptiveInsulation adaptiveInsulation = (AdaptiveInsulation)insulation;
            double thisAdaptive = Math.abs(adaptiveInsulation.getInsulation());
            adaptive += thisAdaptive;
        }
        int textColor = 0xA0A0A0;
        poseStack.m_85836_();
        if (insulations.size() < slots) {
            int xOffs = ClientInsulationTooltip.renderEmptyBar(graphics, x, y + 2, slots - insulations.size());
            width += xOffs;
            poseStack.m_252880_((float)xOffs, 0.0f, 0.0f);
        }
        if (cold > 0.0) {
            int xOffs = ClientInsulationTooltip.renderOverflowCell(graphics, font, x + 1, y + 2, new StaticInsulation(cold, 0.0), textColor);
            width += xOffs;
            poseStack.m_252880_((float)xOffs, 0.0f, 0.0f);
        }
        if (heat > 0.0) {
            int xOffs = ClientInsulationTooltip.renderOverflowCell(graphics, font, x + 1, y + 2, new StaticInsulation(0.0, heat), textColor);
            width += xOffs;
            poseStack.m_252880_((float)xOffs, 0.0f, 0.0f);
        }
        if (neutral > 0.0) {
            int xOffs = ClientInsulationTooltip.renderOverflowCell(graphics, font, x + 1, y + 2, new StaticInsulation(neutral, neutral), textColor);
            width += xOffs;
            poseStack.m_252880_((float)xOffs, 0.0f, 0.0f);
        }
        if (adaptive > 0.0) {
            int xOffs = ClientInsulationTooltip.renderOverflowCell(graphics, font, x + 1, y + 2, new AdaptiveInsulation(adaptive, 0.0), textColor);
            width += xOffs;
            poseStack.m_252880_((float)xOffs, 0.0f, 0.0f);
        }
        poseStack.m_85849_();
        return width;
    }

    static int renderOverflowCell(GuiGraphics graphics, Font font, int x, int y, Insulation insulation, int textColor) {
        Number insul = CSMath.truncate(insulation.getValue() / 2.0, 2);
        if (CSMath.isInteger(insul)) {
            insul = ((Number)insul).intValue();
        }
        String text = "x" + insul;
        ClientInsulationTooltip.renderCell(graphics, x, y, insulation);
        ClientInsulationTooltip.renderCellBorder(graphics, x, y, BorderSegment.HEAD, BorderType.OVERFLOW);
        ClientInsulationTooltip.renderCellBorder(graphics, x, y, BorderSegment.BODY, BorderType.OVERFLOW);
        ClientInsulationTooltip.renderCellBorder(graphics, x, y, BorderSegment.TAIL, BorderType.OVERFLOW);
        graphics.m_280488_(font, text, x + 8, y - 2, textColor);
        return 12 + font.m_92895_(text);
    }

    static int renderEmptyBar(GuiGraphics graphics, int x, int y, int size) {
        PoseStack poseStack = graphics.m_280168_();
        for (int i = 0; i < size; ++i) {
            BorderSegment segment = ClientInsulationTooltip.getBorderSegment(size, i);
            graphics.m_280398_(TOOLTIP_LOCATION.get(), x + 7 + i * 6, y + 1, 0, 0.0f, 0.0f, 6, 4, 36, 28);
            ClientInsulationTooltip.renderCellBorder(graphics, x + i * 6, y, segment, BorderType.OVERFLOW);
        }
        poseStack.m_85836_();
        poseStack.m_85849_();
        return size * 6 + 4;
    }

    static void renderCellBorder(GuiGraphics graphics, int x, int y, BorderSegment segment, BorderType type) {
        block0 : switch (type) {
            case DIVIDER: {
                graphics.m_280398_(TOOLTIP_LOCATION.get(), x, y - 1, 0, 10.0f, 0.0f, 1, 6, 36, 28);
                break;
            }
            case EMPTY_DIVIDER: {
                graphics.m_280398_(TOOLTIP_LOCATION.get(), x, y - 1, 0, 11.0f, 0.0f, 1, 6, 36, 28);
                break;
            }
            default: {
                int vOffset = switch (type) {
                    case BorderType.NORMAL -> 4;
                    case BorderType.OVERFLOW -> 10;
                    case BorderType.SEGMENT -> 16;
                    case BorderType.COMPOUND -> 22;
                    default -> 0;
                };
                switch (segment) {
                    case SINGLE: {
                        if (RECURSIVE) break block0;
                        RECURSIVE = true;
                        ClientInsulationTooltip.renderCellBorder(graphics, x, y, BorderSegment.HEAD, type);
                        ClientInsulationTooltip.renderCellBorder(graphics, x, y, BorderSegment.TAIL, type);
                        ClientInsulationTooltip.renderCellBorder(graphics, x, y, BorderSegment.BODY, type);
                        RECURSIVE = false;
                        break block0;
                    }
                    case HEAD: {
                        graphics.m_280398_(TOOLTIP_LOCATION.get(), x - 1, y - 1, 0, 0.0f, (float)vOffset, 7, 6, 36, 28);
                        break block0;
                    }
                    case BODY: {
                        graphics.m_280398_(TOOLTIP_LOCATION.get(), x + 0, y - 1, 0, 2.0f, (float)vOffset, 6, 6, 36, 28);
                        break block0;
                    }
                    case TAIL: {
                        graphics.m_280398_(TOOLTIP_LOCATION.get(), x + 0, y - 1, 0, 3.0f, (float)vOffset, 7, 6, 36, 28);
                    }
                }
            }
        }
    }

    static BorderSegment getBorderSegment(int collectionSize, int index) {
        if (collectionSize == 1) {
            return BorderSegment.SINGLE;
        }
        if (index == collectionSize - 1) {
            return BorderSegment.TAIL;
        }
        if (index == 0) {
            return BorderSegment.HEAD;
        }
        return BorderSegment.BODY;
    }

    static void setAdaptations(List<Insulation> insulations, ItemStack stack) {
        for (int i = 0; i < insulations.size(); ++i) {
            Object insul = insulations.get(i).copy();
            if (insul instanceof AdaptiveInsulation) {
                AdaptiveInsulation adaptive = (AdaptiveInsulation)insul;
                AdaptiveInsulation.readFactorFromArmor(adaptive, stack);
            }
            insulations.set(i, (Insulation)insul);
        }
    }

    private static enum BarType {
        POSITIVE,
        NEGATIVE,
        NONE;

    }

    private static enum Mode {
        NORMAL,
        COMPOUND,
        OVERFLOW;

    }

    private static enum BorderSegment {
        HEAD,
        BODY,
        TAIL,
        SINGLE;

    }

    private static enum BorderType {
        NORMAL,
        OVERFLOW,
        SEGMENT,
        COMPOUND,
        DIVIDER,
        EMPTY_DIVIDER;

    }
}

