/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui.config;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.client.gui.config.ConfigButton;
import com.momosoftworks.coldsweat.client.gui.config.ConfigImage;
import com.momosoftworks.coldsweat.client.gui.config.ConfigLabel;
import com.momosoftworks.coldsweat.client.gui.config.ConfigScreen;
import com.momosoftworks.coldsweat.client.gui.config.ConfigSliderButton;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public abstract class AbstractConfigPage
extends Screen {
    static int MOUSE_STILL_TIMER = 0;
    static int TOOLTIP_DELAY = 5;
    private final Screen parentScreen;
    public Map<String, Pair<List<GuiEventListener>, Boolean>> widgetBatches = new HashMap<String, Pair<List<GuiEventListener>, Boolean>>();
    public Map<String, List<Component>> tooltips = new HashMap<String, List<Component>>();
    protected int rightSideLength = 0;
    protected int leftSideLength = 0;
    private static final int TITLE_HEIGHT = 16;
    private static final int BOTTOM_BUTTON_HEIGHT_OFFSET = 26;
    private static final int BOTTOM_BUTTON_WIDTH = 150;
    public static Minecraft MINECRAFT = Minecraft.m_91087_();
    static ResourceLocation TEXTURE = new ResourceLocation("cold_sweat:textures/gui/screen/config_gui.png");
    ImageButton nextNavButton;
    ImageButton prevNavButton;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        ++MOUSE_STILL_TIMER;
    }

    public void m_94757_(double mouseX, double mouseY) {
        MOUSE_STILL_TIMER = 0;
        super.m_94757_(mouseX, mouseY);
    }

    @SubscribeEvent
    public static void onMouseClicked(ScreenEvent.MouseButtonPressed event) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof AbstractConfigPage) {
            AbstractConfigPage screen2 = (AbstractConfigPage)screen;
            screen2.m_6702_().forEach(child -> {
                AbstractWidget widget;
                if (child instanceof AbstractWidget && !(widget = (AbstractWidget)child).m_5953_(event.getMouseX(), event.getMouseY())) {
                    widget.m_93692_(false);
                }
            });
        }
    }

    public AbstractConfigPage(Screen parentScreen) {
        super((Component)Component.m_237115_((String)"cold_sweat.config.title"));
        this.parentScreen = parentScreen;
    }

    public AbstractConfigPage(Screen parentScreen, Component title) {
        super(title);
        this.parentScreen = parentScreen;
    }

    public abstract Component sectionOneTitle();

    @Nullable
    public abstract Component sectionTwoTitle();

    public boolean showNavigation() {
        return true;
    }

    protected void addEmptySpace(Side side, double height) {
        if (side == Side.LEFT) {
            this.leftSideLength += (int)(25.0 * height);
        } else {
            this.rightSideLength += (int)(25.0 * height);
        }
    }

    protected void addLabel(String id, Side side, Component text) {
        int labelX = side == Side.LEFT ? this.f_96543_ / 2 - 185 : this.f_96543_ / 2 + 51;
        int labelY = this.f_96544_ / 4 - 8 + (side == Side.LEFT ? this.leftSideLength : this.rightSideLength);
        ConfigLabel label = new ConfigLabel(id, text, labelX, labelY);
        this.addWidgetBatch(id, List.of(label), true);
        if (side == Side.LEFT) {
            Objects.requireNonNull(this.f_96547_);
            this.leftSideLength += 9 + 4;
        } else {
            Objects.requireNonNull(this.f_96547_);
            this.rightSideLength += 9 + 4;
        }
    }

    protected void addButton(String id, Side side, Supplier<Component> dynamicLabel, Consumer<Button> onClick, boolean requireOP, final boolean setsCustomDifficulty, boolean clientside, Component ... tooltip) {
        Component label = dynamicLabel.get();
        boolean shouldBeActive = !requireOP || AbstractConfigPage.MINECRAFT.f_91074_ == null || AbstractConfigPage.MINECRAFT.f_91074_.m_20310_(2);
        int widgetX = this.f_96543_ / 2 + (side == Side.LEFT ? -179 : 56);
        int widgetY = this.f_96544_ / 4 - 8 + (side == Side.LEFT ? this.leftSideLength : this.rightSideLength);
        int buttonWidth = 152 + Math.max(0, this.f_96547_.m_92852_((FormattedText)label) - 140);
        ConfigButton button = new ConfigButton(widgetX, widgetY, buttonWidth, 20, label, button1 -> {
            onClick.accept(button1);
            button1.m_93666_((Component)dynamicLabel.get());
        }){

            @Override
            public boolean setsCustomDifficulty() {
                return setsCustomDifficulty;
            }
        };
        button.f_93623_ = shouldBeActive;
        if (clientside) {
            this.createClientsideIcon(id, widgetX - 16, widgetY + 4);
        }
        ArrayList<Component> tooltipList = new ArrayList<Component>(Arrays.asList(tooltip));
        if (clientside) {
            tooltipList.add((Component)Component.m_237115_((String)"cold_sweat.config.clientside_warning").m_130940_(ChatFormatting.DARK_GRAY));
        }
        this.setTooltip(id, tooltipList);
        this.addWidgetBatch(id, List.of(button), shouldBeActive);
        if (side == Side.LEFT) {
            this.leftSideLength += 25;
        } else {
            this.rightSideLength += 25;
        }
    }

    protected void addDecimalInput(String id, Side side, MutableComponent label, final Consumer<Double> onEdited, Consumer<EditBox> onInit, boolean requireOP, final boolean setsCustomDifficulty, boolean clientside, Component ... tooltip) {
        boolean shouldBeActive = !requireOP || AbstractConfigPage.MINECRAFT.f_91074_ == null || AbstractConfigPage.MINECRAFT.f_91074_.m_20310_(2);
        int labelOffset = this.f_96547_.m_92895_(label.getString()) > 90 ? this.f_96547_.m_92895_(label.getString()) - 86 : 0;
        int boxWidth = Math.max(51 - labelOffset, 30);
        int widgetX = this.f_96543_ / 2 + (side == Side.LEFT ? -80 : 155);
        int widgetY = this.f_96544_ / 4 + (side == Side.LEFT ? this.leftSideLength : this.rightSideLength) - 2;
        EditBox textBox = new EditBox(this.f_96547_, widgetX + labelOffset, widgetY - 6, boxWidth, 18, (Component)Component.m_237113_((String)"")){

            public void onEdit() {
                CSMath.tryCatch(() -> {
                    onEdited.accept(Double.parseDouble(this.m_94155_()));
                    if (setsCustomDifficulty) {
                        ConfigSettings.DIFFICULTY.set(ConfigSettings.Difficulty.CUSTOM);
                    }
                });
            }

            public void m_94164_(String text) {
                super.m_94164_(text);
                this.onEdit();
            }

            public void m_94176_(int i) {
                super.m_94176_(i);
                this.onEdit();
            }

            public void m_94180_(int i) {
                super.m_94180_(i);
                this.onEdit();
            }
        };
        textBox.m_94186_(shouldBeActive);
        onInit.accept(textBox);
        textBox.m_94144_(ConfigScreen.TWO_PLACES.format(Double.parseDouble(textBox.m_94155_())));
        ConfigLabel configLabel = new ConfigLabel(id, (Component)label.m_130948_(Style.f_131099_.m_178520_(shouldBeActive ? 0xFFFFFF : 0x808080)), widgetX - 95, widgetY);
        if (clientside) {
            this.createClientsideIcon(id, widgetX - 115, widgetY - 2);
        }
        ArrayList<Component> tooltipList = new ArrayList<Component>(Arrays.asList(tooltip));
        if (clientside) {
            tooltipList.add((Component)Component.m_237115_((String)"cold_sweat.config.clientside_warning").m_130940_(ChatFormatting.DARK_GRAY));
        }
        this.setTooltip(id, tooltipList);
        this.addWidgetBatch(id, List.of(textBox, configLabel), shouldBeActive);
        if (side == Side.LEFT) {
            this.leftSideLength += 25;
        } else {
            this.rightSideLength += 25;
        }
    }

    protected void addDirectionPanel(String id, Side side, MutableComponent label, Consumer<Integer> leftRightPressed, Consumer<Integer> upDownPressed, Runnable reset, Supplier<Boolean> visible, boolean requireOP, boolean setsCustomDifficulty, boolean clientside, boolean canHide, Component ... tooltip) {
        int widgetX = this.f_96543_ / 2 + (side == Side.LEFT ? -97 : 136);
        int widgetY = this.f_96544_ / 4 + (side == Side.LEFT ? this.leftSideLength : this.rightSideLength);
        boolean shouldBeActive = !requireOP || AbstractConfigPage.MINECRAFT.f_91074_ == null || AbstractConfigPage.MINECRAFT.f_91074_.m_20310_(2);
        int labelWidth = this.f_96547_.m_92895_(label.getString());
        int labelOffset = labelWidth > 84 ? labelWidth - 84 : 0;
        ArrayList<GuiEventListener> widgetBatch = new ArrayList<GuiEventListener>();
        ImageButton leftButton = new ImageButton(widgetX + labelOffset, widgetY - 8, 14, 20, 0, 0, 20, TEXTURE, button -> {
            leftRightPressed.accept(-1);
            if (setsCustomDifficulty) {
                ConfigSettings.DIFFICULTY.set(ConfigSettings.Difficulty.CUSTOM);
            }
        });
        leftButton.f_93623_ = shouldBeActive;
        widgetBatch.add((GuiEventListener)leftButton);
        ImageButton upButton = new ImageButton(widgetX + 14 + labelOffset, widgetY - 8, 20, 10, 14, 0, 20, TEXTURE, button -> {
            upDownPressed.accept(-1);
            if (setsCustomDifficulty) {
                ConfigSettings.DIFFICULTY.set(ConfigSettings.Difficulty.CUSTOM);
            }
        });
        upButton.f_93623_ = shouldBeActive;
        widgetBatch.add((GuiEventListener)upButton);
        ImageButton downButton = new ImageButton(widgetX + 14 + labelOffset, widgetY + 2, 20, 10, 14, 10, 20, TEXTURE, button -> {
            upDownPressed.accept(1);
            if (setsCustomDifficulty) {
                ConfigSettings.DIFFICULTY.set(ConfigSettings.Difficulty.CUSTOM);
            }
        });
        downButton.f_93623_ = shouldBeActive;
        widgetBatch.add((GuiEventListener)downButton);
        ImageButton rightButton = new ImageButton(widgetX + 34 + labelOffset, widgetY - 8, 14, 20, 34, 0, 20, TEXTURE, button -> {
            leftRightPressed.accept(1);
            if (setsCustomDifficulty) {
                ConfigSettings.DIFFICULTY.set(ConfigSettings.Difficulty.CUSTOM);
            }
        });
        rightButton.f_93623_ = shouldBeActive;
        widgetBatch.add((GuiEventListener)rightButton);
        ImageButton resetButton = new ImageButton(widgetX + 52 + labelOffset, widgetY - 8, 20, canHide ? 10 : 20, canHide ? 68 : 48, 0, 20, TEXTURE, button -> {
            reset.run();
            if (setsCustomDifficulty) {
                ConfigSettings.DIFFICULTY.set(ConfigSettings.Difficulty.CUSTOM);
            }
        });
        resetButton.f_93623_ = shouldBeActive;
        widgetBatch.add((GuiEventListener)resetButton);
        if (canHide) {
            ImageButton hideButton = new ImageButton(widgetX + 52 + labelOffset, widgetY + 2, 20, 10, 68, 10, 20, TEXTURE, button -> {
                if (setsCustomDifficulty) {
                    ConfigSettings.DIFFICULTY.set(ConfigSettings.Difficulty.CUSTOM);
                }
                AbstractConfigPage.setImageX((ImageButton)button, (Boolean)visible.get());
            });
            visible.get();
            AbstractConfigPage.setImageX(hideButton, visible.get());
            hideButton.f_93623_ = shouldBeActive;
            widgetBatch.add((GuiEventListener)hideButton);
        }
        ConfigLabel configLabel = new ConfigLabel(id, (Component)label.m_130948_(Style.f_131099_.m_178520_(shouldBeActive ? 0xFFFFFF : 0x808080)), widgetX - 79, widgetY);
        if (clientside) {
            this.createClientsideIcon(id, widgetX - 96, widgetY - 8 + 5);
        }
        widgetBatch.add(configLabel);
        ArrayList<Component> tooltipList = new ArrayList<Component>(Arrays.asList(tooltip));
        if (clientside) {
            tooltipList.add((Component)Component.m_237115_((String)"cold_sweat.config.clientside_warning").m_130940_(ChatFormatting.DARK_GRAY));
        }
        this.setTooltip(id, tooltipList);
        this.addWidgetBatch(id, widgetBatch, shouldBeActive);
        if (side == Side.LEFT) {
            this.leftSideLength = (int)((double)this.leftSideLength + 26.25);
        } else {
            this.rightSideLength = (int)((double)this.rightSideLength + 26.25);
        }
    }

    protected void addSliderButton(String id, Side side, final Supplier<Component> dynamicLabel, final double minVal, final double maxVal, final BiConsumer<Double, ConfigSliderButton> onChanged, Consumer<ConfigSliderButton> onInit, boolean requireOP, boolean clientside, Component ... tooltip) {
        Component label = dynamicLabel.get();
        boolean shouldBeActive = !requireOP || this.f_96541_.f_91074_ == null || this.f_96541_.f_91074_.m_20310_(2);
        int widgetX = this.f_96543_ / 2 + (side == Side.LEFT ? -179 : 56);
        int widgetY = this.f_96544_ / 4 - 8 + (side == Side.LEFT ? this.leftSideLength : this.rightSideLength);
        int buttonWidth = 152 + Math.max(0, this.f_96547_.m_92852_((FormattedText)label) - 140);
        ConfigSliderButton sliderButton = new ConfigSliderButton(widgetX, widgetY, buttonWidth, 20, label, 0.0){

            @Override
            protected void m_5695_() {
                this.m_93666_((Component)dynamicLabel.get());
                onChanged.accept(CSMath.blend(minVal, maxVal, CSMath.truncate(this.f_93577_, 2), 0.0, 1.0), this);
            }

            @Override
            protected void m_5697_() {
                this.m_5695_();
            }
        };
        sliderButton.f_93623_ = shouldBeActive;
        onInit.accept(sliderButton);
        if (clientside) {
            this.createClientsideIcon(id, widgetX - 16, widgetY + 4);
        }
        ArrayList<Component> tooltipList = new ArrayList<Component>(Arrays.asList(tooltip));
        if (clientside) {
            tooltipList.add((Component)Component.m_237115_((String)"cold_sweat.config.clientside_warning").m_130940_(ChatFormatting.DARK_GRAY));
        }
        this.setTooltip(id, tooltipList);
        this.addWidgetBatch(id, List.of(sliderButton), shouldBeActive);
        if (side == Side.LEFT) {
            this.leftSideLength += 25;
        } else {
            this.rightSideLength += 25;
        }
    }

    protected void createClientsideIcon(String id, int x, int y) {
        ConfigImage icon = new ConfigImage(TEXTURE, x, y, 12, 12, 0, 144);
        this.m_169394_((Renderable)icon);
        String iconId = String.format("%s_client", id);
        this.setTooltip(iconId, List.of(Component.m_237115_((String)"cold_sweat.config.clientside_warning")));
        this.addWidgetBatch(iconId, List.of(icon), true);
    }

    protected void m_7856_() {
        MOUSE_STILL_TIMER = 0;
        this.m_7897_(false);
        this.leftSideLength = 0;
        this.rightSideLength = 0;
        this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237115_((String)"gui.done"), button -> this.m_7379_()).m_252794_(this.f_96543_ / 2 - 75, this.f_96544_ - 26).m_253046_(150, 20).m_252778_(button -> MutableComponent.m_237204_((ComponentContents)((MutableComponent)button.get()).m_214077_())).m_253136_());
        if (this.showNavigation()) {
            this.nextNavButton = new ImageButton(this.f_96543_ - 32, 12, 20, 20, 0, 88, 20, TEXTURE, button -> MINECRAFT.m_91152_(ConfigScreen.getPage(++ConfigScreen.CURRENT_PAGE, this.parentScreen)));
            if (ConfigScreen.CURRENT_PAGE < ConfigScreen.LAST_PAGE) {
                this.m_142416_((GuiEventListener)this.nextNavButton);
            }
            this.prevNavButton = new ImageButton(this.f_96543_ - 76, 12, 20, 20, 20, 88, 20, TEXTURE, button -> MINECRAFT.m_91152_(ConfigScreen.getPage(--ConfigScreen.CURRENT_PAGE, this.parentScreen)));
            if (ConfigScreen.CURRENT_PAGE > ConfigScreen.FIRST_PAGE) {
                this.m_142416_((GuiEventListener)this.prevNavButton);
            }
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        Font font = this.f_96547_;
        graphics.m_280137_(this.f_96547_, this.f_96539_.getString(), this.f_96543_ / 2, 16, 0xFFFFFF);
        if (this.showNavigation()) {
            graphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)(ConfigScreen.CURRENT_PAGE + 1 + "/" + (ConfigScreen.LAST_PAGE + 1))), this.f_96543_ - 53, 18, 0xFFFFFF, true);
        }
        graphics.m_280614_(this.f_96547_, this.sectionOneTitle(), this.f_96543_ / 2 - 204, this.f_96544_ / 4 - 28, 0xFFFFFF, true);
        graphics.m_280218_(TEXTURE, this.f_96543_ / 2 - 202, this.f_96544_ / 4 - 16, 255, 0, 1, 154);
        if (this.sectionTwoTitle() != null) {
            graphics.m_280614_(this.f_96547_, this.sectionTwoTitle(), this.f_96543_ / 2 + 32, this.f_96544_ / 4 - 28, 0xFFFFFF, true);
            graphics.m_280218_(TEXTURE, this.f_96543_ / 2 + 34, this.f_96544_ / 4 - 16, 255, 0, 1, 154);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.m_7282_()) {
            MOUSE_STILL_TIMER = 0;
        }
        if (MOUSE_STILL_TIMER < TOOLTIP_DELAY) {
            return;
        }
        for (Map.Entry<String, Pair<List<GuiEventListener>, Boolean>> entry : this.widgetBatches.entrySet()) {
            List<Component> tooltipList;
            String id = entry.getKey();
            List widgets = (List)entry.getValue().getFirst();
            boolean enabled = (Boolean)entry.getValue().getSecond();
            int minX = 0;
            int minY = 0;
            int maxX = 0;
            int maxY = 0;
            for (GuiEventListener listener : widgets) {
                if (!(listener instanceof AbstractWidget)) continue;
                AbstractWidget widget = (AbstractWidget)listener;
                if (minX == 0 || widget.m_252754_() < minX) {
                    minX = widget.m_252754_();
                }
                if (minY == 0 || widget.m_252907_() < minY) {
                    minY = widget.m_252907_();
                }
                if (maxX == 0 || widget.m_252754_() + widget.m_5711_() > maxX) {
                    maxX = widget.m_252754_() + widget.m_5711_();
                }
                if (maxY != 0 && widget.m_252907_() + widget.m_93694_() <= maxY) continue;
                maxY = widget.m_252907_() + widget.m_93694_();
            }
            if (!CSMath.betweenInclusive(mouseX, minX, maxX) || !CSMath.betweenInclusive(mouseY, minY, maxY)) continue;
            List<Object> list = tooltipList = enabled ? this.tooltips.get(id) : List.of(Component.m_237115_((String)"cold_sweat.config.require_op").m_130940_(ChatFormatting.RED));
            if (tooltipList == null || tooltipList.isEmpty()) break;
            graphics.m_280677_(font, tooltipList, Optional.empty(), mouseX, mouseY);
            break;
        }
    }

    protected void addWidgetBatch(String id, List<GuiEventListener> elements, boolean enabled) {
        for (GuiEventListener element : elements) {
            if (!(element instanceof Renderable)) continue;
            Renderable widget = (Renderable)element;
            this.m_142416_((GuiEventListener)((NarratableEntry)widget));
        }
        this.widgetBatches.put(id, (Pair<List<GuiEventListener>, Boolean>)Pair.of(elements, (Object)enabled));
    }

    public List<GuiEventListener> getWidgetBatch(String id) {
        return (List)this.widgetBatches.get(id).getFirst();
    }

    protected void setTooltip(String id, List<Component> tooltip) {
        ArrayList<MutableComponent> wrappedTooltip = new ArrayList<MutableComponent>();
        for (Component component : tooltip) {
            List wrappedText = this.f_96547_.m_92865_().m_92414_((FormattedText)component, 300, component.m_7383_());
            wrappedTooltip.addAll(wrappedText.stream().map(text -> Component.m_237113_((String)text.getString()).m_130948_(component.m_7383_())).toList());
        }
        this.tooltips.put(id, wrappedTooltip);
    }

    public static void setImageX(ImageButton button, boolean enabled) {
        Field imageX = ObfuscationReflectionHelper.findField(ImageButton.class, (String)"f_94224_");
        imageX.setAccessible(true);
        try {
            imageX.set(button, enabled ? 68 : 88);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void m_7379_() {
        MINECRAFT.m_91152_(this.parentScreen);
        ConfigScreen.saveConfig();
    }

    public MutableComponent getToggleButtonText(MutableComponent text, boolean on) {
        return text.m_130946_(": ").m_7220_(on ? CommonComponents.f_130653_ : CommonComponents.f_130654_);
    }

    public <T extends Enum<T>> MutableComponent getEnumButtonText(MutableComponent text, T value) {
        return text.m_130946_(": ").m_7220_((Component)Component.m_237115_((String)((StringRepresentable)value).m_7912_()));
    }

    public <T extends Enum<T>> T getNextCycle(T current) {
        Enum[] values = (Enum[])current.getDeclaringClass().getEnumConstants();
        int index = (current.ordinal() + 1) % values.length;
        return (T)values[index];
    }

    public MutableComponent getSliderPercentageText(MutableComponent message, double value, double offAt) {
        return message.m_130946_(": ").m_7220_((Component)(Double.compare(offAt, value) != 0 ? Component.m_237113_((String)((int)(value * 100.0) + "%")) : Component.m_237113_((String)CommonComponents.f_130654_.getString())));
    }

    public MutableComponent getSliderText(MutableComponent message, int value, int min, int max, int offAt) {
        return message.m_130946_(": ").m_7220_((Component)((value > min || value < max) && value != offAt ? Component.m_237113_((String)("" + value)) : Component.m_237113_((String)CommonComponents.f_130654_.getString())));
    }

    public MutableComponent getSliderText(MutableComponent message, double value, double min, double max, double offAt) {
        return message.m_130946_(": ").m_7220_((Component)((value > min || value < max) && Double.compare(value, offAt) != 0 ? Component.m_237113_((String)("" + CSMath.truncate(value, 1))) : Component.m_237113_((String)CommonComponents.f_130654_.getString())));
    }

    public static enum Side {
        LEFT,
        RIGHT;

    }
}

