/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.momosoftworks.coldsweat.api.temperature.modifier.FoodTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.event.TooltipHandler;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.common.capability.temperature.PlayerTempCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Vector2i;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class Overlays {
    public static final ResourceLocation BODY_TEMP_GAUGE = new ResourceLocation("cold_sweat:textures/gui/overlay/body_temp_gauge.png");
    public static final ResourceLocation BODY_TEMP_GAUGE_HC = new ResourceLocation("cold_sweat:textures/gui/overlay/body_temp_gauge_hc.png");
    public static final ResourceLocation WORLD_TEMP_GAUGE = new ResourceLocation("cold_sweat:textures/gui/overlay/world_temp_gauge.png");
    public static final ResourceLocation WORLD_TEMP_GAUGE_HC = new ResourceLocation("cold_sweat:textures/gui/overlay/world_temp_gauge_hc.png");
    public static final ResourceLocation VAGUE_TEMP_GAUGE = new ResourceLocation("cold_sweat:textures/gui/overlay/vague_temp_gauge.png");
    public static final ResourceLocation VAGUE_TEMP_GAUGE_HC = new ResourceLocation("cold_sweat:textures/gui/overlay/vague_temp_gauge_hc.png");
    public static final ResourceLocation VAGUE_TEMP_GAUGE_STANDALONE = new ResourceLocation("cold_sweat:textures/gui/overlay/vague_temp_gauge_standalone.png");
    public static final ResourceLocation VAGUE_TEMP_GAUGE_STANDALONE_HC = new ResourceLocation("cold_sweat:textures/gui/overlay/vague_temp_gauge_standalone_hc.png");
    public static final ResourceLocation FOOD_EFFECT = new ResourceLocation("cold_sweat:textures/gui/overlay/food_effect_background.png");
    public static final Supplier<ResourceLocation> BODY_TEMP_GAUGE_LOCATION = () -> ConfigSettings.HIGH_CONTRAST.get() != false ? BODY_TEMP_GAUGE_HC : BODY_TEMP_GAUGE;
    public static final Supplier<ResourceLocation> WORLD_TEMP_GAUGE_LOCATION = () -> ConfigSettings.HIGH_CONTRAST.get() != false ? WORLD_TEMP_GAUGE_HC : WORLD_TEMP_GAUGE;
    public static final Supplier<ResourceLocation> VAGUE_TEMP_GAUGE_LOCATION = () -> ConfigSettings.BODY_ICON_ENABLED.get().booleanValue() ? (ConfigSettings.HIGH_CONTRAST.get().booleanValue() ? VAGUE_TEMP_GAUGE_HC : VAGUE_TEMP_GAUGE) : (ConfigSettings.HIGH_CONTRAST.get() != false ? VAGUE_TEMP_GAUGE_STANDALONE_HC : VAGUE_TEMP_GAUGE_STANDALONE);
    static boolean ADVANCED_WORLD_TEMP = false;
    public static double WORLD_TEMP = 0.0;
    static double PREV_WORLD_TEMP = 0.0;
    static double PLAYER_MAX_TEMP = 0.0;
    static double PLAYER_MIN_TEMP = 0.0;
    static double BODY_TEMP = 0.0;
    static double PREV_BODY_TEMP = 0.0;
    public static double BLEND_BODY_TEMP = 0.0;
    static int ICON_BOB = 0;
    static int BODY_ICON = 0;
    static int PREV_BODY_ICON = 0;
    static double BODY_TEMP_SEVERITY = 0.0;
    public static IGuiOverlay WORLD_TEMP_OVERLAY = (gui, graphics, partialTick, width, height) -> {
        PoseStack poseStack = graphics.m_280168_();
        Font font = Minecraft.m_91087_().f_91062_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && ADVANCED_WORLD_TEMP && Minecraft.m_91087_().f_91072_.m_105295_() != GameType.SPECTATOR && !Minecraft.m_91087_().f_91066_.f_92062_ && ConfigSettings.WORLD_GAUGE_ENABLED.get().booleanValue()) {
            gui.setupOverlayRenderState(true, false);
            double temp = Temperature.convert(WORLD_TEMP, ConfigSettings.CELSIUS.get() != false ? Temperature.Units.C : Temperature.Units.F, Temperature.Units.MC, true);
            int severity = Overlays.getGaugeSeverity(temp, PLAYER_MIN_TEMP, PLAYER_MAX_TEMP);
            int color = Overlays.getWorldTempColor(temp, PLAYER_MIN_TEMP, PLAYER_MAX_TEMP);
            poseStack.m_85836_();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(GameRenderer::m_172817_);
            graphics.m_280163_(WORLD_TEMP_GAUGE_LOCATION.get(), width / 2 + 93 + ConfigSettings.WORLD_GAUGE_POS.get().x(), height - 19 + ConfigSettings.WORLD_GAUGE_POS.get().y(), 0.0f, (float)(64 - severity * 16), 25, 16, 25, 144);
            RenderSystem.disableBlend();
            int bob = ConfigSettings.ICON_BOBBING.get() != false && !CSMath.betweenInclusive(temp, PLAYER_MIN_TEMP, PLAYER_MAX_TEMP) && player.f_19797_ % 2 == 0 ? 1 : 0;
            int blendedTemp = (int)CSMath.blend(PREV_WORLD_TEMP, WORLD_TEMP, (double)Minecraft.m_91087_().m_91296_(), 0.0, 1.0);
            graphics.m_280056_(font, "" + (blendedTemp + ConfigSettings.TEMP_OFFSET.get()), width / 2 + 106 + Integer.toString(blendedTemp + ConfigSettings.TEMP_OFFSET.get()).length() * -3 + ConfigSettings.WORLD_GAUGE_POS.get().x(), height - 15 - bob + ConfigSettings.WORLD_GAUGE_POS.get().y(), color, false);
            poseStack.m_85849_();
        }
    };
    public static IGuiOverlay BODY_TEMP_OVERLAY = (gui, graphics, partialTick, width, height) -> {
        gui.setupOverlayRenderState(true, false);
        Minecraft mc = Minecraft.m_91087_();
        BLEND_BODY_TEMP = CSMath.blend(PREV_BODY_TEMP, BODY_TEMP, (double)Minecraft.m_91087_().getPartialTick(), 0.0, 1.0);
        double bodyTempInt = CSMath.roundNearest(BLEND_BODY_TEMP, 1.0);
        if (gui.shouldDrawSurvivalElements() && !Minecraft.m_91087_().f_91066_.f_92062_) {
            int color;
            int n = bodyTempInt > 0.0 ? 16744509 : (color = bodyTempInt < 0.0 ? 4233468 : 0xAFAFAF);
            int colorBG = bodyTempInt < 0.0 ? 1122643 : (bodyTempInt > 0.0 ? 5376516 : 0);
            int bobLevel = Math.min(Math.abs((int)BODY_TEMP_SEVERITY), 3);
            int threatOffset = ConfigSettings.ICON_BOBBING.get() == false ? 0 : (bobLevel == 2 ? ICON_BOB : (bobLevel == 3 ? Minecraft.m_91087_().f_91075_.f_19797_ % 2 : 0));
            RenderSystem.defaultBlendFunc();
            if (ConfigSettings.BODY_ICON_ENABLED.get().booleanValue()) {
                int icon = Math.abs(bodyTempInt) < 100.0 ? CSMath.floor(BODY_TEMP_SEVERITY) : 4 * CSMath.sign(BODY_TEMP_SEVERITY);
                int iconX = width / 2 - 5 + ConfigSettings.BODY_ICON_POS.get().x();
                int iconYOffset = ADVANCED_WORLD_TEMP && ConfigSettings.MOVE_BODY_ICON_WHEN_ADVANCED.get() != false ? 54 : 47;
                int iconY = height - iconYOffset - threatOffset + ConfigSettings.BODY_ICON_POS.get().y();
                graphics.m_280163_(BODY_TEMP_GAUGE_LOCATION.get(), iconX, iconY, 0.0f, (float)(40 - icon * 10), 10, 10, 10, 90);
                if (CSMath.betweenExclusive(Math.abs(bodyTempInt), 0.0, 100.0)) {
                    double blend = CSMath.blend(1.0, 9.0, Math.abs(BODY_TEMP_SEVERITY), (double)Math.abs(CSMath.floor(BODY_TEMP_SEVERITY)), (double)Math.abs(CSMath.ceil(BODY_TEMP_SEVERITY)));
                    graphics.m_280163_(BODY_TEMP_GAUGE_LOCATION.get(), iconX, iconY + 10 - CSMath.ceil(blend), 0.0f, (float)(40 - CSMath.grow(icon, bodyTempInt > 0.0 ? 0 : 2) * 10 - CSMath.ceil(blend)), 10, CSMath.ceil(blend), 10, 90);
                }
            }
            if (ConfigSettings.BODY_READOUT_ENABLED.get().booleanValue() && ADVANCED_WORLD_TEMP) {
                Font font = mc.f_91062_;
                int scaledWidth = mc.m_91268_().m_85445_();
                int scaledHeight = mc.m_91268_().m_85446_();
                String s = "" + (int)Math.min(Math.abs(bodyTempInt), 100.0);
                int x = (scaledWidth - font.m_92895_(s)) / 2 + ConfigSettings.BODY_READOUT_POS.get().x();
                int y = scaledHeight - 31 - 10 + ConfigSettings.BODY_READOUT_POS.get().y();
                graphics.m_280056_(font, s, x + 1, y, colorBG, false);
                graphics.m_280056_(font, s, x - 1, y, colorBG, false);
                graphics.m_280056_(font, s, x, y + 1, colorBG, false);
                graphics.m_280056_(font, s, x, y - 1, colorBG, false);
                graphics.m_280056_(font, s, x, y, color, false);
                if (Math.abs(bodyTempInt) > 100.0) {
                    int textHeight = font.m_92920_(s, 100);
                    int overlayHeight = (int)CSMath.roundUpNearest(CSMath.blend(2.0, (double)textHeight, Math.abs(bodyTempInt), 100.0, 150.0), 1.0);
                    int overlayColor = overlayHeight > 3 ? (bodyTempInt > 0.0 ? 0xFFFFAC : 0xB0FFFF) : (bodyTempInt > 0.0 ? 16771975 : 0x84F4FF);
                    int overlayColor2 = bodyTempInt > 0.0 ? 16759634 : 7528447;
                    ClientOnlyHelper.renderVerticalCropText(s, x, y, Math.min(textHeight, overlayHeight + 1), overlayColor2, graphics);
                    ClientOnlyHelper.renderVerticalCropText(s, x, y, overlayHeight, overlayColor, graphics);
                }
            }
        }
    };
    public static IGuiOverlay VAGUE_TEMP_OVERLAY = (gui, graphics, partialTick, width, height) -> {
        PoseStack poseStack = graphics.m_280168_();
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null && !ADVANCED_WORLD_TEMP && mc.f_91072_.m_105295_() != GameType.SPECTATOR && !mc.f_91066_.f_92062_ && ConfigSettings.WORLD_GAUGE_ENABLED.get().booleanValue() && gui.shouldDrawSurvivalElements()) {
            gui.setupOverlayRenderState(true, false);
            double temp = Temperature.convert(WORLD_TEMP, ConfigSettings.CELSIUS.get() != false ? Temperature.Units.C : Temperature.Units.F, Temperature.Units.MC, true);
            int severity = Overlays.getGaugeSeverity(temp, PLAYER_MIN_TEMP, PLAYER_MAX_TEMP);
            int renderOffset = CSMath.clamp(severity, -1, 1) * 2;
            poseStack.m_85836_();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(GameRenderer::m_172817_);
            int bobLevel = Math.min(Math.abs((int)BODY_TEMP_SEVERITY), 3);
            int threatOffset = ConfigSettings.ICON_BOBBING.get() == false ? 0 : (bobLevel == 2 ? ICON_BOB : (bobLevel == 3 ? Minecraft.m_91087_().f_91075_.f_19797_ % 2 : 0));
            graphics.m_280163_(VAGUE_TEMP_GAUGE_LOCATION.get(), width / 2 - 8 + ConfigSettings.BODY_ICON_POS.get().x(), height - 50 + ConfigSettings.BODY_ICON_POS.get().y() - renderOffset - threatOffset, 0.0f, (float)(64 - severity * 16), 16, 16, 16, 144);
            RenderSystem.disableBlend();
            poseStack.m_85849_();
        }
    };
    public static IGuiOverlay FOOD_EFFECTS_OVERLAY = (gui, graphics, partialTick, width, height) -> {
        if (!ConfigSettings.FOOD_EFFECTS_ENABLED.get().booleanValue()) {
            return;
        }
        gui.setupOverlayRenderState(true, false);
        RenderSystem.enableBlend();
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        graphics.m_280168_().m_85836_();
        Vector2i pos = ConfigSettings.FOOD_EFFECTS_POS.get();
        graphics.m_280168_().m_252880_((float)pos.x, (float)pos.y, 0.0f);
        int offset = 0;
        for (Map.Entry<Temperature.Trait, List<TempModifier>> entry : Temperature.getModifiers((LivingEntity)player).entrySet()) {
            Temperature.Trait trait = entry.getKey();
            ArrayList modifierList = new ArrayList(entry.getValue());
            List<FoodTempModifier> sortedModifiers = modifierList.stream().filter(mod -> mod instanceof FoodTempModifier).map(mod -> (FoodTempModifier)mod).sorted((m1, m2) -> {
                int sign2;
                int sign1 = CSMath.sign(m1.getNBT().m_128459_("temperature"));
                if (sign1 != (sign2 = CSMath.sign(m2.getNBT().m_128459_("temperature")))) {
                    return Integer.compare(sign1, sign2);
                }
                return Double.compare(Math.abs(m1.getNBT().m_128459_("temperature")), Math.abs(m2.getNBT().m_128459_("temperature")));
            }).toList();
            for (TempModifier tempModifier : sortedModifiers) {
                if (!(tempModifier instanceof FoodTempModifier)) continue;
                FoodTempModifier food = (FoodTempModifier)tempModifier;
                int x = width - 10;
                int y = height - 10 - offset;
                if (food.getNBT().m_128459_("duration") == 0.0) continue;
                int timeLeft = food.getExpireTime() - food.getTicksExisted();
                double temp = food.getNBT().m_128459_("temperature");
                boolean overridden = food.isOverridden(trait);
                graphics.m_280163_(FOOD_EFFECT, x - 76, y - 24, 0.0f, 0.0f, 76, 24, 76, 24);
                String sign = temp > 0.0 ? "\u2191" : "\u2193";
                Object tempString = CSMath.formatDoubleOrInt(CSMath.round(temp, 2));
                if (temp < 0.0) {
                    tempString = ((String)tempString).substring(1);
                }
                tempString = sign + (String)tempString;
                String timerString = StringUtil.m_14404_((int)timeLeft);
                int contentWidth = mc.f_91062_.m_92895_((String)tempString) + mc.f_91062_.m_92895_(timerString) + 20;
                int contentHeight = 16;
                x -= 76;
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_((float)(38 - contentWidth / 2), (float)(12 - contentHeight / 2), 0.0f);
                float brightness = overridden ? 0.35f : 1.0f;
                RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
                if (timeLeft < 200) {
                    float alpha = (float)CSMath.blend(1.0, Math.sin((double)((float)food.getTicksExisted() + partialTick) / 1.5) / 2.0 + 0.5, (double)timeLeft, 200.0, 0.0);
                    RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)alpha);
                }
                Font font = mc.f_91062_;
                Objects.requireNonNull(mc.f_91062_);
                graphics.m_280056_(font, timerString, x, y - 9 - 11, ChatFormatting.WHITE.m_126665_().intValue(), true);
                RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(food.getNBT().m_128461_("item")));
                graphics.m_280480_(item.m_7968_(), x += mc.f_91062_.m_92895_(timerString) + 2, y - 24);
                x += 18;
                Style style = temp > 0.0 ? TooltipHandler.HOT : (temp < 0.0 ? TooltipHandler.COLD : Style.f_131099_);
                MutableComponent tempText = Component.m_237113_((String)tempString).m_130948_(style);
                Font font2 = mc.f_91062_;
                Objects.requireNonNull(mc.f_91062_);
                graphics.m_280614_(font2, (Component)tempText, x, y - 9 - 11, tempText.m_7383_().m_131135_().m_131265_(), true);
                offset += 25;
                graphics.m_280168_().m_85849_();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        graphics.m_280168_().m_85849_();
    };

    @SubscribeEvent
    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerBelow(VanillaGuiOverlay.HOTBAR.id(), "world_temp", WORLD_TEMP_OVERLAY);
        event.registerBelow(VanillaGuiOverlay.HOTBAR.id(), "body_temp", BODY_TEMP_OVERLAY);
        event.registerBelow(VanillaGuiOverlay.HOTBAR.id(), "vague_temp", VAGUE_TEMP_OVERLAY);
        event.registerBelow(VanillaGuiOverlay.HOTBAR.id(), "food_effects", FOOD_EFFECTS_OVERLAY);
    }

    public static double getWorldSeverity(double temp, double playerMin, double playerMax) {
        double normalMax;
        if (temp < playerMin) {
            return -1.0;
        }
        if (temp > playerMax) {
            return 1.0;
        }
        double normalMin = ConfigSettings.Difficulty.NORMAL.getSetting(ConfigSettings.MIN_TEMP);
        double mid = Overlays.calculateMidpoint(playerMin, playerMax, normalMin, normalMax = ConfigSettings.Difficulty.NORMAL.getSetting(ConfigSettings.MAX_TEMP).doubleValue());
        return temp < mid ? CSMath.blend(-1.0, 0.0, temp, playerMin, mid) : CSMath.blend(0.0, 1.0, temp, mid, playerMax);
    }

    private static double calculateMidpoint(double playerMin, double playerMax, double normalMin, double normalMax) {
        boolean bothBelowNormal = playerMin < normalMin && playerMax < normalMax;
        boolean bothAboveNormal = playerMin > normalMin && playerMax > normalMax;
        return bothBelowNormal || bothAboveNormal ? (playerMin + playerMax) / 2.0 : (normalMin + normalMax) / 2.0;
    }

    public static int getGaugeSeverity(double temp, double playerMin, double playerMax) {
        return (int)(Overlays.getWorldSeverity(temp, playerMin, playerMax) * 4.0);
    }

    static double getBodySeverity(int temp) {
        int sign = CSMath.sign(temp);
        int absTemp = Math.abs(temp);
        return absTemp < 100 ? CSMath.blend(0.0, 3.0, (double)absTemp, 0.0, 100.0) * (double)sign : CSMath.blend(3.0, 7.0, (double)absTemp, 100.0, 150.0) * (double)sign;
    }

    public static void setBodyTempInstant(double temp) {
        BODY_TEMP = temp;
        PREV_BODY_TEMP = temp;
        BLEND_BODY_TEMP = (int)temp;
    }

    public static void setWorldTempInstant(double temp) {
        WORLD_TEMP = temp;
        PREV_WORLD_TEMP = temp;
    }

    public static int getWorldTempColor(double temp, double playerMin, double playerMax) {
        int severity = Overlays.getGaugeSeverity(temp, playerMin, playerMax);
        return switch (severity) {
            case 2, 3 -> 16297781;
            case 4 -> 16728089;
            case -3, -2 -> 8443135;
            case -4 -> 4236031;
            default -> 14737376;
        };
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static final class TickOverlays {
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (event.phase == TickEvent.Phase.START && player != null && player.m_6084_()) {
                EntityTempManager.getTemperatureCap((Entity)player).ifPresent(arg_0 -> TickOverlays.lambda$onClientTick$0((Player)player, arg_0));
            }
        }

        private static /* synthetic */ void lambda$onClientTick$0(Player player, ITemperatureCap icap) {
            if (!(icap instanceof PlayerTempCap)) {
                return;
            }
            PlayerTempCap cap = (PlayerTempCap)icap;
            cap.calculateHudVisibility(player);
            ADVANCED_WORLD_TEMP = cap.showAdvancedWorldTemp();
            boolean celsius = ConfigSettings.CELSIUS.get();
            double worldTemp = cap.getTrait(Temperature.Trait.WORLD);
            double realTemp = Temperature.convert(worldTemp, Temperature.Units.MC, celsius ? Temperature.Units.C : Temperature.Units.F, true);
            double diff = realTemp - WORLD_TEMP;
            PREV_WORLD_TEMP = WORLD_TEMP;
            WORLD_TEMP += Math.abs(diff) <= 1.0 ? diff : CSMath.maxAbs(diff / ConfigSettings.TEMP_SMOOTHING.get(), 0.25 * (double)CSMath.sign(diff));
            PLAYER_MAX_TEMP = cap.getTrait(Temperature.Trait.BURNING_POINT);
            PLAYER_MIN_TEMP = cap.getTrait(Temperature.Trait.FREEZING_POINT);
            PREV_BODY_TEMP = BODY_TEMP;
            BODY_TEMP += (cap.getTrait(Temperature.Trait.BODY) - BODY_TEMP) / 2.0;
            ICON_BOB = player.f_19797_ % 3 == 0 && Math.random() < 0.3 ? 1 : 0;
            BODY_TEMP_SEVERITY = Overlays.getBodySeverity((int)BLEND_BODY_TEMP);
            int neededIcon = (int)CSMath.clamp(BODY_TEMP_SEVERITY, -4.0, 4.0);
            if (BODY_ICON != neededIcon) {
                BODY_ICON = neededIcon;
            }
        }
    }
}

