/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu.util.mod.neoforge;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Dimension;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.ModContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeoforgeIconHandler
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Mod Menu | NeoforgeIconHandler");
    private final Map<Path, Tuple<DynamicTexture, Dimension>> modIconCache = new HashMap<Path, Tuple<DynamicTexture, Dimension>>();
    public static final Map<String, Tuple<DynamicTexture, Dimension>> modResourceIconCache = new HashMap<String, Tuple<DynamicTexture, Dimension>>();

    public Tuple<DynamicTexture, Dimension> createIcon(ModContainer iconSource, String iconPath) {
        Tuple tuple;
        block12: {
            Path path = iconSource.getModInfo().getOwningFile().getFile().findResource(new String[]{iconPath});
            Tuple<DynamicTexture, Dimension> cachedIcon = this.getCachedModIcon(path);
            if (cachedIcon != null) {
                return cachedIcon;
            }
            cachedIcon = this.getCachedModIcon(path);
            if (cachedIcon != null) {
                return cachedIcon;
            }
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            try {
                NativeImage image = NativeImage.m_85058_((InputStream)Objects.requireNonNull(inputStream));
                Tuple tex = new Tuple((Object)new DynamicTexture(image), (Object)new Dimension(image.m_84982_(), image.m_85084_()));
                this.cacheModIcon(path, (Tuple<DynamicTexture, Dimension>)tex);
                tuple = tex;
                if (inputStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalStateException e) {
                    return null;
                }
                catch (Throwable t) {
                    if (!(iconPath.equals("assets/" + iconSource.getModId() + "/icon.png") || iconPath.equals("icon.png") || iconPath.contains("_small.png"))) {
                        LOGGER.error("Invalid mod icon for icon source {}: {}", (Object)iconSource.getModId(), (Object)iconPath);
                    }
                    return null;
                }
            }
            inputStream.close();
        }
        return tuple;
    }

    @Override
    public void close() {
        for (Tuple<DynamicTexture, Dimension> tex : this.modIconCache.values()) {
            ((DynamicTexture)tex.m_14418_()).close();
        }
    }

    Tuple<DynamicTexture, Dimension> getCachedModIcon(Path path) {
        return this.modIconCache.get(path);
    }

    void cacheModIcon(Path path, Tuple<DynamicTexture, Dimension> tex) {
        this.modIconCache.put(path, tex);
    }
}

