/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu.util.mod.neoforge;

import com.terraformersmc.mod_menu.ModMenu;
import com.terraformersmc.mod_menu.util.mod.Mod;
import com.terraformersmc.mod_menu.util.mod.ModBadge;
import com.terraformersmc.mod_menu.util.mod.neoforge.NeoforgeIconHandler;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeoforgeDummyParentMod
implements Mod {
    private final String id;
    private final Mod host;
    private boolean childHasUpdate;
    private final Set<String> badgeNames = new LinkedHashSet<String>();
    private final Set<ModBadge> badges = new LinkedHashSet<ModBadge>();

    public NeoforgeDummyParentMod(Mod host, String id) {
        this.host = host;
        this.id = id;
        Mod.ModMenuData.DummyParentData parentData = host.getModMenuData().getDummyParentData();
        if (parentData != null) {
            this.badgeNames.addAll(parentData.getBadges());
        }
        if (id.equals("fabric-api")) {
            this.badgeNames.add("library");
        }
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getName() {
        Mod.ModMenuData.DummyParentData parentData = this.host.getModMenuData().getDummyParentData();
        if (parentData != null) {
            return parentData.getName().orElse("");
        }
        if (this.id.equals("fabric-api")) {
            return "Fabric API";
        }
        return this.id;
    }

    @Override
    @NotNull
    public Tuple<DynamicTexture, Dimension> getIcon(NeoforgeIconHandler iconHandler, int i, boolean isSmall) {
        String iconSourceId = this.host.getId();
        String iconResourceId = this.id + (isSmall ? "_small" : "");
        if (NeoforgeIconHandler.modResourceIconCache.containsKey(iconResourceId)) {
            return NeoforgeIconHandler.modResourceIconCache.get(iconResourceId);
        }
        Mod.ModMenuData.DummyParentData parentData = this.host.getModMenuData().getDummyParentData();
        String iconPath = null;
        if (parentData != null) {
            iconPath = parentData.getIcon().orElse(null);
        }
        if ("inherit".equals(iconPath)) {
            return this.host.getIcon(iconHandler, i, isSmall);
        }
        if (iconPath == null) {
            iconSourceId = "mod_menu";
            iconPath = this.id.equals("fabric-api") ? "assets/mod_menu/fabric.png" : "assets/mod_menu/unknown_parent.png";
        }
        String finalIconSourceId = iconSourceId;
        ModContainer iconSource = (ModContainer)ModList.get().getModContainerById(iconSourceId).orElseThrow(() -> new RuntimeException("Cannot get ModContainer for Fabric mod with id " + finalIconSourceId));
        return Objects.requireNonNull(iconHandler.createIcon(iconSource, iconPath), "Mod icon for " + this.getId() + " is null somehow (should be filled with default in this case)");
    }

    @Override
    @NotNull
    public String getDescription() {
        Mod.ModMenuData.DummyParentData parentData = this.host.getModMenuData().getDummyParentData();
        if (parentData != null) {
            return parentData.getDescription().orElse("");
        }
        return "";
    }

    @Override
    @NotNull
    public String getVersion() {
        return "";
    }

    @Override
    @NotNull
    public String getPrefixedVersion() {
        return "";
    }

    @Override
    @NotNull
    public List<String> getAuthors() {
        return new ArrayList<String>();
    }

    @Override
    @NotNull
    public Map<String, Collection<String>> getContributors() {
        return Map.of();
    }

    @Override
    @NotNull
    public SortedMap<String, Set<String>> getCredits() {
        return new TreeMap<String, Set<String>>();
    }

    @Override
    @NotNull
    public Set<ModBadge> getBadges() {
        return this.badges;
    }

    @Override
    @NotNull
    public Set<String> getBadgeNames() {
        return this.badgeNames;
    }

    @Override
    @Nullable
    public String getWebsite() {
        return null;
    }

    @Override
    @Nullable
    public String getIssueTracker() {
        return null;
    }

    @Override
    @Nullable
    public String getSource() {
        return null;
    }

    @Override
    @Nullable
    public String getParent() {
        return null;
    }

    @Override
    @NotNull
    public Set<String> getLicense() {
        return new HashSet<String>();
    }

    @Override
    @NotNull
    public Map<String, String> getLinks() {
        return new HashMap<String, String>();
    }

    @Override
    public boolean isReal() {
        return false;
    }

    @Override
    public boolean getChildHasUpdate() {
        return this.childHasUpdate;
    }

    @Override
    public void setChildHasUpdate() {
        this.childHasUpdate = true;
    }

    @Override
    public boolean isHidden() {
        return ((List)ModMenu.getConfig().HIDDEN_MODS.get()).contains(this.getId());
    }

    @Override
    public Mod.ModMenuData getModMenuData() {
        return this.host.getModMenuData();
    }

    @Override
    public Optional<ModContainer> getContainer() {
        return Optional.empty();
    }
}

