/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.terraformersmc.mod_menu.ModMenu;
import com.terraformersmc.mod_menu.util.mod.Mod;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DrawingUtil {
    private static final Minecraft CLIENT = Minecraft.m_91087_();

    public static void drawRandomVersionBackground(Mod mod, GuiGraphics guiGraphics, int x, int y, int width, int height) {
        int seed = mod.getName().hashCode() + mod.getVersion().hashCode();
        Random random = new Random(seed);
        int color = 0xFF000000 | Mth.m_14169_((float)random.nextFloat(1.0f), (float)random.nextFloat(0.7f, 0.8f), (float)0.9f);
        if (!((Boolean)ModMenu.getConfig().RANDOM_JAVA_COLORS.get()).booleanValue()) {
            color = -2271658;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280509_(x, y, x + width, y + height, color);
    }

    public static void drawWrappedString(GuiGraphics guiGraphics, String string, int x, int y, int wrapWidth, int lines, int color) {
        while (string != null && string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        List strings = DrawingUtil.CLIENT.f_91062_.m_92865_().m_92414_((FormattedText)Component.m_237113_((String)string), wrapWidth, Style.f_131099_);
        for (int i = 0; i < strings.size() && i < lines; ++i) {
            FormattedText renderable = (FormattedText)strings.get(i);
            if (i == lines - 1 && strings.size() > lines) {
                renderable = FormattedText.m_130773_((FormattedText[])new FormattedText[]{(FormattedText)strings.get(i), FormattedText.m_130775_((String)"...")});
            }
            FormattedCharSequence line = Language.m_128107_().m_5536_(renderable);
            int x1 = x;
            if (DrawingUtil.CLIENT.f_91062_.m_92718_()) {
                int width = DrawingUtil.CLIENT.f_91062_.m_92724_(line);
                x1 = (int)((float)x1 + (float)(wrapWidth - width));
            }
            Font font = DrawingUtil.CLIENT.f_91062_;
            Objects.requireNonNull(DrawingUtil.CLIENT.f_91062_);
            guiGraphics.m_280649_(font, line, x1, y + i * 9, color, true);
        }
    }

    public static void drawBadge(GuiGraphics guiGraphics, int x, int y, int tagWidth, FormattedCharSequence charSequence, int outlineColor, int fillColor, int textColor) {
        guiGraphics.m_280509_(x + 1, y - 1, x + tagWidth, y, outlineColor);
        Objects.requireNonNull(DrawingUtil.CLIENT.f_91062_);
        guiGraphics.m_280509_(x, y, x + 1, y + 9, outlineColor);
        Objects.requireNonNull(DrawingUtil.CLIENT.f_91062_);
        Objects.requireNonNull(DrawingUtil.CLIENT.f_91062_);
        guiGraphics.m_280509_(x + 1, y + 1 + 9 - 1, x + tagWidth, y + 9 + 1, outlineColor);
        Objects.requireNonNull(DrawingUtil.CLIENT.f_91062_);
        guiGraphics.m_280509_(x + tagWidth, y, x + tagWidth + 1, y + 9, outlineColor);
        Objects.requireNonNull(DrawingUtil.CLIENT.f_91062_);
        guiGraphics.m_280509_(x + 1, y, x + tagWidth, y + 9, fillColor);
        guiGraphics.m_280649_(DrawingUtil.CLIENT.f_91062_, charSequence, (int)((float)(x + 1) + (float)(tagWidth - DrawingUtil.CLIENT.f_91062_.m_92724_(charSequence)) / 2.0f), y + 1, textColor, false);
    }
}

