/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu.gui.widget.entries;

import com.mojang.blaze3d.systems.RenderSystem;
import com.terraformersmc.mod_menu.ModMenu;
import com.terraformersmc.mod_menu.gui.widget.ModListWidget;
import com.terraformersmc.mod_menu.gui.widget.entries.ChildEntry;
import com.terraformersmc.mod_menu.gui.widget.entries.ModListEntry;
import com.terraformersmc.mod_menu.gui.widget.entries.ParentEntry;
import com.terraformersmc.mod_menu.util.mod.Mod;
import com.terraformersmc.mod_menu.util.mod.ModBadge;
import com.terraformersmc.mod_menu.util.mod.ModSearch;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ChildParentEntry
extends ChildEntry {
    private static final ResourceLocation PARENT_MOD_TEXTURE = new ResourceLocation("mod_menu", "textures/gui/parent_mod.png");
    protected List<Mod> children;
    protected ModListWidget list;
    protected boolean hoveringIcon = false;

    public ChildParentEntry(Mod mod, ParentEntry parent, List<ModListEntry> parents, List<Mod> children, ModListWidget list, boolean bottomChild) {
        super(mod, parent, parents, list, bottomChild);
        this.children = children;
        this.list = list;
        this.parent = parent;
        this.bottomChild = bottomChild;
    }

    @Override
    public void m_6311_(GuiGraphics guiGraphics, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        super.m_6311_(guiGraphics, index, y, x, rowWidth, rowHeight, mouseX, mouseY, isSelected, delta);
        x += this.getXOffset();
        Font font = this.client.f_91062_;
        Objects.requireNonNull(font);
        int childrenBadgeHeight = 9;
        Objects.requireNonNull(font);
        int childrenBadgeWidth = 9;
        int shownChildren = ModSearch.search(this.list.getParent(), this.list.getParent().getSearchInput(), this.getChildren()).size();
        int allChildren = this.children.stream().filter(child -> !child.isHidden() && ((Boolean)ModMenu.getConfig().SHOW_LIBRARIES.get() != false || !child.getBadges().contains(ModBadge.LIBRARY))).toList().size();
        MutableComponent str = shownChildren == allChildren ? Component.m_237113_((String)String.valueOf(shownChildren)) : Component.m_237113_((String)(shownChildren + "/" + allChildren));
        int childrenWidth = font.m_92852_((FormattedText)str) - 1;
        if (childrenBadgeWidth < childrenWidth + 4) {
            childrenBadgeWidth = childrenWidth + 4;
        }
        int iconSize = (Boolean)ModMenu.getConfig().COMPACT_LIST.get() != false ? 19 : 32;
        int childrenBadgeX = x + iconSize - childrenBadgeWidth;
        int childrenBadgeY = y + iconSize - childrenBadgeHeight;
        int childrenOutlineColor = -15698860;
        int childrenFillColor = -16172759;
        guiGraphics.m_280509_(childrenBadgeX + 1, childrenBadgeY, childrenBadgeX + childrenBadgeWidth - 1, childrenBadgeY + 1, childrenOutlineColor);
        guiGraphics.m_280509_(childrenBadgeX, childrenBadgeY + 1, childrenBadgeX + 1, childrenBadgeY + childrenBadgeHeight - 1, childrenOutlineColor);
        guiGraphics.m_280509_(childrenBadgeX + childrenBadgeWidth - 1, childrenBadgeY + 1, childrenBadgeX + childrenBadgeWidth, childrenBadgeY + childrenBadgeHeight - 1, childrenOutlineColor);
        guiGraphics.m_280509_(childrenBadgeX + 1, childrenBadgeY + 1, childrenBadgeX + childrenBadgeWidth - 1, childrenBadgeY + childrenBadgeHeight - 1, childrenFillColor);
        guiGraphics.m_280509_(childrenBadgeX + 1, childrenBadgeY + childrenBadgeHeight - 1, childrenBadgeX + childrenBadgeWidth - 1, childrenBadgeY + childrenBadgeHeight, childrenOutlineColor);
        guiGraphics.m_280649_(font, str.m_7532_(), (int)((float)childrenBadgeX + (float)childrenBadgeWidth / 2.0f - (float)childrenWidth / 2.0f), childrenBadgeY + 1, 0xCACACA, false);
        boolean bl = this.hoveringIcon = mouseX >= x - 1 && mouseX <= x - 1 + iconSize && mouseY >= y - 1 && mouseY <= y - 1 + iconSize;
        if (this.m_5953_(mouseX, mouseY)) {
            guiGraphics.m_280509_(x, y, x + iconSize, y + iconSize, -1601138544);
            int xOffset = this.list.getParent().showModChildren.contains(this.getMod().getId()) ? iconSize : 0;
            int yOffset = this.hoveringIcon ? iconSize : 0;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280163_(PARENT_MOD_TEXTURE, x, y, (float)xOffset, (float)yOffset, iconSize + xOffset, iconSize + yOffset, (Boolean)ModMenu.getConfig().COMPACT_LIST.get() != false ? 152 : 256, (Boolean)ModMenu.getConfig().COMPACT_LIST.get() != false ? 152 : 256);
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int i) {
        int iconSize = (Boolean)ModMenu.getConfig().COMPACT_LIST.get() != false ? 19 : 32;
        boolean quickConfigure = (Boolean)ModMenu.getConfig().QUICK_CONFIGURE.get();
        if (mouseX - (double)this.list.m_5747_() <= (double)(iconSize + this.getXOffset())) {
            this.toggleChildren();
            return true;
        }
        if (!quickConfigure && Util.m_137550_() - this.sinceLastClick < 250L) {
            this.toggleChildren();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, i);
    }

    private void toggleChildren() {
        String id = this.getMod().getId();
        if (this.list.getParent().showModChildren.contains(id)) {
            this.list.getParent().showModChildren.remove(id);
        } else {
            this.list.getParent().showModChildren.add(id);
        }
        this.list.filter(this.list.getParent().getSearchInput(), false);
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        String modId = this.getMod().getId();
        if (keyCode == 257 || keyCode == 32) {
            if (this.list.getParent().showModChildren.contains(modId)) {
                this.list.getParent().showModChildren.remove(modId);
            } else {
                this.list.getParent().showModChildren.add(modId);
            }
            this.list.filter(this.list.getParent().getSearchInput(), false);
            return true;
        }
        if (keyCode == 263) {
            if (this.list.getParent().showModChildren.contains(modId)) {
                this.list.getParent().showModChildren.remove(modId);
                this.list.filter(this.list.getParent().getSearchInput(), false);
            }
            return true;
        }
        if (keyCode == 262) {
            if (this.list.getParent().showModChildren.contains(modId)) {
                return this.list.m_7933_(264, 0, 0);
            }
            this.list.getParent().showModChildren.add(modId);
            this.list.filter(this.list.getParent().getSearchInput(), false);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void setChildren(List<Mod> children) {
        this.children = children;
    }

    public void addChildren(List<Mod> children) {
        this.children.addAll(children);
    }

    public void addChildren(Mod ... children) {
        this.children.addAll(Arrays.asList(children));
    }

    public List<Mod> getChildren() {
        return this.children;
    }

    public boolean m_5953_(double double_1, double double_2) {
        return Objects.equals((Object)this.list.getEntryAtPos(double_1, double_2), (Object)this);
    }
}

