/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.terraformersmc.mod_menu.ModMenu;
import com.terraformersmc.mod_menu.config.ModMenuConfig;
import com.terraformersmc.mod_menu.gui.ModsScreen;
import com.terraformersmc.mod_menu.gui.widget.entries.ChildEntry;
import com.terraformersmc.mod_menu.gui.widget.entries.ChildParentEntry;
import com.terraformersmc.mod_menu.gui.widget.entries.IndependentEntry;
import com.terraformersmc.mod_menu.gui.widget.entries.ModListEntry;
import com.terraformersmc.mod_menu.gui.widget.entries.ParentEntry;
import com.terraformersmc.mod_menu.util.mod.Mod;
import com.terraformersmc.mod_menu.util.mod.ModBadge;
import com.terraformersmc.mod_menu.util.mod.ModSearch;
import com.terraformersmc.mod_menu.util.mod.neoforge.NeoforgeIconHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class ModListWidget
extends ObjectSelectionList<ModListEntry>
implements AutoCloseable {
    public static final boolean DEBUG = Boolean.getBoolean("mod_menu.debug");
    private final ModsScreen parent;
    private List<Mod> mods = null;
    private final Set<Mod> addedMods = new HashSet<Mod>();
    private String selectedModId = null;
    private boolean scrolling;
    private final NeoforgeIconHandler iconHandler = new NeoforgeIconHandler();
    private Double restoreScrollY = null;

    public ModListWidget(Minecraft client, int width, int height, int y1, int y2, int entryHeight, String searchTerm, ModListWidget list, ModsScreen parent) {
        super(client, width, height, y1, y2, entryHeight);
        this.parent = parent;
        if (list != null) {
            this.mods = list.mods;
            this.restoreScrollY = list.m_93517_();
        }
    }

    public void m_93410_(double amount) {
        super.m_93410_(amount);
        int denominator = Math.max(0, this.m_5775_() - (this.getBottom() - this.getTop() - 4));
        if (denominator <= 0) {
            this.parent.updateScrollPercent(0.0);
        } else {
            this.parent.updateScrollPercent(this.m_93517_() / (double)Math.max(0, this.m_5775_() - (this.getBottom() - this.getTop() - 4)));
        }
    }

    public boolean m_93696_() {
        return this.parent.m_7222_() == this;
    }

    public void select(ModListEntry entry) {
        this.setSelected(entry);
        if (entry != null) {
            Mod mod = entry.getMod();
            this.f_93386_.m_240477_().m_93319_(Component.m_237110_((String)"narrator.select", (Object[])new Object[]{mod.getTranslatedName()}).getString());
        }
    }

    public void setSelected(ModListEntry entry) {
        super.m_6987_((AbstractSelectionList.Entry)entry);
        this.selectedModId = entry.getMod().getId();
        this.parent.updateSelectedEntry((ModListEntry)this.m_93511_());
    }

    protected boolean m_7987_(int index) {
        ModListEntry selected = (ModListEntry)this.m_93511_();
        return selected != null && selected.getMod().getId().equals(this.getEntry(index).getMod().getId());
    }

    public int addEntry(ModListEntry entry) {
        if (this.addedMods.contains(entry.mod)) {
            return 0;
        }
        this.addedMods.add(entry.mod);
        int i = super.m_7085_((AbstractSelectionList.Entry)entry);
        if (entry.getMod().getId().equals(this.selectedModId)) {
            this.setSelected(entry);
        }
        return i;
    }

    protected boolean removeEntry(ModListEntry entry) {
        this.addedMods.remove(entry.mod);
        return super.m_93502_((AbstractSelectionList.Entry)entry);
    }

    protected ModListEntry remove(int index) {
        this.addedMods.remove(this.getEntry((int)index).mod);
        return (ModListEntry)super.m_93514_(index);
    }

    public void finalizeInit() {
        this.reloadFilters();
        if (this.restoreScrollY != null) {
            this.m_93410_(this.restoreScrollY);
            this.restoreScrollY = null;
        }
    }

    public void reloadFilters() {
        this.filter(this.parent.getSearchInput(), true, false);
    }

    public void filter(String searchTerm, boolean refresh) {
        this.filter(searchTerm, refresh, true);
    }

    private boolean hasVisibleChildMods(Mod parent) {
        List children = ModMenu.PARENT_MAP.get((Object)parent);
        boolean hideLibraries = (Boolean)ModMenu.getConfig().SHOW_LIBRARIES.get() == false;
        return !children.stream().allMatch(child -> child.isHidden() || hideLibraries && child.getBadges().contains(ModBadge.LIBRARY));
    }

    private void filter(String searchTerm, boolean refresh, boolean search) {
        this.m_93516_();
        this.addedMods.clear();
        ArrayList mods = (ArrayList)((Object)ModMenu.MODS.values().stream().filter(mod -> {
            if (((Boolean)ModMenu.getConfig().CONFIG_MODE.get()).booleanValue()) {
                return !this.parent.getModHasConfigScreen(mod.getContainer());
            }
            return !mod.isHidden();
        }).collect(Collectors.toSet()));
        if (DEBUG) {
            mods = new ArrayList(mods);
        }
        if (this.mods == null || refresh) {
            this.mods = new ArrayList<Mod>();
            this.mods.addAll(mods);
            this.mods.sort(((ModMenuConfig.Sorting)((Object)ModMenu.getConfig().SORTING.get())).getComparator());
        }
        List<Mod> matched = ModSearch.search(this.parent, searchTerm, this.mods);
        for (Mod mod2 : matched) {
            String modId = mod2.getId();
            if (mod2.getBadges().contains(ModBadge.LIBRARY) && !((Boolean)ModMenu.getConfig().SHOW_LIBRARIES.get()).booleanValue() || ModMenu.PARENT_MAP.values().contains(mod2)) continue;
            if (ModMenu.PARENT_MAP.keySet().contains(mod2) && this.hasVisibleChildMods(mod2)) {
                List children = ModMenu.PARENT_MAP.get((Object)mod2);
                children.sort(((ModMenuConfig.Sorting)((Object)ModMenu.getConfig().SORTING.get())).getComparator());
                ParentEntry parent = new ParentEntry(mod2, children, this);
                this.addEntry(parent);
                if (!this.parent.showModChildren.contains(modId)) continue;
                List<Mod> validChildren = ModSearch.search(this.parent, searchTerm, children);
                for (Mod child : validChildren) {
                    this.addChildMod(child, validChildren, parent, List.of(parent), searchTerm, 1);
                }
                continue;
            }
            this.addEntry(new IndependentEntry(mod2, this));
        }
        if (this.parent.getSelectedEntry() != null && !this.m_6702_().isEmpty() || this.m_93511_() != null && ((ModListEntry)this.m_93511_()).getMod() != this.parent.getSelectedEntry().getMod()) {
            for (ModListEntry entry : this.m_6702_()) {
                if (!entry.getMod().equals(this.parent.getSelectedEntry().getMod())) continue;
                this.setSelected(entry);
            }
        } else if (this.m_93511_() == null && !this.m_6702_().isEmpty() && this.getEntry(0) != null) {
            this.setSelected(this.getEntry(0));
        }
        if (this.m_93517_() > (double)Math.max(0, this.m_5775_() - (this.getBottom() - this.getTop() - 4))) {
            this.m_93410_(Math.max(0, this.m_5775_() - (this.getBottom() - this.getTop() - 4)));
        }
    }

    public void addChildMod(Mod child, List<Mod> validChildren, ParentEntry parent, List<ModListEntry> parents, String searchTerm, int parentCount) {
        if (ModMenu.PARENT_MAP.keySet().contains(child) && this.hasVisibleChildMods(child)) {
            List childChildren = ModMenu.PARENT_MAP.get((Object)child);
            childChildren.sort(((ModMenuConfig.Sorting)((Object)ModMenu.getConfig().SORTING.get())).getComparator());
            ChildParentEntry childParentEntry = new ChildParentEntry(child, parent, parents, childChildren, this, validChildren.indexOf(child) == validChildren.size() - 1);
            this.addEntry(childParentEntry);
            if (this.parent.showModChildren.contains(child.getId())) {
                List<Mod> validChildChildren = ModSearch.search(this.parent, searchTerm, childChildren);
                for (Mod childChild : validChildChildren) {
                    ArrayList<ModListEntry> childParents = new ArrayList<ModListEntry>(parents);
                    childParents.add(childParentEntry);
                    this.addChildMod(childChild, validChildChildren, parent, childParents, searchTerm, parentCount + 1);
                }
            }
        } else {
            this.addEntry(new ChildEntry(child, parent, parents, this, validChildren.indexOf(child) == validChildren.size() - 1));
        }
    }

    protected void m_239227_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        int entryCount = this.m_5773_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        for (int index = 0; index < entryCount; ++index) {
            int entryLeft;
            int entryTop = this.m_7610_(index) + 2;
            int entryBottom = this.m_7610_(index) + this.f_93387_;
            if (entryBottom < this.getTop() || entryTop > this.getBottom()) continue;
            int entryHeight = this.f_93387_ - 4;
            ModListEntry entry = this.getEntry(index);
            int rowWidth = this.m_5759_();
            if (this.m_7987_(index)) {
                entryLeft = this.m_5747_() - 2 + entry.getXOffset();
                int selectionRight = this.m_5747_() + rowWidth + 2;
                float float_2 = this.m_93696_() ? 1.0f : 0.5f;
                RenderSystem.setShader(GameRenderer::m_172808_);
                RenderSystem.setShaderColor((float)float_2, (float)float_2, (float)float_2, (float)1.0f);
                Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
                buffer.m_252986_(matrix, (float)entryLeft, (float)(entryTop + entryHeight + 2), 0.0f).m_5752_();
                buffer.m_252986_(matrix, (float)selectionRight, (float)(entryTop + entryHeight + 2), 0.0f).m_5752_();
                buffer.m_252986_(matrix, (float)selectionRight, (float)(entryTop - 2), 0.0f).m_5752_();
                buffer.m_252986_(matrix, (float)entryLeft, (float)(entryTop - 2), 0.0f).m_5752_();
                tessellator.m_85914_();
                RenderSystem.setShader(GameRenderer::m_172808_);
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
                buffer.m_252986_(matrix, (float)(entryLeft + 1), (float)(entryTop + entryHeight + 1), 0.0f).m_5752_();
                buffer.m_252986_(matrix, (float)(selectionRight - 1), (float)(entryTop + entryHeight + 1), 0.0f).m_5752_();
                buffer.m_252986_(matrix, (float)(selectionRight - 1), (float)(entryTop - 1), 0.0f).m_5752_();
                buffer.m_252986_(matrix, (float)(entryLeft + 1), (float)(entryTop - 1), 0.0f).m_5752_();
                tessellator.m_85914_();
            }
            entryLeft = this.m_5747_();
            entry.m_6311_(guiGraphics, index, entryTop, entryLeft, rowWidth, entryHeight, mouseX, mouseY, this.m_5953_(mouseX, mouseY) && Objects.equals((Object)this.getEntryAtPos(mouseX, mouseY), (Object)entry), delta);
        }
    }

    public void ensureVisible(ModListEntry entry) {
        super.m_93498_((AbstractSelectionList.Entry)entry);
    }

    protected void m_93481_(double double_1, double double_2, int int_1) {
        super.m_93481_(double_1, double_2, int_1);
        this.scrolling = int_1 == 0 && double_1 >= (double)this.m_5756_() && double_1 < (double)(this.m_5756_() + 6);
    }

    public boolean m_6375_(double double_1, double double_2, int int_1) {
        this.m_93481_(double_1, double_2, int_1);
        if (!this.m_5953_(double_1, double_2)) {
            return false;
        }
        ModListEntry entry = this.getEntryAtPos(double_1, double_2);
        if (entry != null) {
            if (entry.m_6375_(double_1, double_2, int_1)) {
                this.m_7522_((GuiEventListener)entry);
                this.m_7897_(true);
                return true;
            }
        } else if (int_1 == 0) {
            this.m_6205_((int)(double_1 - (double)(this.getLeft() + this.f_93388_ / 2 - this.m_5759_() / 2)), (int)(double_2 - (double)this.getTop()) + (int)this.m_93517_() - 4);
            return true;
        }
        return this.scrolling;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265 || keyCode == 264) {
            return super.m_7933_(keyCode, scanCode, modifiers);
        }
        if (this.m_93511_() != null) {
            return ((ModListEntry)this.m_93511_()).m_7933_(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public final ModListEntry getEntryAtPos(double x, double y) {
        int int_5 = Mth.m_14107_((double)(y - (double)this.getTop())) - this.f_93395_ + (int)this.m_93517_() - 4;
        int index = int_5 / this.f_93387_;
        return x < (double)this.m_5756_() && x >= (double)this.m_5747_() && x <= (double)(this.m_5747_() + this.m_5759_()) && index >= 0 && int_5 >= 0 && index < this.m_5773_() ? (ModListEntry)((Object)this.m_6702_().get(index)) : null;
    }

    protected int m_5756_() {
        return this.f_93388_ - 6;
    }

    public int m_5759_() {
        return this.f_93388_ - (Math.max(0, this.m_5775_() - (this.getBottom() - this.getTop() - 4)) > 0 ? 18 : 12);
    }

    public int m_5747_() {
        return this.getLeft() + 6;
    }

    public int getWidth() {
        return this.f_93388_;
    }

    public ModsScreen getParent() {
        return this.parent;
    }

    protected int m_5775_() {
        return super.m_5775_() + 4;
    }

    public int getDisplayedCountFor(Set<String> set) {
        int count = 0;
        for (ModListEntry c : this.m_6702_()) {
            if (!set.contains(c.getMod().getId())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void close() {
        this.iconHandler.close();
    }

    public NeoforgeIconHandler getNeoforgeIconHandler() {
        return this.iconHandler;
    }

    public int m_93485_(int index) {
        return super.m_93485_(index);
    }

    public ModListEntry getEntry(int index) {
        return (ModListEntry)super.m_93500_(index);
    }
}

