/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.terraformersmc.mod_menu.ModMenu;
import com.terraformersmc.mod_menu.gui.ModsScreen;
import com.terraformersmc.mod_menu.gui.widget.UpdateAvailableBadge;
import com.terraformersmc.mod_menu.util.mod.Mod;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.CreditsAndAttributionScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class DescriptionListWidget
extends AbstractSelectionList<DescriptionEntry> {
    private static final Component HAS_UPDATE_TEXT = Component.m_237115_((String)"mod_menu.hasUpdate");
    private static final Component EXPERIMENTAL_TEXT = Component.m_237115_((String)"mod_menu.experimental").m_130940_(ChatFormatting.GOLD);
    private static final Component MODRINTH_TEXT = Component.m_237115_((String)"mod_menu.modrinth");
    private static final Component CHILD_HAS_UPDATE_TEXT = Component.m_237115_((String)"mod_menu.childHasUpdate");
    private static final Component LINKS_TEXT = Component.m_237115_((String)"mod_menu.links");
    private static final Component SOURCE_TEXT = Component.m_237115_((String)"mod_menu.source").m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.UNDERLINE);
    private static final Component LICENSE_TEXT = Component.m_237115_((String)"mod_menu.license");
    private static final Component VIEW_CREDITS_TEXT = Component.m_237115_((String)"mod_menu.viewCredits").m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.UNDERLINE);
    private static final Component CREDITS_TEXT = Component.m_237115_((String)"mod_menu.credits");
    private final ModsScreen parent;
    private final Font textRenderer;
    private Mod selectedMod = null;

    public DescriptionListWidget(Minecraft client, int width, int height, int top, int bottom, int entryHeight, DescriptionListWidget copyFrom, ModsScreen parent) {
        super(client, width, height, top, bottom, entryHeight);
        this.parent = parent;
        this.textRenderer = client.f_91062_;
        if (copyFrom != null) {
            this.updateSelectedModIfRequired(copyFrom.selectedMod);
            this.m_93410_(copyFrom.m_93517_());
        }
        if (parent.getSelectedEntry() != null) {
            this.updateSelectedModIfRequired(parent.getSelectedEntry().getMod());
        }
    }

    public DescriptionEntry getSelected() {
        return null;
    }

    public int m_5759_() {
        return this.f_93388_ - 10;
    }

    protected int m_5756_() {
        return this.f_93388_ - 6 + this.getLeft();
    }

    public void m_142291_(NarrationElementOutput builder) {
        if (this.selectedMod != null) {
            builder.m_169143_(NarratedElementType.TITLE, this.selectedMod.getTranslatedName() + " " + this.selectedMod.getPrefixedVersion());
        }
    }

    private void rebuildUI() {
        block17: {
            SortedMap<String, Set<String>> credits;
            Mod mod;
            int wrapWidth;
            DescriptionEntry emptyEntry;
            block18: {
                if (this.selectedMod == null) {
                    return;
                }
                emptyEntry = new DescriptionEntry(FormattedCharSequence.f_13691_);
                wrapWidth = this.m_5759_() - 5;
                mod = this.selectedMod;
                Component description = mod.getFormattedDescription();
                if (!description.getString().isEmpty()) {
                    for (FormattedCharSequence line : this.textRenderer.m_92923_((FormattedText)description, wrapWidth)) {
                        this.m_6702_().add(new DescriptionEntry(line));
                    }
                }
                Map<String, String> links = mod.getLinks();
                String sourceLink = mod.getSource();
                if (!(links.isEmpty() && sourceLink == null || ((Boolean)ModMenu.getConfig().HIDE_MOD_LINKS.get()).booleanValue())) {
                    this.m_6702_().add(emptyEntry);
                    for (Object line : this.textRenderer.m_92923_((FormattedText)LINKS_TEXT, wrapWidth)) {
                        this.m_6702_().add(new DescriptionEntry((FormattedCharSequence)line));
                    }
                    if (sourceLink != null) {
                        int indent = 8;
                        for (Object line : this.textRenderer.m_92923_((FormattedText)SOURCE_TEXT, wrapWidth - 16)) {
                            this.m_6702_().add(new LinkEntry((FormattedCharSequence)line, sourceLink, indent));
                            indent = 16;
                        }
                    }
                    links.forEach((key, value) -> {
                        int indent = 8;
                        for (FormattedCharSequence line : this.textRenderer.m_92923_((FormattedText)Component.m_237115_((String)key).m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.UNDERLINE), wrapWidth - 16)) {
                            this.m_6702_().add(new LinkEntry(line, (String)value, indent));
                            indent = 16;
                        }
                    });
                }
                Set<String> licenses = mod.getLicense();
                if (!((Boolean)ModMenu.getConfig().HIDE_MOD_LICENSE.get()).booleanValue() && !licenses.isEmpty()) {
                    this.m_6702_().add(emptyEntry);
                    for (Object line : this.textRenderer.m_92923_((FormattedText)LICENSE_TEXT, wrapWidth)) {
                        this.m_6702_().add(new DescriptionEntry((FormattedCharSequence)line));
                    }
                    for (String license : licenses) {
                        int indent = 8;
                        for (FormattedCharSequence line : this.textRenderer.m_92923_((FormattedText)Component.m_237113_((String)license), wrapWidth - 16)) {
                            this.m_6702_().add(new DescriptionEntry(line, indent));
                            indent = 16;
                        }
                    }
                }
                if (((Boolean)ModMenu.getConfig().HIDE_MOD_CREDITS.get()).booleanValue()) break block17;
                if (!"minecraft".equals(mod.getId())) break block18;
                this.m_6702_().add(emptyEntry);
                for (Object line : this.textRenderer.m_92923_((FormattedText)VIEW_CREDITS_TEXT, wrapWidth)) {
                    this.m_6702_().add(new MojangCreditsEntry((FormattedCharSequence)line));
                }
                break block17;
            }
            if ("java".equals(mod.getId()) || (credits = mod.getCredits()).isEmpty()) break block17;
            this.m_6702_().add(emptyEntry);
            for (FormattedCharSequence line : this.textRenderer.m_92923_((FormattedText)CREDITS_TEXT, wrapWidth)) {
                this.m_6702_().add(new DescriptionEntry(line));
            }
            Iterator<Map.Entry<String, Set<String>>> iterator = credits.entrySet().iterator();
            while (iterator.hasNext()) {
                int indent = 8;
                Map.Entry<String, Set<String>> role = iterator.next();
                String roleName = role.getKey();
                for (FormattedCharSequence line : this.textRenderer.m_92923_((FormattedText)this.creditsRoleText(roleName), wrapWidth - 16)) {
                    this.m_6702_().add(new DescriptionEntry(line, indent));
                    indent = 16;
                }
                for (String contributor : role.getValue()) {
                    indent = 16;
                    for (FormattedCharSequence line : this.textRenderer.m_92923_((FormattedText)Component.m_237113_((String)contributor), wrapWidth - 24)) {
                        this.m_6702_().add(new DescriptionEntry(line, indent));
                        indent = 24;
                    }
                }
                if (!iterator.hasNext()) continue;
                this.m_6702_().add(emptyEntry);
            }
        }
    }

    public void updateSelectedModIfRequired(Mod mod) {
        if (mod != this.selectedMod) {
            this.selectedMod = mod;
            this.m_93516_();
            this.m_93410_(-1.7976931348623157E308);
            this.rebuildUI();
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Screen.f_279548_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferBuilder.m_5483_((double)this.getLeft(), (double)this.getBottom(), 0.0).m_7421_((float)this.getLeft() / 32.0f, (float)(this.getBottom() + (int)this.m_93517_()) / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
        bufferBuilder.m_5483_((double)this.getRight(), (double)this.getBottom(), 0.0).m_7421_((float)this.getRight() / 32.0f, (float)(this.getBottom() + (int)this.m_93517_()) / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
        bufferBuilder.m_5483_((double)this.getRight(), (double)this.getTop(), 0.0).m_7421_((float)this.getRight() / 32.0f, (float)(this.getTop() + (int)this.m_93517_()) / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
        bufferBuilder.m_5483_((double)this.getLeft(), (double)this.getTop(), 0.0).m_7421_((float)this.getLeft() / 32.0f, (float)(this.getTop() + (int)this.m_93517_()) / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
        tessellator.m_85914_();
        this.m_280310_(guiGraphics);
        this.m_239227_(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.m_280618_();
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_5483_((double)this.getLeft(), (double)(this.getTop() + 4), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferBuilder.m_5483_((double)this.getRight(), (double)(this.getTop() + 4), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferBuilder.m_5483_((double)this.getRight(), (double)this.getTop(), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferBuilder.m_5483_((double)this.getLeft(), (double)this.getTop(), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferBuilder.m_5483_((double)this.getLeft(), (double)this.getBottom(), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferBuilder.m_5483_((double)this.getRight(), (double)this.getBottom(), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferBuilder.m_5483_((double)this.getRight(), (double)(this.getBottom() - 4), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferBuilder.m_5483_((double)this.getLeft(), (double)(this.getBottom() - 4), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        tessellator.m_85914_();
        this.renderScrollBar(bufferBuilder, tessellator);
        RenderSystem.disableBlend();
    }

    private Component creditsRoleText(String roleName) {
        String translationKey = roleName.replaceAll("[ -]", "_").toLowerCase();
        Object fallback = roleName.endsWith("r") ? roleName + "s" : roleName;
        return Component.m_264568_((String)("mod_menu.credits.role." + translationKey), (String)fallback).m_7220_((Component)Component.m_237113_((String)":"));
    }

    public void renderScrollBar(BufferBuilder bufferBuilder, Tesselator tessellator) {
        int scrollbarStartX = this.m_5756_();
        int scrollbarEndX = scrollbarStartX + 6;
        int maxScroll = this.m_93518_();
        if (maxScroll > 0) {
            int p = (int)((float)((this.getBottom() - this.getTop()) * (this.getBottom() - this.getTop())) / (float)this.m_5775_());
            p = Mth.m_14045_((int)p, (int)32, (int)(this.getBottom() - this.getTop() - 8));
            int q = (int)this.m_93517_() * (this.getBottom() - this.getTop() - p) / maxScroll + this.getTop();
            if (q < this.getTop()) {
                q = this.getTop();
            }
            RenderSystem.setShader(GameRenderer::m_172811_);
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            bufferBuilder.m_5483_((double)scrollbarStartX, (double)this.getBottom(), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferBuilder.m_5483_((double)scrollbarEndX, (double)this.getBottom(), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferBuilder.m_5483_((double)scrollbarEndX, (double)this.getTop(), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferBuilder.m_5483_((double)scrollbarStartX, (double)this.getTop(), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferBuilder.m_5483_((double)scrollbarStartX, (double)(q + p), 0.0).m_6122_(128, 128, 128, 255).m_5752_();
            bufferBuilder.m_5483_((double)scrollbarEndX, (double)(q + p), 0.0).m_6122_(128, 128, 128, 255).m_5752_();
            bufferBuilder.m_5483_((double)scrollbarEndX, (double)q, 0.0).m_6122_(128, 128, 128, 255).m_5752_();
            bufferBuilder.m_5483_((double)scrollbarStartX, (double)q, 0.0).m_6122_(128, 128, 128, 255).m_5752_();
            bufferBuilder.m_5483_((double)scrollbarStartX, (double)(q + p - 1), 0.0).m_6122_(192, 192, 192, 255).m_5752_();
            bufferBuilder.m_5483_((double)(scrollbarEndX - 1), (double)(q + p - 1), 0.0).m_6122_(192, 192, 192, 255).m_5752_();
            bufferBuilder.m_5483_((double)(scrollbarEndX - 1), (double)q, 0.0).m_6122_(192, 192, 192, 255).m_5752_();
            bufferBuilder.m_5483_((double)scrollbarStartX, (double)q, 0.0).m_6122_(192, 192, 192, 255).m_5752_();
            tessellator.m_85914_();
        }
    }

    protected class DescriptionEntry
    extends ContainerObjectSelectionList.Entry<DescriptionEntry> {
        protected FormattedCharSequence text;
        protected int indent;
        public boolean updateTextEntry = false;

        public DescriptionEntry(FormattedCharSequence text, int indent) {
            this.text = text;
            this.indent = indent;
        }

        public DescriptionEntry(FormattedCharSequence text) {
            this(text, 0);
        }

        public DescriptionEntry setUpdateTextEntry() {
            this.updateTextEntry = true;
            return this;
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int y, int x, int itemWidth, int itemHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            if (this.updateTextEntry) {
                UpdateAvailableBadge.renderBadge(guiGraphics, x + this.indent, y);
                x += 11;
            }
            guiGraphics.m_280648_(DescriptionListWidget.this.textRenderer, this.text, x + this.indent, y, 0xAAAAAA);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> m_142437_() {
            return Collections.emptyList();
        }
    }

    protected class LinkEntry
    extends DescriptionEntry {
        private final String link;

        public LinkEntry(FormattedCharSequence text, String link, int indent) {
            super(text, indent);
            this.link = link;
        }

        public LinkEntry(FormattedCharSequence text, String link) {
            this(text, link, 0);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.m_5953_(mouseX, mouseY)) {
                DescriptionListWidget.this.f_93386_.m_91152_((Screen)new ConfirmLinkScreen(open -> {
                    if (open) {
                        Util.m_137581_().m_137646_(this.link);
                    }
                    DescriptionListWidget.this.f_93386_.m_91152_((Screen)DescriptionListWidget.this.parent);
                }, this.link, false));
            }
            return super.m_6375_(mouseX, mouseY, button);
        }
    }

    protected class MojangCreditsEntry
    extends DescriptionEntry {
        public MojangCreditsEntry(FormattedCharSequence text) {
            super(text);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.m_5953_(mouseX, mouseY)) {
                DescriptionListWidget.this.f_93386_.m_91152_((Screen)new MinecraftCredits());
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        class MinecraftCredits
        extends CreditsAndAttributionScreen {
            public MinecraftCredits() {
                super((Screen)DescriptionListWidget.this.parent);
            }
        }
    }
}

