/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu.gui.widget;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class BadgeToogleButton
extends ImageButton {
    private static final ResourceLocation BADGE_TOGGLE_TEXTURE = new ResourceLocation("mod_menu", "textures/gui/badge_toggle_button.png");
    private boolean hasBadge;

    public BadgeToogleButton(int x, int y, int width, int height, int u, int v, int hoveredVOffset, Button.OnPress pressAction, Component message, boolean hasBadge) {
        super(x, y, width, height, u, v, hoveredVOffset, BADGE_TOGGLE_TEXTURE, 22, 22, pressAction, message);
        this.hasBadge = hasBadge;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        int v = this.f_94225_;
        int u = this.f_94224_;
        if (!this.m_142518_()) {
            v += this.f_94226_ * 2;
        } else if (this.m_274382_()) {
            v += this.f_94226_;
        }
        if (this.hasBadge) {
            u += 11;
        }
        guiGraphics.m_280163_(this.f_94223_, this.m_252754_(), this.m_252907_(), (float)u, (float)v, this.f_93618_, this.f_93619_, this.f_94227_, this.f_94228_);
    }

    public void toggle() {
        this.hasBadge = !this.hasBadge;
    }

    public static Builder badgeButtonBuilder(Component message, Button.OnPress onPress, boolean hasBadge) {
        return new Builder(message, onPress, hasBadge);
    }

    public static class Builder {
        private final Component message;
        private final Button.OnPress onPress;
        private int x;
        private int y;
        private boolean hasBadge;
        private int width;
        private int height;
        private int u;
        private int v;
        private int hoveredVOffset;

        public Builder(Component message, Button.OnPress onPress, boolean hasBadge) {
            this.message = message;
            this.onPress = onPress;
            this.hasBadge = hasBadge;
        }

        public Builder position(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder uv(int u, int v, int hoveredVOffset) {
            this.u = u;
            this.v = v;
            this.hoveredVOffset = hoveredVOffset;
            return this;
        }

        public BadgeToogleButton build() {
            return new BadgeToogleButton(this.x, this.y, this.width, this.height, this.u, this.v, this.hoveredVOffset, this.onPress, this.message, this.hasBadge);
        }
    }
}

