/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu.gui;

import com.google.common.base.Joiner;
import com.mojang.blaze3d.systems.RenderSystem;
import com.terraformersmc.mod_menu.ModMenu;
import com.terraformersmc.mod_menu.config.ModMenuConfig;
import com.terraformersmc.mod_menu.gui.BadgeScreen;
import com.terraformersmc.mod_menu.gui.widget.DescriptionListWidget;
import com.terraformersmc.mod_menu.gui.widget.ModListWidget;
import com.terraformersmc.mod_menu.gui.widget.entries.ModListEntry;
import com.terraformersmc.mod_menu.util.DrawingUtil;
import com.terraformersmc.mod_menu.util.ModMenuScreenTexts;
import com.terraformersmc.mod_menu.util.TranslationUtil;
import com.terraformersmc.mod_menu.util.mod.Mod;
import com.terraformersmc.mod_menu.util.mod.ModBadge;
import com.terraformersmc.mod_menu.util.mod.ModBadgeRenderer;
import java.awt.Dimension;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModsScreen
extends Screen {
    private static final ResourceLocation FILTERS_BUTTON_LOCATION = new ResourceLocation("mod_menu", "textures/gui/filters_button.png");
    private static final ResourceLocation CONFIGURE_BUTTON_LOCATION = new ResourceLocation("mod_menu", "textures/gui/configure_button.png");
    public static final ResourceLocation BADGE_BUTTON_LOCATION = new ResourceLocation("mod_menu", "textures/gui/badge_button.png");
    private static final Component TOGGLE_FILTER_OPTIONS = Component.m_237115_((String)"mod_menu.toggleFilterOptions");
    private static final Component CONFIGURE = Component.m_237115_((String)"mod_menu.configure");
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Mod Menu | ModsScreen");
    private EditBox searchBox;
    private DescriptionListWidget descriptionListWidget;
    private final Screen previousScreen;
    private ModListWidget modList;
    private ModListEntry selected;
    private ModBadgeRenderer modBadgeRenderer;
    private double scrollPercent = 0.0;
    private boolean init = false;
    private boolean filterOptionsShown = false;
    private int paneY;
    protected static final int RIGHT_PANE_Y = 48;
    private int paneWidth;
    private int rightPaneX;
    private int searchBoxX;
    private int filtersX;
    private int filtersWidth;
    private int searchRowWidth;
    public final Set<String> showModChildren = new HashSet<String>();
    public final Map<ModContainer, Boolean> modHasConfigScreen = new HashMap<ModContainer, Boolean>();
    public final Map<String, Throwable> modScreenErrors = new HashMap<String, Throwable>();

    public ModsScreen(Screen previousScreen) {
        super((Component)Component.m_237115_((String)"mod_menu.title"));
        this.previousScreen = previousScreen;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.modList.m_5953_(mouseX, mouseY)) {
            return this.modList.m_6050_(mouseX, mouseY, amount);
        }
        if (this.descriptionListWidget.m_5953_(mouseX, mouseY)) {
            return this.descriptionListWidget.m_6050_(mouseX, mouseY, amount);
        }
        return false;
    }

    public void m_86600_() {
        this.searchBox.m_94120_();
    }

    protected void m_7856_() {
        int rightPaneY;
        int paneY;
        boolean hideTop = (Boolean)ModMenu.getConfig().HIDE_SCREEN_TOP.get();
        if (hideTop) {
            paneY = 30;
            rightPaneY = 5;
        } else {
            paneY = (Boolean)ModMenu.getConfig().CONFIG_MODE.get() != false ? 48 : 67;
            rightPaneY = 48;
        }
        this.paneWidth = this.f_96543_ / 2 - 8;
        this.rightPaneX = this.f_96543_ - this.paneWidth;
        int filtersButtonSize = (Boolean)ModMenu.getConfig().CONFIG_MODE.get() != false ? 0 : 22;
        int searchWidthMax = this.paneWidth - 32 - filtersButtonSize;
        int searchBoxWidth = (Boolean)ModMenu.getConfig().CONFIG_MODE.get() != false ? Math.min(200, searchWidthMax) : searchWidthMax;
        this.searchBoxX = this.paneWidth / 2 - searchBoxWidth / 2 - filtersButtonSize / 2;
        this.searchBox = new EditBox(this.f_96547_, this.searchBoxX, 22, searchBoxWidth, 20, this.searchBox, (Component)Component.m_237115_((String)"mod_menu.search"));
        if (((Boolean)ModMenu.getConfig().HIDE_SCREEN_TOP.get()).booleanValue()) {
            this.searchBox.f_93624_ = false;
            this.searchBox.f_93623_ = false;
        }
        this.searchBox.m_94151_(string_1 -> this.modList.filter((String)string_1, false));
        this.modList = new ModListWidget(this.f_96541_, this.paneWidth, this.f_96544_, paneY, this.f_96544_ - 36, (Boolean)ModMenu.getConfig().COMPACT_LIST.get() != false ? 23 : 36, this.searchBox.m_94155_(), this.modList, this);
        this.modList.m_93507_(0);
        Objects.requireNonNull(this.f_96547_);
        this.descriptionListWidget = new DescriptionListWidget(this.f_96541_, this.paneWidth, this.f_96544_, rightPaneY + 60, this.f_96544_ - 36, 9 + 1, this.descriptionListWidget, this);
        this.descriptionListWidget.m_93507_(this.rightPaneX);
        ImageButton configureButton = new ImageButton(this.f_96543_ - 24, rightPaneY, 20, 20, 0, 0, 20, CONFIGURE_BUTTON_LOCATION, 32, 64, button -> {
            Mod mod = Objects.requireNonNull(this.selected).getMod();
            if (this.getModHasConfigScreen(mod.getContainer())) {
                this.safelyOpenConfigScreen(mod.getContainer().get());
            } else {
                button.f_93623_ = false;
            }
        }){

            public void m_88315_(GuiGraphics DrawContext, int mouseX, int mouseY, float delta) {
                String modId = ModsScreen.this.selected.getMod().getId();
                if (ModsScreen.this.selected != null) {
                    this.f_93623_ = ModsScreen.this.getModHasConfigScreen(ModsScreen.this.selected.getMod().getContainer());
                } else {
                    this.f_93623_ = false;
                    this.f_93624_ = false;
                }
                boolean bl = this.f_93624_ = ModsScreen.this.selected != null && ModsScreen.this.getModHasConfigScreen(ModsScreen.this.selected.getMod().getContainer()) || ModsScreen.this.modScreenErrors.containsKey(modId);
                if (ModsScreen.this.modScreenErrors.containsKey(modId)) {
                    Throwable e = ModsScreen.this.modScreenErrors.get(modId);
                    this.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"mod_menu.configure.error", (Object[])new Object[]{modId, modId}).m_6881_().m_130946_("\n\n").m_130946_(e.toString()).m_130940_(ChatFormatting.RED)));
                } else {
                    this.m_257544_(Tooltip.m_257550_((Component)CONFIGURE));
                }
                super.m_88315_(DrawContext, mouseX, mouseY, delta);
            }

            public void m_87963_(GuiGraphics DrawContext, int mouseX, int mouseY, float delta) {
                RenderSystem.setShader(GameRenderer::m_172820_);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                super.m_87963_(DrawContext, mouseX, mouseY, delta);
            }
        };
        int urlButtonWidths = this.paneWidth / 2 - 2;
        int cappedButtonWidth = Math.min(urlButtonWidths, 200);
        Button websiteButton = new Button(this.rightPaneX + urlButtonWidths / 2 - cappedButtonWidth / 2, rightPaneY + 36, Math.min(urlButtonWidths, 200), 20, (Component)Component.m_237115_((String)"mod_menu.website"), button -> {
            Mod mod = Objects.requireNonNull(this.selected).getMod();
            this.f_96541_.m_91152_((Screen)new ConfirmLinkScreen(bool -> {
                if (bool) {
                    Util.m_137581_().m_137646_(mod.getWebsite());
                }
                this.f_96541_.m_91152_((Screen)this);
            }, mod.getWebsite(), false));
        }, Supplier::get){

            public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
                this.f_93624_ = ModsScreen.this.selected != null;
                this.f_93623_ = this.f_93624_ && ModsScreen.this.selected.getMod().getWebsite() != null;
                super.m_88315_(guiGraphics, mouseX, mouseY, delta);
            }
        };
        ImageButton badgeButton = null;
        if (!((Boolean)ModMenu.getConfig().HIDE_BADGE_BUTTONS.get()).booleanValue()) {
            badgeButton = new ImageButton(this.paneWidth / 2 + searchBoxWidth / 2 - 10 + 26, 22, 20, 20, 0, 0, 20, BADGE_BUTTON_LOCATION, 32, 64, button -> this.f_96541_.pushGuiLayer((Screen)new BadgeScreen(this.selected.mod, this.paneWidth, searchBoxWidth)), CommonComponents.f_237098_);
        }
        Button issuesButton = new Button(this.rightPaneX + urlButtonWidths + 4 + urlButtonWidths / 2 - cappedButtonWidth / 2, rightPaneY + 36, Math.min(urlButtonWidths, 200), 20, (Component)Component.m_237115_((String)"mod_menu.issues"), button -> {
            Mod mod = Objects.requireNonNull(this.selected).getMod();
            this.f_96541_.m_91152_((Screen)new ConfirmLinkScreen(bool -> {
                if (bool) {
                    Util.m_137581_().m_137646_(mod.getIssueTracker());
                }
                this.f_96541_.m_91152_((Screen)this);
            }, mod.getIssueTracker(), false));
        }, Supplier::get){

            public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
                this.f_93624_ = ModsScreen.this.selected != null;
                this.f_93623_ = this.f_93624_ && ModsScreen.this.selected.getMod().getIssueTracker() != null;
                super.m_88315_(guiGraphics, mouseX, mouseY, delta);
            }
        };
        this.m_7787_((GuiEventListener)this.searchBox);
        ImageButton filtersButton = new ImageButton(this.paneWidth / 2 + searchBoxWidth / 2 - 10 + 2, 22, 20, 20, 0, 0, 20, FILTERS_BUTTON_LOCATION, 32, 64, button -> {
            this.filterOptionsShown = !this.filterOptionsShown;
        }, TOGGLE_FILTER_OPTIONS);
        filtersButton.m_257544_(Tooltip.m_257550_((Component)TOGGLE_FILTER_OPTIONS));
        if (!((Boolean)ModMenu.getConfig().CONFIG_MODE.get()).booleanValue()) {
            this.m_142416_((GuiEventListener)filtersButton);
        }
        if (((Boolean)ModMenu.getConfig().HIDE_SCREEN_TOP.get()).booleanValue()) {
            filtersButton.f_93624_ = false;
            filtersButton.f_93623_ = false;
        }
        Component showLibrariesText = ModMenuScreenTexts.getLibrariesComponent();
        Component sortingText = ModMenuScreenTexts.getSortingComponent();
        int showLibrariesWidth = this.f_96547_.m_92852_((FormattedText)showLibrariesText) + 20;
        int sortingWidth = this.f_96547_.m_92852_((FormattedText)sortingText) + 20;
        this.filtersWidth = showLibrariesWidth + sortingWidth + 2;
        this.searchRowWidth = this.searchBoxX + searchBoxWidth + 22;
        this.updateFiltersX();
        this.m_142416_((GuiEventListener)new Button(this.filtersX, 45, sortingWidth, 20, sortingText, button -> {
            ((ModMenuConfig.Sorting)((Object)((Object)ModMenu.getConfig().SORTING.get()))).cycleValue();
            ((ForgeConfigSpec)ModMenu.CONFIG.getRight()).save();
            this.modList.reloadFilters();
        }, Supplier::get){

            public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
                guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
                this.f_93624_ = ModsScreen.this.filterOptionsShown;
                this.m_93666_(ModMenuScreenTexts.getSortingComponent());
                super.m_88315_(guiGraphics, mouseX, mouseY, delta);
            }
        });
        this.m_142416_((GuiEventListener)new Button(this.filtersX + sortingWidth + 2, 45, showLibrariesWidth, 20, showLibrariesText, button -> {
            ModMenu.getConfig().SHOW_LIBRARIES.set((Object)((Boolean)ModMenu.getConfig().SHOW_LIBRARIES.get() == false ? 1 : 0));
            ((ForgeConfigSpec)ModMenu.CONFIG.getRight()).save();
            this.modList.reloadFilters();
        }, Supplier::get){

            public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
                guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
                this.f_93624_ = ModsScreen.this.filterOptionsShown;
                this.m_93666_(ModMenuScreenTexts.getLibrariesComponent());
                super.m_88315_(guiGraphics, mouseX, mouseY, delta);
            }
        });
        this.m_7787_((GuiEventListener)this.modList);
        if (!((Boolean)ModMenu.getConfig().HIDE_CONFIG_BUTTONS.get()).booleanValue()) {
            this.m_142416_((GuiEventListener)configureButton);
        }
        if (badgeButton != null) {
            this.m_142416_((GuiEventListener)badgeButton);
        }
        this.m_142416_((GuiEventListener)websiteButton);
        this.m_142416_((GuiEventListener)issuesButton);
        this.m_7787_((GuiEventListener)this.descriptionListWidget);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"mod_menu.modsFolder"), button -> Util.m_137581_().m_137644_(FMLPaths.MODSDIR.get().toFile())).m_252794_(this.f_96543_ / 2 - 154, this.f_96544_ - 28).m_253046_(150, 20).m_252778_(Supplier::get).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.f_96541_.m_91152_(this.previousScreen)).m_252794_(this.f_96543_ / 2 + 4, this.f_96544_ - 28).m_253046_(150, 20).m_252778_(Supplier::get).m_253136_());
        this.modList.finalizeInit();
        this.searchBox.m_93692_(true);
        this.init = true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return super.m_7933_(keyCode, scanCode, modifiers) || this.searchBox.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char chr, int keyCode) {
        return this.searchBox.m_5534_(chr, keyCode);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        boolean hideTop = (Boolean)ModMenu.getConfig().HIDE_SCREEN_TOP.get();
        int rightPaneY = hideTop ? 5 : 48;
        this.m_280039_(guiGraphics);
        ModListEntry selectedEntry = this.selected;
        if (selectedEntry != null) {
            this.descriptionListWidget.m_88315_(guiGraphics, mouseX, mouseY, delta);
        }
        this.modList.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.searchBox.m_88315_(guiGraphics, mouseX, mouseY, delta);
        RenderSystem.disableBlend();
        if (!hideTop) {
            guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.modList.getWidth() / 2, 8, 0xFFFFFF);
        }
        if (!((Boolean)ModMenu.getConfig().DISABLE_DRAG_AND_DROP.get()).booleanValue() || hideTop) {
            MutableComponent mutableComponent = Component.m_237115_((String)"mod_menu.dropInfo.line1").m_130940_(ChatFormatting.GRAY);
            int n = this.f_96543_ - this.modList.getWidth() / 2;
            int n2 = rightPaneY / 2;
            Objects.requireNonNull(this.f_96541_.f_91062_);
            guiGraphics.m_280653_(this.f_96547_, (Component)mutableComponent, n, n2 - 9 - 1, 0xFFFFFF);
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"mod_menu.dropInfo.line2").m_130940_(ChatFormatting.GRAY), this.f_96543_ - this.modList.getWidth() / 2, rightPaneY / 2 + 1, 0xFFFFFF);
        }
        if (!((Boolean)ModMenu.getConfig().CONFIG_MODE.get()).booleanValue()) {
            Component fullModCount = this.computeModCountText(true);
            if (!((Boolean)ModMenu.getConfig().CONFIG_MODE.get()).booleanValue() && this.updateFiltersX()) {
                int showingModTextY = hideTop ? 6 : 46;
                if (!((Boolean)ModMenu.getConfig().SHOW_LIBRARIES.get()).booleanValue() || this.f_96547_.m_92852_((FormattedText)fullModCount) <= (this.filterOptionsShown ? this.filtersX : this.modList.getWidth()) - 5) {
                    guiGraphics.m_280649_(this.f_96547_, fullModCount.m_7532_(), this.searchBoxX, showingModTextY + 6, 0xFFFFFF, true);
                } else {
                    guiGraphics.m_280649_(this.f_96547_, this.computeModCountText(false).m_7532_(), this.searchBoxX, showingModTextY, 0xFFFFFF, true);
                    guiGraphics.m_280649_(this.f_96547_, this.computeLibraryCountText().m_7532_(), this.searchBoxX, showingModTextY + 11, 0xFFFFFF, true);
                }
            }
        }
        if (selectedEntry != null) {
            List<String> names;
            MutableComponent name;
            Mod mod = selectedEntry.getMod();
            int x = this.rightPaneX;
            if ("java".equals(mod.getId())) {
                DrawingUtil.drawRandomVersionBackground(mod, guiGraphics, x, rightPaneY, 32, 32);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            Tuple<ResourceLocation, Dimension> iconProperties = selectedEntry.getIconTexture();
            int imageOffset = ((Dimension)iconProperties.m_14419_()).width;
            int imageHeight = ((Dimension)iconProperties.m_14419_()).height;
            guiGraphics.m_280163_((ResourceLocation)iconProperties.m_14418_(), x, rightPaneY, 0.0f, 0.0f, imageOffset, imageHeight, imageOffset, imageHeight);
            imageOffset += 4;
            RenderSystem.disableBlend();
            Objects.requireNonNull(this.f_96547_);
            int lineSpacing = 9 + 1;
            MutableComponent trimmedName = name = Component.m_237113_((String)mod.getTranslatedName());
            int maxNameWidth = this.f_96543_ - (x + imageOffset);
            if (this.f_96547_.m_92852_((FormattedText)name) > maxNameWidth) {
                FormattedText ellipsis = FormattedText.m_130775_((String)"...");
                trimmedName = FormattedText.m_130773_((FormattedText[])new FormattedText[]{this.f_96547_.m_92854_((FormattedText)name, maxNameWidth - this.f_96547_.m_92852_(ellipsis)), ellipsis});
            }
            guiGraphics.m_280649_(this.f_96547_, Language.m_128107_().m_5536_((FormattedText)trimmedName), x + imageOffset, rightPaneY + 1, 0xFFFFFF, false);
            if (mouseX > x + imageOffset && mouseY > rightPaneY + 1) {
                Objects.requireNonNull(this.f_96547_);
                if (mouseY < rightPaneY + 1 + 9 && mouseX < x + imageOffset + this.f_96547_.m_92852_((FormattedText)trimmedName)) {
                    this.m_257404_((Component)Component.m_237110_((String)"mod_menu.modIdToolTip", (Object[])new Object[]{mod.getId()}));
                }
            }
            if (this.init || this.modBadgeRenderer == null || this.modBadgeRenderer.getMod() != mod) {
                this.modBadgeRenderer = new ModBadgeRenderer(x + imageOffset + this.f_96541_.f_91062_.m_92852_((FormattedText)trimmedName) + 2, rightPaneY, this.f_96543_ - 28, selectedEntry.mod, this);
                this.init = false;
            }
            if (!((Boolean)ModMenu.getConfig().HIDE_BADGES.get()).booleanValue()) {
                this.modBadgeRenderer.draw(guiGraphics);
            }
            if (mod.isReal()) {
                guiGraphics.m_280056_(this.f_96547_, mod.getPrefixedVersion(), x + imageOffset, rightPaneY + 2 + lineSpacing, 0x808080, false);
            }
            if (!(names = mod.getAuthors()).isEmpty()) {
                String authors = names.size() > 1 ? Joiner.on((String)", ").join(names) : names.get(0);
                DrawingUtil.drawWrappedString(guiGraphics, I18n.m_118938_((String)"mod_menu.authorPrefix", (Object[])new Object[]{authors}), x + imageOffset, rightPaneY + 2 + lineSpacing * 2, this.paneWidth - imageOffset - 4, 1, 0x808080);
            }
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
    }

    private Component computeModCountText(boolean includeLibs) {
        int[] rootMods = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && !mod.getBadges().contains(ModBadge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
        if (includeLibs && ((Boolean)ModMenu.getConfig().SHOW_LIBRARIES.get()).booleanValue()) {
            int[] rootLibs = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && mod.getBadges().contains(ModBadge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
            return TranslationUtil.translateNumeric("mod_menu.showingModsLibraries", rootMods, rootLibs);
        }
        return TranslationUtil.translateNumeric("mod_menu.showingMods", new int[][]{rootMods});
    }

    private Component computeLibraryCountText() {
        if (((Boolean)ModMenu.getConfig().SHOW_LIBRARIES.get()).booleanValue()) {
            int[] rootLibs = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && mod.getBadges().contains(ModBadge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
            return TranslationUtil.translateNumeric("mod_menu.showingLibraries", new int[][]{rootLibs});
        }
        return Component.m_237113_(null);
    }

    private int[] formatModCount(Set<String> set) {
        int total;
        int visible = this.modList.getDisplayedCountFor(set);
        if (visible == (total = set.size())) {
            return new int[]{total};
        }
        return new int[]{visible, total};
    }

    public void m_7379_() {
        this.modList.close();
        this.f_96541_.m_91152_(this.previousScreen);
    }

    public ModListEntry getSelectedEntry() {
        return this.selected;
    }

    public void updateSelectedEntry(ModListEntry entry) {
        if (entry != null) {
            this.selected = entry;
            this.descriptionListWidget.updateSelectedModIfRequired(this.selected.getMod());
        }
    }

    public double getScrollPercent() {
        return this.scrollPercent;
    }

    public void updateScrollPercent(double scrollPercent) {
        this.scrollPercent = scrollPercent;
    }

    public String getSearchInput() {
        return this.searchBox.m_94155_();
    }

    private boolean updateFiltersX() {
        if (this.filtersWidth + this.f_96547_.m_92852_((FormattedText)this.computeModCountText(true)) + 20 >= this.searchRowWidth && (this.filtersWidth + this.f_96547_.m_92852_((FormattedText)this.computeModCountText(false)) + 20 >= this.searchRowWidth || this.filtersWidth + this.f_96547_.m_92852_((FormattedText)this.computeLibraryCountText()) + 20 >= this.searchRowWidth)) {
            this.filtersX = this.paneWidth / 2 - this.filtersWidth / 2;
            return !this.filterOptionsShown;
        }
        this.filtersX = this.searchRowWidth - this.filtersWidth + 1;
        return true;
    }

    public void m_7400_(List<Path> paths) {
        Path modsDirectory = FabricLoader.getInstance().getGameDir().resolve("mods");
        List<Path> mods = paths.stream().filter(ModsScreen::isMod).toList();
        if (mods.isEmpty()) {
            return;
        }
        String modList = mods.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.joining(", "));
        this.f_96541_.m_91152_((Screen)new ConfirmScreen(value -> {
            if (value) {
                boolean allSuccessful = true;
                for (Path path : mods) {
                    try {
                        Files.copy(path, modsDirectory.resolve(path.getFileName()), new CopyOption[0]);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Failed to copy mod from {} to {}", (Object)path, (Object)modsDirectory.resolve(path.getFileName()));
                        SystemToast.m_94875_((Minecraft)this.f_96541_, (String)path.toString());
                        allSuccessful = false;
                        break;
                    }
                }
                if (allSuccessful) {
                    SystemToast.m_94855_((ToastComponent)this.f_96541_.m_91300_(), (SystemToast.SystemToastIds)SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)Component.m_237115_((String)"mod_menu.dropSuccessful.line1"), (Component)Component.m_237115_((String)"mod_menu.dropSuccessful.line2"));
                }
            }
            this.f_96541_.m_91152_((Screen)this);
        }, (Component)Component.m_237115_((String)"mod_menu.dropConfirm"), (Component)Component.m_237113_((String)modList)));
    }

    private static boolean isFabricMod(Path mod) {
        boolean bl;
        JarFile jarFile = new JarFile(mod.toFile());
        try {
            bl = jarFile.getEntry("fabric.mod.json") != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        jarFile.close();
        return bl;
    }

    private static boolean isMod(Path mod) {
        return ModsScreen.isFabricMod(mod) || ModsScreen.isNeoforgeMod(mod);
    }

    private static boolean isNeoforgeMod(Path mod) {
        boolean bl;
        JarFile jarFile = new JarFile(mod.toFile());
        try {
            bl = jarFile.getEntry("META-INF/mods.toml") != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        jarFile.close();
        return bl;
    }

    public boolean getModHasConfigScreen(Optional<ModContainer> optionalModContainer) {
        if (optionalModContainer.isEmpty()) {
            return false;
        }
        ModContainer container = optionalModContainer.get();
        if (this.modScreenErrors.containsKey(container.getModId())) {
            return false;
        }
        return this.modHasConfigScreen.computeIfAbsent(container, ModMenu::hasConfigScreen);
    }

    public void safelyOpenConfigScreen(ModContainer modId) {
        try {
            Screen screen = ModMenu.getConfigScreen(modId, this);
            if (screen != null) {
                this.f_96541_.m_91152_(screen);
            }
        }
        catch (NoClassDefFoundError e) {
            LOGGER.warn("The '" + String.valueOf(modId) + "' mod config screen is not available because " + e.getLocalizedMessage() + " is missing.");
            this.modScreenErrors.put(modId.getModId(), e);
        }
        catch (Throwable e) {
            LOGGER.error("Error from mod '" + String.valueOf(modId) + "'", e);
            this.modScreenErrors.put(modId.getModId(), e);
        }
    }
}

