/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu.gui;

import com.terraformersmc.mod_menu.ModMenu;
import com.terraformersmc.mod_menu.config.ModMenuConfig;
import com.terraformersmc.mod_menu.gui.ModsScreen;
import com.terraformersmc.mod_menu.gui.widget.BadgeToogleButton;
import com.terraformersmc.mod_menu.util.DrawingUtil;
import com.terraformersmc.mod_menu.util.mod.Mod;
import com.terraformersmc.mod_menu.util.mod.ModBadge;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import org.jetbrains.annotations.Nullable;

public class BadgeScreen
extends Screen {
    @Nullable
    private AbstractWidget badgeButton;
    private final Mod mod;
    private final int posX;

    protected BadgeScreen(Mod mod, int paneWidth, int searchBoxWidth) {
        super(CommonComponents.f_237098_);
        this.mod = mod;
        this.posX = paneWidth / 2 + searchBoxWidth / 2 - 10 + 26;
    }

    public void m_7379_() {
        ModMenu.getConfig().save();
        super.m_7379_();
    }

    protected void m_7856_() {
        this.badgeButton = new ImageButton(this.posX, 22, 20, 20, 0, 0, 20, ModsScreen.BADGE_BUTTON_LOCATION, 32, 64, button -> this.m_7379_(), CommonComponents.f_237098_);
        this.m_142416_((GuiEventListener)this.badgeButton);
        int i = 0;
        int buttonX = this.posX - 11;
        for (Map<String, ModBadge> badgeMap : ModBadge.BADGES) {
            for (Map.Entry<String, ModBadge> badgeEntry : badgeMap.entrySet()) {
                ModBadge badge = badgeEntry.getValue();
                this.m_142416_((GuiEventListener)BadgeToogleButton.badgeButtonBuilder(CommonComponents.f_237098_, button -> {
                    ModMenuConfig config = ModMenu.getConfig();
                    if (this.mod.getBadges().contains(badge)) {
                        this.mod.getBadges().remove(badge);
                        config.mod_badges.get(this.mod.getId()).remove(badgeEntry.getKey());
                        if (this.mod.getBadgeNames().contains(badgeEntry.getKey())) {
                            config.disabled_mod_badges.computeIfAbsent(this.mod.getId(), v -> new LinkedHashSet()).add((String)badgeEntry.getKey());
                        }
                    } else {
                        this.mod.getBadges().add(badge);
                        Set<String> disabled_badges = config.disabled_mod_badges.get(this.mod.getId());
                        if (disabled_badges != null && disabled_badges.contains(badgeEntry.getKey())) {
                            disabled_badges.remove(badgeEntry.getKey());
                        } else {
                            config.mod_badges.get(this.mod.getId()).add((String)badgeEntry.getKey());
                        }
                    }
                    ((BadgeToogleButton)button).toggle();
                }, this.mod.getBadges().contains(badge)).position(buttonX, 43 + 11 * i).size(11, 11).uv(0, 0, 11).build());
                ++i;
            }
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        int i = 0;
        for (Map<String, ModBadge> badges : ModBadge.BADGES) {
            for (Map.Entry<String, ModBadge> mapEntry : badges.entrySet()) {
                ModBadge badge = mapEntry.getValue();
                int badgeWidth = this.f_96541_.f_91062_.m_92724_(badge.getComponent().m_7532_()) + 6;
                DrawingUtil.drawBadge(guiGraphics, this.posX, 43 + 11 * i, badgeWidth, badge.getComponent().m_7532_(), badge.getOutlineColor(), badge.getFillColor(), badge.getTextColor());
                ++i;
            }
        }
    }
}

