/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraftforge.eventbus.LogMarkers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class EventAccessTransformer {
    private static final Logger LOGGER = LogManager.getLogger();

    public boolean transform(ClassNode classNode, Type classType) {
        AtomicBoolean changes = new AtomicBoolean();
        classNode.methods.stream().filter(m -> Optional.ofNullable(m.visibleAnnotations).orElse(Collections.emptyList()).stream().anyMatch(a -> Objects.equals(a.desc, "Lnet/minecraftforge/eventbus/api/SubscribeEvent;"))).peek(m -> {
            if (Modifier.isPrivate(m.access)) {
                this.illegalPrivateAccess((MethodNode)m, classNode);
            }
        }).filter(m -> !Modifier.isPrivate(m.access)).peek(mn -> LOGGER.debug(LogMarkers.EVENTBUS, "Transforming @SubscribeEvent method to public {}.{}", (Object)classNode.name, (Object)mn.name)).peek($ -> {
            classNode.access = EventAccessTransformer.changeAccess(classNode.access, changes);
        }).forEach(mn1 -> this.toPublic((MethodNode)mn1, changes));
        return changes.get();
    }

    private void illegalPrivateAccess(MethodNode mn, ClassNode cn) {
        LOGGER.error(LogMarkers.EVENTBUS, "Illegal private member annotated as @SubscribeEvent : {}.{}", (Object)cn.name, (Object)mn.name);
        throw new RuntimeException("Illegal private member with @SubscribeEvent annotation");
    }

    private static int changeAccess(int access, AtomicBoolean changeTracking) {
        int ax = access & 0xFFFFFFF9 | 1;
        changeTracking.compareAndSet(false, ax != access);
        return ax;
    }

    private void toPublic(MethodNode mn, AtomicBoolean changeTracking) {
        mn.access = EventAccessTransformer.changeAccess(mn.access, changeTracking);
    }
}

